/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.item.gem;

import daripher.skilltree.item.ItemHelper;
import daripher.skilltree.item.gem.GemItem;
import daripher.skilltree.util.TooltipHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;

public abstract class SimpleGemItem
extends GemItem {
    private Triple<Attribute, Double, AttributeModifier.Operation> helmetBonus;
    private Triple<Attribute, Double, AttributeModifier.Operation> chestplateBonus;
    private Triple<Attribute, Double, AttributeModifier.Operation> leggingsBonus;
    private Triple<Attribute, Double, AttributeModifier.Operation> bootsBonus;
    private Triple<Attribute, Double, AttributeModifier.Operation> weaponBonus;
    private Triple<Attribute, Double, AttributeModifier.Operation> shieldBonus;
    private Triple<Attribute, Double, AttributeModifier.Operation> bowBonus;
    private Triple<Attribute, Double, AttributeModifier.Operation> pickaxeBonus;

    public SimpleGemItem(int color) {
        super(color);
    }

    @Override
    public Triple<Attribute, Double, AttributeModifier.Operation> getGemBonus(Player player, ItemStack itemStack) {
        EquipmentSlot itemSlot = ItemHelper.getSlotForItem(itemStack);
        if (ItemHelper.isPickaxe(itemStack) && itemSlot == EquipmentSlot.MAINHAND) {
            return this.getPickaxeBonus();
        }
        if (ItemHelper.isMeleeWeapon(itemStack) && itemSlot == EquipmentSlot.MAINHAND) {
            return this.getWeaponBonus();
        }
        if (ItemHelper.isShield(itemStack) && itemSlot == EquipmentSlot.OFFHAND) {
            return this.getShieldBonus();
        }
        if (ItemHelper.isHelmet(itemStack) && itemSlot == EquipmentSlot.HEAD) {
            return this.getHelmetBonus();
        }
        if (ItemHelper.isChestplate(itemStack) && itemSlot == EquipmentSlot.CHEST) {
            return this.getChestplateBonus();
        }
        if (ItemHelper.isLeggings(itemStack) && itemSlot == EquipmentSlot.LEGS) {
            return this.getLeggingsBonus();
        }
        if (ItemHelper.isBoots(itemStack) && itemSlot == EquipmentSlot.FEET) {
            return this.getBootsBonus();
        }
        if (ItemHelper.isRangedWeapon(itemStack) && itemSlot == EquipmentSlot.MAINHAND) {
            return this.getBowBonus();
        }
        return null;
    }

    public Triple<Attribute, Double, AttributeModifier.Operation> getHelmetBonus() {
        return this.helmetBonus;
    }

    public Triple<Attribute, Double, AttributeModifier.Operation> getChestplateBonus() {
        return this.chestplateBonus;
    }

    public Triple<Attribute, Double, AttributeModifier.Operation> getLeggingsBonus() {
        return this.leggingsBonus;
    }

    public Triple<Attribute, Double, AttributeModifier.Operation> getBootsBonus() {
        return this.bootsBonus;
    }

    public Triple<Attribute, Double, AttributeModifier.Operation> getWeaponBonus() {
        return this.weaponBonus;
    }

    public Triple<Attribute, Double, AttributeModifier.Operation> getShieldBonus() {
        return this.shieldBonus;
    }

    public Triple<Attribute, Double, AttributeModifier.Operation> getBowBonus() {
        return this.bowBonus;
    }

    public Triple<Attribute, Double, AttributeModifier.Operation> getPickaxeBonus() {
        return this.pickaxeBonus;
    }

    public List<Triple<Attribute, Double, AttributeModifier.Operation>> getBonuses() {
        return Arrays.asList(this.helmetBonus, this.chestplateBonus, this.leggingsBonus, this.bootsBonus, this.weaponBonus, this.shieldBonus, this.bowBonus, this.pickaxeBonus).stream().filter(Objects::nonNull).toList();
    }

    protected void setHelmetBonus(Attribute attribute, double value, AttributeModifier.Operation operation) {
        this.helmetBonus = Triple.of((Object)attribute, (Object)value, (Object)operation);
    }

    protected void setChestplateBonus(Attribute attribute, double value, AttributeModifier.Operation operation) {
        this.chestplateBonus = Triple.of((Object)attribute, (Object)value, (Object)operation);
    }

    protected void setLeggingsBonus(Attribute attribute, double value, AttributeModifier.Operation operation) {
        this.leggingsBonus = Triple.of((Object)attribute, (Object)value, (Object)operation);
    }

    protected void setBootsBonus(Attribute attribute, double value, AttributeModifier.Operation operation) {
        this.bootsBonus = Triple.of((Object)attribute, (Object)value, (Object)operation);
    }

    protected void setWeaponBonus(Attribute attribute, double value, AttributeModifier.Operation operation) {
        this.weaponBonus = Triple.of((Object)attribute, (Object)value, (Object)operation);
    }

    protected void setShieldBonus(Attribute attribute, double value, AttributeModifier.Operation operation) {
        this.shieldBonus = Triple.of((Object)attribute, (Object)value, (Object)operation);
    }

    protected void setBowBonus(Attribute attribute, double value, AttributeModifier.Operation operation) {
        this.bowBonus = Triple.of((Object)attribute, (Object)value, (Object)operation);
    }

    protected void setPickaxeBonus(Attribute attribute, double value, AttributeModifier.Operation operation) {
        this.pickaxeBonus = Triple.of((Object)attribute, (Object)value, (Object)operation);
    }

    protected void setArmorBonus(Attribute attribute, float value, AttributeModifier.Operation operation) {
        this.setHelmetBonus(attribute, value, operation);
        this.setChestplateBonus(attribute, value, operation);
        this.setLeggingsBonus(attribute, value, operation);
        this.setBootsBonus(attribute, value, operation);
    }

    protected void setArmorAndShieldBonus(Attribute attribute, float value, AttributeModifier.Operation operation) {
        this.setArmorBonus(attribute, value, operation);
        this.setShieldBonus(attribute, value, operation);
    }

    protected void setAllBonuses(Attribute attribute, float value, AttributeModifier.Operation operation) {
        this.setArmorAndShieldBonus(attribute, value, operation);
        this.setWeaponBonus(attribute, value, operation);
        this.setBowBonus(attribute, value, operation);
        this.setPickaxeBonus(attribute, value, operation);
    }

    protected Component getBonusTooltip(String slot, Triple<Attribute, Double, AttributeModifier.Operation> bonus) {
        MutableComponent slotTooltip = Component.m_237115_((String)("gem.slot." + slot)).m_130940_(ChatFormatting.GOLD);
        MutableComponent bonusTooltip = TooltipHelper.getAttributeBonusTooltip(bonus);
        return Component.m_237119_().m_7220_((Component)slotTooltip).m_7220_((Component)bonusTooltip);
    }
}

