/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.mixin.apotheosis;

import daripher.skilltree.init.SkillTreeAttributes;
import daripher.skilltree.item.ItemHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import shadows.apotheosis.adventure.client.AdventureModuleClient;

@Mixin(value={AdventureModuleClient.class}, remap=false)
public class MixinAdventureModuleClient {
    private static final String ADDITIONAL_GEMS_TAG = "ADDITIONAL_GEMS";

    @ModifyArg(method={"comps"}, at=@At(value="INVOKE", target="Lshadows/apotheosis/adventure/affix/socket/SocketHelper;getGems(Lnet/minecraft/world/item/ItemStack;I)Ljava/util/List;"), index=1)
    private static int showAdditionalSockets(ItemStack itemStack, int sockets) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null || minecraft.f_91074_ == null) {
            return sockets;
        }
        int additionalSockets = MixinAdventureModuleClient.getAdditionalSockets(itemStack, (Player)minecraft.f_91074_);
        return sockets + additionalSockets;
    }

    private static int getAdditionalSockets(ItemStack itemStack, Player player) {
        int playerMaxSockets = MixinAdventureModuleClient.getMaxSockets(player, itemStack);
        int additionalGems = MixinAdventureModuleClient.getAdditionalGems(itemStack);
        int additionalSockets = Math.max(0, playerMaxSockets - additionalGems);
        return additionalSockets;
    }

    private static int getAdditionalGems(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return 0;
        }
        return itemStack.m_41783_().m_128451_(ADDITIONAL_GEMS_TAG);
    }

    private static int getMaxSockets(Player player, ItemStack itemStack) {
        int maxSockets = (int)player.m_21133_((Attribute)SkillTreeAttributes.MAXIMUM_SOCKETS.get());
        if (ItemHelper.isChestplate(itemStack)) {
            Attribute chestplateSockets = (Attribute)SkillTreeAttributes.MAXIMUM_CHESTPLATE_SOCKETS.get();
            maxSockets += (int)player.m_21133_(chestplateSockets);
        }
        if (ItemHelper.isWeapon(itemStack)) {
            Attribute weaponSockets = (Attribute)SkillTreeAttributes.MAXIMUM_WEAPON_SOCKETS.get();
            maxSockets += (int)player.m_21133_(weaponSockets);
        }
        return maxSockets;
    }
}

