/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.mixin.apotheosis;

import daripher.skilltree.gem.GemHelper;
import daripher.skilltree.item.ItemHelper;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixInstance;
import shadows.apotheosis.adventure.affix.socket.SocketHelper;

@Mixin(value={SocketHelper.class}, remap=false)
public class MixinSocketHelper {
    private static final String ADDITIONAL_SOCKET_TAG = "ADDITIONAL_SOCKET";
    private static final String ADDITIONAL_GEMS_TAG = "ADDITIONAL_GEMS";

    @ModifyVariable(method={"getGems(Lnet/minecraft/world/item/ItemStack;I)Ljava/util/List;"}, at=@At(value="HEAD"), ordinal=0)
    private static int applyAdditionalGems(int sockets, ItemStack stack, int sockets_) {
        if (!stack.m_41782_()) {
            return sockets;
        }
        if (!stack.m_41783_().m_128441_(ADDITIONAL_GEMS_TAG)) {
            return sockets;
        }
        int additionalGems = stack.m_41783_().m_128451_(ADDITIONAL_GEMS_TAG);
        return sockets + additionalGems;
    }

    @Inject(method={"setGems"}, at={@At(value="HEAD")}, cancellable=true)
    private static void setAdditionalGems(ItemStack stack, List<ItemStack> gems, CallbackInfo callbackInfo) {
        int sockets = MixinSocketHelper.getSockets(stack);
        if (gems.size() <= sockets) {
            if (!stack.m_41782_()) {
                return;
            }
            if (!stack.m_41783_().m_128441_(ADDITIONAL_GEMS_TAG)) {
                return;
            }
            stack.m_41784_().m_128473_(ADDITIONAL_GEMS_TAG);
            return;
        }
        int additionalGems = gems.size() - sockets;
        stack.m_41784_().m_128405_(ADDITIONAL_GEMS_TAG, additionalGems);
    }

    @Inject(method={"getSockets"}, at={@At(value="HEAD")})
    private static void addAdditionalSockets(ItemStack stack, CallbackInfoReturnable<Integer> callbackInfo) {
        if (!ItemHelper.isEquipment(stack)) {
            return;
        }
        AffixInstance socketAffix = (AffixInstance)AffixHelper.getAffixes((ItemStack)stack).get(Apoth.Affixes.SOCKET.get());
        if (socketAffix == null) {
            SocketHelper.setSockets((ItemStack)stack, (int)1);
        }
        if (GemHelper.hasAdditionalSocket(stack) && !MixinSocketHelper.hasAdditionalSocket(stack)) {
            MixinSocketHelper.setHasAdditionalSocket(stack);
            int sockets = (int)((AffixInstance)AffixHelper.getAffixes((ItemStack)stack).get(Apoth.Affixes.SOCKET.get())).level();
            SocketHelper.setSockets((ItemStack)stack, (int)(sockets + 1));
        }
    }

    private static boolean hasAdditionalSocket(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(ADDITIONAL_SOCKET_TAG);
    }

    private static void setHasAdditionalSocket(ItemStack stack) {
        stack.m_41784_().m_128379_(ADDITIONAL_SOCKET_TAG, true);
    }

    @Shadow
    private static int getSockets(ItemStack stack) {
        return 0;
    }

    @Shadow
    private static List<ItemStack> getGems(ItemStack stack, int size) {
        return null;
    }
}

