/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.mixin.apotheosis;

import daripher.skilltree.api.PlayerContainer;
import daripher.skilltree.init.SkillTreeAttributes;
import daripher.skilltree.item.ItemHelper;
import daripher.skilltree.util.PlayerHelper;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import shadows.apotheosis.adventure.affix.socket.SocketHelper;
import shadows.apotheosis.adventure.affix.socket.SocketingRecipe;
import shadows.apotheosis.adventure.affix.socket.gem.Gem;
import shadows.apotheosis.adventure.affix.socket.gem.GemItem;

@Mixin(value={SocketingRecipe.class}, remap=false)
public class MixinSocketingRecipe {
    private static final String ADDITIONAL_GEMS_TAG = "ADDITIONAL_GEMS";

    @Redirect(method={"matches", "m_5818_"}, at=@At(value="INVOKE", target="Lshadows/apotheosis/adventure/affix/socket/SocketHelper;hasEmptySockets(Lnet/minecraft/world/item/ItemStack;)Z"))
    private boolean bypassMaximumSockets(ItemStack itemStack, Container container, Level level) {
        if (!(container instanceof PlayerContainer)) {
            return SocketHelper.hasEmptySockets((ItemStack)itemStack);
        }
        PlayerContainer playerContainer = (PlayerContainer)container;
        Player player = playerContainer.getPlayer().orElseThrow(NullPointerException::new);
        return this.hasEmptySockets(player, itemStack);
    }

    @Inject(method={"assemble", "m_5874_"}, at={@At(value="HEAD")}, cancellable=true)
    private void bypassMaximumSocketsAndApplyGemStrength(Container container, CallbackInfoReturnable<ItemStack> callbackInfo) {
        ItemStack result = container.m_8020_(0).m_41777_();
        if (result.m_41619_()) {
            return;
        }
        result.m_41764_(1);
        int baseSockets = SocketHelper.getSockets((ItemStack)result);
        int additionalSockets = 0;
        if (container instanceof PlayerContainer) {
            PlayerContainer playerContainer = (PlayerContainer)container;
            Player player = ((PlayerContainer)container).getPlayer().orElseThrow(NullPointerException::new);
            additionalSockets = MixinSocketingRecipe.getAdditionalSockets(result, player);
        }
        int sockets = baseSockets + additionalSockets;
        List gems = SocketHelper.getGems((ItemStack)result, (int)sockets);
        for (int socket = 0; socket < gems.size(); ++socket) {
            Gem gem = GemItem.getGem((ItemStack)((ItemStack)gems.get(socket)));
            if (gem != null) continue;
            ItemStack gemStack = container.m_8020_(1).m_41777_();
            gemStack = this.increaseGemPower(gemStack, container);
            gems.set(socket, gemStack);
            break;
        }
        SocketHelper.setGems((ItemStack)result, (List)gems);
        callbackInfo.setReturnValue((Object)result);
    }

    private static int getAdditionalSockets(ItemStack itemStack, Player player) {
        int playerMaxSockets = MixinSocketingRecipe.getMaxSockets(player, itemStack);
        int additionalGems = MixinSocketingRecipe.getAdditionalGems(itemStack);
        int additionalSockets = Math.max(0, playerMaxSockets - additionalGems);
        return additionalSockets;
    }

    private ItemStack increaseGemPower(ItemStack gemStack, Container container) {
        ItemStack itemStack;
        if (!(container instanceof PlayerContainer)) {
            return gemStack;
        }
        Player player = ((PlayerContainer)container).getPlayer().orElseThrow(NullPointerException::new);
        float gemPower = PlayerHelper.getGemPower(player, itemStack = container.m_8020_(0));
        if (gemPower == 1.0f) {
            return gemStack;
        }
        gemStack.m_41784_().m_128350_("gem_power", gemPower);
        return gemStack;
    }

    private static int getMaxSockets(Player player, ItemStack itemStack) {
        int maxSockets = 0;
        maxSockets += (int)player.m_21133_((Attribute)SkillTreeAttributes.MAXIMUM_SOCKETS.get());
        if (ItemHelper.isChestplate(itemStack)) {
            Attribute chestplateSockets = (Attribute)SkillTreeAttributes.MAXIMUM_CHESTPLATE_SOCKETS.get();
            maxSockets += (int)player.m_21133_(chestplateSockets);
        }
        if (ItemHelper.isWeapon(itemStack)) {
            Attribute weaponSockets = (Attribute)SkillTreeAttributes.MAXIMUM_WEAPON_SOCKETS.get();
            maxSockets += (int)player.m_21133_(weaponSockets);
        }
        return maxSockets;
    }

    private boolean hasEmptySockets(Player player, ItemStack itemStack) {
        int playerSockets = MixinSocketingRecipe.getMaxSockets(player, itemStack);
        int additionalGems = MixinSocketingRecipe.getAdditionalGems(itemStack);
        int sockets = SocketHelper.getSockets((ItemStack)itemStack) + playerSockets - additionalGems;
        return SocketHelper.getGems((ItemStack)itemStack, (int)sockets).stream().map(GemItem::getGem).anyMatch(Objects::isNull);
    }

    private static int getAdditionalGems(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return 0;
        }
        if (!itemStack.m_41783_().m_128441_(ADDITIONAL_GEMS_TAG)) {
            return 0;
        }
        int additionalGems = itemStack.m_41783_().m_128451_(ADDITIONAL_GEMS_TAG);
        return additionalGems;
    }
}

