/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.mixin.minecraft;

import daripher.skilltree.api.PlayerContainer;
import daripher.skilltree.init.SkillTreeAttributes;
import daripher.skilltree.util.PotionHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BrewingStandBlockEntity.class})
public abstract class MixinBrewingStandBlockEntity
extends BaseContainerBlockEntity
implements PlayerContainer {
    private Optional<Player> player = Optional.empty();

    protected MixinBrewingStandBlockEntity() {
        super(null, null, null);
    }

    @Inject(method={"doBrew"}, at={@At(value="TAIL")})
    private static void enhanceBrewedPotions(Level level, BlockPos blockPos, NonNullList<ItemStack> itemStacks, CallbackInfo callbackInfo) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof PlayerContainer)) {
            return;
        }
        PlayerContainer playerContainer = (PlayerContainer)blockEntity;
        Player player = playerContainer.getPlayer().get();
        for (int slot = 0; slot < 3; ++slot) {
            ItemStack potionStack = (ItemStack)itemStacks.get(slot);
            MixinBrewingStandBlockEntity.enhancePotion(potionStack, player);
        }
    }

    private static void enhancePotion(ItemStack potionStack, Player player) {
        float durationBonus;
        float amplificationChance = (float)player.m_21133_((Attribute)SkillTreeAttributes.CHANCE_TO_BREW_STRONGER_POTION.get()) - 1.0f;
        if (PotionHelper.isHarmfulPotion(potionStack)) {
            Attribute harmfulPotionAmplificationChance = (Attribute)SkillTreeAttributes.CHANCE_TO_BREW_STRONGER_HARMFUL_POTION.get();
            amplificationChance = (float)((double)amplificationChance + (player.m_21133_(harmfulPotionAmplificationChance) - 1.0));
        }
        if (PotionHelper.isBeneficialPotion(potionStack)) {
            Attribute beneficialPotionAmplificationChance = (Attribute)SkillTreeAttributes.CHANCE_TO_BREW_STRONGER_BENEFICIAL_POTION.get();
            amplificationChance = (float)((double)amplificationChance + (player.m_21133_(beneficialPotionAmplificationChance) - 1.0));
        }
        if ((durationBonus = (float)player.m_21133_((Attribute)SkillTreeAttributes.BREWED_POTIONS_DURATION.get()) - 1.0f) == 0.0f && amplificationChance == 0.0f) {
            return;
        }
        PotionHelper.enhancePotion(potionStack, amplificationChance, durationBonus);
    }

    public AbstractContainerMenu m_7208_(int window, Inventory inventory, Player player) {
        this.setPlayer(player);
        return super.m_7208_(window, inventory, player);
    }

    @Override
    public Optional<Player> getPlayer() {
        return this.player;
    }

    @Override
    public void setPlayer(Player player) {
        this.player = Optional.of(player);
    }
}

