/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.mixin.minecraft;

import daripher.skilltree.api.PlayerContainer;
import daripher.skilltree.util.FoodHelper;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CampfireBlockEntity.class})
public class MixinCampfireBlockEntity
implements PlayerContainer {
    @Shadow
    @Final
    private NonNullList<ItemStack> f_59042_;
    @Nullable
    private Player player;

    @Inject(method={"placeFood"}, at={@At(value="HEAD")})
    private void setCookingPlayer(@Nullable Entity entity, ItemStack itemStack, int cookingTime, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (entity instanceof Player || entity == null) {
            this.player = (Player)entity;
        }
    }

    @Redirect(method={"cookTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/Containers;dropItemStack(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;)V"))
    private static void setCookedFoodBonuses(Level level, double x, double y, double z, ItemStack itemStack) {
        BlockPos pos = new BlockPos(x, y, z);
        BlockEntity blockEntity = level.m_7702_(pos);
        Player player = null;
        if (blockEntity instanceof PlayerContainer) {
            PlayerContainer playerContainer = (PlayerContainer)blockEntity;
            player = playerContainer.getPlayer().orElse(null);
        }
        if (player == null) {
            return;
        }
        FoodHelper.setCraftedFoodBonuses(itemStack, player);
        Containers.m_18992_((Level)level, (double)x, (double)y, (double)z, (ItemStack)itemStack);
    }

    @Override
    public Optional<Player> getPlayer() {
        return Optional.ofNullable(this.player);
    }

    @Override
    public void setPlayer(Player player) {
        this.player = player;
    }
}

