/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.mixin.minecraft;

import com.mojang.blaze3d.vertex.PoseStack;
import daripher.skilltree.api.PSTRecipe;
import daripher.skilltree.capability.skill.PlayerSkillsProvider;
import daripher.skilltree.client.SkillTreeClientData;
import daripher.skilltree.client.widget.SkillButton;
import daripher.skilltree.skill.PassiveSkill;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftingScreen.class})
public abstract class MixinCraftingScreen
extends AbstractContainerScreen<CraftingMenu> {
    @Shadow
    @Final
    private RecipeBookComponent f_98444_;
    private SkillButton requiredSkillButton;

    public MixinCraftingScreen() {
        super(null, null, null);
    }

    @Inject(method={"containerTick"}, at={@At(value="HEAD")})
    private void updateSkillButton(CallbackInfo callbackInfo) {
        RecipeBookPage recipeBookPage = (RecipeBookPage)ObfuscationReflectionHelper.getPrivateValue(RecipeBookComponent.class, (Object)this.f_98444_, (String)"f_100284_");
        if (!(recipeBookPage.m_100408_() instanceof PSTRecipe)) {
            if (this.requiredSkillButton != null) {
                this.m_169411_((GuiEventListener)this.requiredSkillButton);
            }
            return;
        }
        PSTRecipe lastClickedRecipe = (PSTRecipe)recipeBookPage.m_100408_();
        if (this.requiredSkillButton == null) {
            this.addRequiredSkillButton(lastClickedRecipe);
        } else if (!this.requiredSkillButton.skill.getId().equals((Object)lastClickedRecipe.getRequiredSkillId())) {
            this.m_169411_((GuiEventListener)this.requiredSkillButton);
            this.addRequiredSkillButton(lastClickedRecipe);
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void render(PoseStack poseStack, int mouseX, int mouseY, float partialTick, CallbackInfo callbackInfo) {
        if (this.requiredSkillButton != null && this.requiredSkillButton.m_198029_()) {
            this.requiredSkillButton.m_7428_(poseStack, mouseX, mouseY);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")})
    private void mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (this.requiredSkillButton != null) {
            this.m_169411_((GuiEventListener)this.requiredSkillButton);
            this.requiredSkillButton = null;
        }
    }

    private void addRequiredSkillButton(PSTRecipe recipe) {
        PassiveSkill skill = SkillTreeClientData.getSkillsForTree(new ResourceLocation("skilltree", "tree")).get(recipe.getRequiredSkillId());
        this.requiredSkillButton = new SkillButton(() -> Float.valueOf(0.0f), this.f_97735_ + 132, this.f_97736_ + 69, skill, this::buttonPressed, this::renderButtonTooltip);
        this.requiredSkillButton.f_93620_ -= this.requiredSkillButton.m_5711_() / 2;
        this.requiredSkillButton.f_93621_ -= this.requiredSkillButton.m_93694_() / 2;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (PlayerSkillsProvider.get((Player)player).hasSkill(this.requiredSkillButton.skill.getId())) {
            this.requiredSkillButton.highlighted = true;
        }
        this.m_142416_((GuiEventListener)this.requiredSkillButton);
    }

    private void buttonPressed(Button button) {
    }

    private void renderButtonTooltip(Button button, PoseStack poseStack, int mouseX, int mouseY) {
        if (!(button instanceof SkillButton)) {
            return;
        }
        SkillButton skillButton = (SkillButton)button;
        ItemStack borderStyleStack = skillButton.getTooltipBorderStyleStack();
        List<MutableComponent> tooltip = skillButton.getTooltip();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!PlayerSkillsProvider.get((Player)player).hasSkill(skillButton.skill.getId())) {
            tooltip.add(Component.m_237115_((String)"widget.skill_button.not_learned").m_130940_(ChatFormatting.RED));
        }
        this.renderComponentTooltip(poseStack, tooltip, mouseX, mouseY, borderStyleStack);
    }
}

