/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.mixin.minecraft;

import daripher.skilltree.api.PSTEnchantmentMenu;
import daripher.skilltree.api.PlayerContainer;
import daripher.skilltree.enchantment.EnchantmentHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EnchantmentMenu.class})
public abstract class MixinEnchantmentMenu
implements PlayerContainer,
PSTEnchantmentMenu {
    @Shadow
    @Final
    private DataSlot f_39452_;
    @Shadow
    @Final
    public int[] f_39446_;
    private Player player;
    private int[] costsBeforeReduction = new int[3];

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/inventory/ContainerLevelAccess;)V"}, at={@At(value="TAIL")})
    private void setPlayer(int windowId, Inventory inventory, ContainerLevelAccess levelAccess, CallbackInfo callbackInfo) {
        this.player = inventory.f_35978_;
    }

    @Redirect(method={"lambda$slotsChanged$0", "m_39483_"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/event/ForgeEventFactory;onEnchantmentLevelSet(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;IILnet/minecraft/world/item/ItemStack;I)I"))
    private int reduceLevelRequirements(Level level, BlockPos pos, int slot, int power, ItemStack itemStack, int enchantmentLevel) {
        int levelRequirement;
        this.costsBeforeReduction[slot] = levelRequirement = ForgeEventFactory.onEnchantmentLevelSet((Level)level, (BlockPos)pos, (int)slot, (int)power, (ItemStack)itemStack, (int)this.f_39446_[slot]);
        int reducedRequirement = EnchantmentHelper.reduceLevelRequirement(levelRequirement, this.player);
        return reducedRequirement;
    }

    @Redirect(method={"lambda$slotsChanged$0", "m_39483_"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/EnchantmentMenu;getEnchantmentList(Lnet/minecraft/world/item/ItemStack;II)Ljava/util/List;"))
    private List<EnchantmentInstance> amplifyEnchantmentsVisually(EnchantmentMenu menu, ItemStack itemStack, int slot, int cost) {
        List<EnchantmentInstance> enchantments = this.m_39471_(itemStack, slot, this.costsBeforeReduction[slot]);
        RandomSource random = RandomSource.m_216335_((long)this.f_39452_.m_6501_());
        EnchantmentHelper.amplifyEnchantments(enchantments, random, this.player);
        return enchantments;
    }

    @Redirect(method={"lambda$clickMenuButton$1", "m_39475_"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/EnchantmentMenu;getEnchantmentList(Lnet/minecraft/world/item/ItemStack;II)Ljava/util/List;"))
    private List<EnchantmentInstance> amplifyEnchantmentsOnButtonClick(EnchantmentMenu menu, ItemStack itemStack, int slot, int cost) {
        List<EnchantmentInstance> enchantments = this.m_39471_(itemStack, slot, this.costsBeforeReduction[slot]);
        RandomSource random = RandomSource.m_216335_((long)this.f_39452_.m_6501_());
        EnchantmentHelper.amplifyEnchantments(enchantments, random, this.player);
        return enchantments;
    }

    @Shadow
    private List<EnchantmentInstance> m_39471_(ItemStack stack, int slot, int cost) {
        return null;
    }

    @Override
    public Optional<Player> getPlayer() {
        return Optional.ofNullable(this.player);
    }

    @Override
    public void setPlayer(Player player) {
        this.player = player;
    }

    @Override
    public int[] getCostsBeforeReduction() {
        return this.costsBeforeReduction;
    }

    @Override
    public int getEnchantmentSeed() {
        return this.f_39452_.m_6501_();
    }
}

