/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.mixin.minecraft;

import daripher.skilltree.api.PSTPlayer;
import daripher.skilltree.init.SkillTreeAttributes;
import daripher.skilltree.item.ItemHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class MixinPlayer
extends LivingEntity
implements PSTPlayer {
    private int rainbowJewelInsertionSeed;

    protected MixinPlayer() {
        super(null, null);
    }

    public int m_21212_() {
        if (!ItemHelper.isRangedWeapon(this.m_21211_())) {
            return super.m_21212_();
        }
        double attackSpeedBonus = this.m_21133_(Attributes.f_22283_) - 1.0;
        if (attackSpeedBonus <= 0.0) {
            return super.m_21212_();
        }
        int useDuration = this.m_21211_().m_41779_() - this.f_20936_;
        return (int)((double)this.f_20936_ - (double)useDuration * attackSpeedBonus);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readRainbowJewelInsertionSeed(CompoundTag tag, CallbackInfo callbackInfo) {
        this.rainbowJewelInsertionSeed = tag.m_128451_("RainbowJewelInsertionSeed");
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void writeRainbowJewelInsertionSeed(CompoundTag tag, CallbackInfo callbackInfo) {
        tag.m_128405_("RainbowJewelInsertionSeed", this.rainbowJewelInsertionSeed);
    }

    @Inject(method={"onEnchantmentPerformed"}, at={@At(value="HEAD")})
    private void restoreEnchantmentExperience(ItemStack itemStack, int enchantmentCost, CallbackInfo callbackInfo) {
        Player player = (Player)this;
        double freeEnchantmentChance = player.m_21133_((Attribute)SkillTreeAttributes.FREE_ENCHANTMENT_CHANCE.get()) - 1.0;
        if ((double)player.m_217043_().m_188501_() < freeEnchantmentChance) {
            player.m_6749_(enchantmentCost);
        }
    }

    @Override
    public int getIrisciteSeed() {
        return this.rainbowJewelInsertionSeed;
    }

    @Override
    public void updateIrisciteSeed() {
        this.rainbowJewelInsertionSeed = this.f_19796_.m_188502_();
    }
}

