/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.mixin.minecraft;

import daripher.skilltree.util.PotionHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PotionItem.class})
public class MixinPotionItem
extends Item {
    private MixinPotionItem() {
        super(null);
    }

    public Component m_7626_(ItemStack itemStack) {
        if (PotionHelper.isMixture(itemStack)) {
            return this.getMixtureName(itemStack);
        }
        if (PotionHelper.isSuperiorPotion(itemStack)) {
            return this.getSuperiorPotionName(itemStack);
        }
        return super.m_7626_(itemStack);
    }

    protected Component getMixtureName(ItemStack itemStack) {
        String mixtureId = this.getMixtureId(itemStack);
        MutableComponent translatedName = Component.m_237115_((String)mixtureId);
        if (translatedName.getString().equals(mixtureId)) {
            return Component.m_237115_((String)(this.m_5524_() + ".mixture"));
        }
        return translatedName;
    }

    protected Component getSuperiorPotionName(ItemStack itemStack) {
        ItemStack potionStack = PotionHelper.getActualPotionStack(itemStack);
        Component potionName = super.m_7626_(potionStack);
        return Component.m_237115_((String)"potion.superior").m_7220_(potionName);
    }

    @Inject(method={"appendHoverText"}, at={@At(value="TAIL")})
    public void appendAdvancedTooltip(ItemStack itemStack, Level level, List<Component> components, TooltipFlag tooltipFlag, CallbackInfo callbackInfo) {
        if (tooltipFlag != TooltipFlag.Default.ADVANCED) {
            return;
        }
        this.appendAdvancedTooltip(itemStack, level, components);
    }

    private void appendAdvancedTooltip(ItemStack itemStack, Level level, List<Component> components) {
        if (PotionHelper.isSuperiorPotion(itemStack)) {
            Potion potion = PotionHelper.getActualPotion(itemStack);
            String potionId = ForgeRegistries.POTIONS.getKey((Object)potion).toString();
            components.add((Component)Component.m_237113_((String)potionId).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (PotionHelper.isMixture(itemStack)) {
            PotionUtils.m_43547_((ItemStack)itemStack).stream().map(MobEffectInstance::m_19544_).map(MobEffect::m_19481_).map(s -> s.replaceAll("effect.", "")).map(Component::m_237113_).map(c -> c.m_130940_(ChatFormatting.DARK_GRAY)).forEach(components::add);
        }
    }

    protected String getMixtureId(ItemStack itemStack) {
        StringBuilder name = new StringBuilder(this.m_5524_() + ".mixture");
        PotionUtils.m_43547_((ItemStack)itemStack).stream().map(MobEffectInstance::m_19544_).map(MobEffect::m_19481_).map(id -> id.replaceAll("effect.", "")).forEach(id -> name.append("." + id));
        return name.toString();
    }
}

