/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.mixin.minecraft;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import daripher.skilltree.api.PSTRecipe;
import daripher.skilltree.api.PlayerContainer;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={RecipeBookComponent.class})
public class MixinRecipeBookComponent {
    @Shadow
    @Final
    private StackedContents f_100285_;
    @Shadow
    private ClientRecipeBook f_100283_;
    @Shadow
    protected RecipeBookMenu<?> f_100271_;

    @Redirect(method={"updateCollections"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Lists;newArrayList(Ljava/lang/Iterable;)Ljava/util/ArrayList;"))
    private ArrayList<RecipeCollection> removeUncraftableRecipes(Iterable<RecipeCollection> elements) {
        ArrayList collections = Lists.newArrayList(elements);
        collections.forEach(this::removeUncraftableRecipes);
        return collections;
    }

    protected void removeUncraftableRecipes(RecipeCollection recipeCollection) {
        Set craftableRecipes = (Set)ObfuscationReflectionHelper.getPrivateValue(RecipeCollection.class, (Object)recipeCollection, (String)"f_100493_");
        if (craftableRecipes.isEmpty()) {
            return;
        }
        craftableRecipes.removeIf(Predicates.not(this::canCraft));
    }

    private boolean canCraft(Recipe<?> recipe) {
        if (!(recipe instanceof PSTRecipe)) {
            return true;
        }
        if (!(this.f_100271_ instanceof PlayerContainer)) {
            return false;
        }
        return ((PSTRecipe)recipe).canCraftIn((PlayerContainer)this.f_100271_);
    }
}

