/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.network.message;

import daripher.skilltree.capability.skill.IPlayerSkills;
import daripher.skilltree.capability.skill.PlayerSkillsProvider;
import daripher.skilltree.data.SkillsDataReloader;
import daripher.skilltree.network.NetworkDispatcher;
import daripher.skilltree.network.message.SyncPlayerSkillsMessage;
import daripher.skilltree.skill.PassiveSkill;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class LearnSkillMessage {
    private ResourceLocation skillId;

    public LearnSkillMessage(PassiveSkill passiveSkill) {
        this.skillId = passiveSkill.getId();
    }

    private LearnSkillMessage() {
    }

    public static LearnSkillMessage decode(FriendlyByteBuf buf) {
        LearnSkillMessage message = new LearnSkillMessage();
        message.skillId = new ResourceLocation(buf.m_130277_());
        return message;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.skillId.toString());
    }

    public static void receive(LearnSkillMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        IPlayerSkills skillsData = PlayerSkillsProvider.get((Player)player);
        PassiveSkill passiveSkill = SkillsDataReloader.getSkillById(message.skillId);
        boolean learnedSkill = skillsData.learnSkill(player, passiveSkill);
        if (learnedSkill) {
            passiveSkill.getAttributeModifiers().forEach(pair -> {
                Attribute attribute = (Attribute)pair.getLeft();
                AttributeModifier modifier = (AttributeModifier)pair.getRight();
                AttributeInstance playerAttribute = player.m_21051_(attribute);
                if (!playerAttribute.m_22109_(modifier)) {
                    playerAttribute.m_22118_(modifier);
                }
            });
        }
        NetworkDispatcher.network_channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncPlayerSkillsMessage((Player)player));
    }
}

