/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.recipe;

import com.google.gson.JsonObject;
import daripher.skilltree.api.PlayerContainer;
import daripher.skilltree.compat.apotheosis.ApotheosisCompatibility;
import daripher.skilltree.gem.GemHelper;
import daripher.skilltree.init.SkillTreeAttributes;
import daripher.skilltree.init.SkillTreeRecipeSerializers;
import daripher.skilltree.item.ItemHelper;
import daripher.skilltree.item.gem.GemItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.tuple.Triple;

public class GemInsertionRecipe
extends UpgradeRecipe {
    public GemInsertionRecipe() {
        super(new ResourceLocation("skilltree", "gem_insertion"), Ingredient.f_43901_, Ingredient.f_43901_, ItemStack.f_41583_);
    }

    public boolean m_5818_(Container container, Level level) {
        PlayerContainer playerContainer;
        Player player;
        if (ModList.get().isLoaded("apotheosis") && ApotheosisCompatibility.ISNTANCE.adventureModuleEnabled()) {
            return false;
        }
        if (!this.isBaseIngredient(container.m_8020_(0))) {
            return false;
        }
        if (!this.m_44535_(container.m_8020_(1))) {
            return false;
        }
        GemItem gem = (GemItem)container.m_8020_(1).m_41720_();
        Triple<Attribute, Double, AttributeModifier.Operation> gemBonus = gem.getGemBonus(player = (playerContainer = (PlayerContainer)container).getPlayer().orElseThrow(NullPointerException::new), container.m_8020_(0));
        return gemBonus != null;
    }

    public ItemStack m_5874_(Container container) {
        if (ModList.get().isLoaded("apotheosis") && ApotheosisCompatibility.ISNTANCE.adventureModuleEnabled()) {
            return ItemStack.f_41583_;
        }
        PlayerContainer playerContainer = (PlayerContainer)container;
        if (!playerContainer.getPlayer().isPresent()) {
            return ItemStack.f_41583_;
        }
        Player player = playerContainer.getPlayer().get();
        ItemStack baseItem = container.m_8020_(0);
        int socket = this.getEmptySocket(baseItem, player);
        GemItem gem = (GemItem)container.m_8020_(1).m_41720_();
        if (!gem.canInsertInto(player, baseItem, socket)) {
            return ItemStack.f_41583_;
        }
        ItemStack resultItemStack = baseItem.m_41777_();
        if (baseItem.m_41783_() != null) {
            resultItemStack.m_41751_(baseItem.m_41783_().m_6426_());
        }
        double gemPower = this.getPlayerGemPower(player, baseItem);
        gem.insertInto(player, resultItemStack, socket, gemPower);
        return resultItemStack;
    }

    public double getPlayerGemPower(Player player, ItemStack itemStack) {
        double gemPower = player.m_21133_((Attribute)SkillTreeAttributes.GEM_POWER.get()) - 1.0;
        boolean isArmor = ItemHelper.isArmor(itemStack) || ItemHelper.isShield(itemStack);
        boolean isWeapon = ItemHelper.isWeapon(itemStack);
        if (isArmor) {
            double armorGemPower = player.m_21133_((Attribute)SkillTreeAttributes.GEM_POWER_IN_ARMOR.get()) - 1.0;
            gemPower += armorGemPower;
        } else if (isWeapon) {
            double weaponGemPower = player.m_21133_((Attribute)SkillTreeAttributes.GEM_POWER_IN_WEAPON.get()) - 1.0;
            gemPower += weaponGemPower;
        }
        return gemPower;
    }

    public int getEmptySocket(ItemStack baseItem, Player player) {
        int sockets = GemHelper.getMaximumSockets(baseItem, player);
        int socket = 0;
        int i = 0;
        while (i < sockets && GemHelper.hasGem(baseItem, socket = i++)) {
        }
        return socket;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean isBaseIngredient(ItemStack itemStack) {
        return ItemHelper.canInsertGem(itemStack);
    }

    public boolean m_44535_(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof GemItem;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SkillTreeRecipeSerializers.GEMSTONE_INSERTION.get();
    }

    public boolean m_142505_() {
        return false;
    }

    public static class Serializer
    implements RecipeSerializer<GemInsertionRecipe> {
        public GemInsertionRecipe fromJson(ResourceLocation id, JsonObject jsonObject) {
            return new GemInsertionRecipe();
        }

        public GemInsertionRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            return new GemInsertionRecipe();
        }

        public void toNetwork(FriendlyByteBuf buf, GemInsertionRecipe recipe) {
        }
    }
}

