/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.recipe;

import com.google.gson.JsonObject;
import daripher.skilltree.api.PlayerContainer;
import daripher.skilltree.init.SkillTreeAttributes;
import daripher.skilltree.init.SkillTreeRecipeSerializers;
import daripher.skilltree.util.PotionHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class MixtureRecipe
extends CustomRecipe {
    public MixtureRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer container, Level level) {
        boolean canMixPotions;
        PlayerContainer playerContainer = (PlayerContainer)container;
        if (!playerContainer.getPlayer().isPresent()) {
            return false;
        }
        Player player = playerContainer.getPlayer().get();
        boolean bl = canMixPotions = player.m_21133_((Attribute)SkillTreeAttributes.CAN_MIX_POTIONS.get()) >= 1.0;
        if (!canMixPotions) {
            return false;
        }
        ItemStack potionStack1 = ItemStack.f_41583_;
        ItemStack potionStack2 = ItemStack.f_41583_;
        int potionsCount = 0;
        for (int slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack stackInSlot = container.m_8020_(slot);
            if (stackInSlot.m_41619_() || !PotionHelper.isPotion(stackInSlot) || PotionHelper.isMixture(stackInSlot)) continue;
            ++potionsCount;
            if (potionStack1.m_41619_()) {
                potionStack1 = stackInSlot;
                continue;
            }
            potionStack2 = stackInSlot;
        }
        if (PotionUtils.m_43547_((ItemStack)potionStack1).isEmpty() || PotionUtils.m_43547_((ItemStack)potionStack2).isEmpty()) {
            return false;
        }
        return potionsCount == 2 && potionStack1.m_41720_() == potionStack2.m_41720_();
    }

    public ItemStack assemble(CraftingContainer container) {
        ItemStack potionStack1 = ItemStack.f_41583_;
        ItemStack potionStack2 = ItemStack.f_41583_;
        for (int slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack stackInSlot = container.m_8020_(slot);
            if (stackInSlot.m_41619_() || !PotionHelper.isPotion(stackInSlot) || PotionHelper.isMixture(stackInSlot)) continue;
            if (potionStack1.m_41619_()) {
                potionStack1 = stackInSlot;
                continue;
            }
            potionStack2 = stackInSlot;
        }
        ItemStack result = PotionHelper.mixPotions(potionStack1, potionStack2);
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SkillTreeRecipeSerializers.POTION_MIXING.get();
    }

    public static class Serializer
    implements RecipeSerializer<MixtureRecipe> {
        public MixtureRecipe fromJson(ResourceLocation id, JsonObject jsonObject) {
            return new MixtureRecipe(id);
        }

        public MixtureRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            return new MixtureRecipe(id);
        }

        public void toNetwork(FriendlyByteBuf buf, MixtureRecipe recipe) {
        }
    }
}

