/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.recipe;

import com.google.gson.JsonObject;
import daripher.skilltree.api.PlayerContainer;
import daripher.skilltree.init.SkillTreeAttributes;
import daripher.skilltree.init.SkillTreeRecipeSerializers;
import daripher.skilltree.item.ItemHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class WeaponPoisoningRecipe
extends CustomRecipe {
    public WeaponPoisoningRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer container, Level level) {
        boolean canPoison;
        PlayerContainer playerContainer = (PlayerContainer)container;
        if (!playerContainer.getPlayer().isPresent()) {
            return false;
        }
        Player player = playerContainer.getPlayer().get();
        boolean bl = canPoison = player.m_21133_((Attribute)SkillTreeAttributes.CAN_POISON_WEAPONS.get()) >= 1.0;
        if (!canPoison) {
            return false;
        }
        int weaponsCount = 0;
        int poisonsCount = 0;
        for (int slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack stackInSlot = container.m_8020_(slot);
            if (stackInSlot.m_41619_()) continue;
            if (ItemHelper.isMeleeWeapon(stackInSlot)) {
                ++weaponsCount;
                continue;
            }
            if (!ItemHelper.isPoison(stackInSlot)) continue;
            ++poisonsCount;
        }
        return weaponsCount == 1 && poisonsCount == 1;
    }

    public ItemStack assemble(CraftingContainer container) {
        ItemStack weaponStack = ItemStack.f_41583_;
        ItemStack poisonStack = ItemStack.f_41583_;
        for (int slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack stackInSlot = container.m_8020_(slot);
            if (stackInSlot.m_41619_()) continue;
            if (ItemHelper.isMeleeWeapon(stackInSlot)) {
                weaponStack = stackInSlot;
            }
            if (!ItemHelper.isPoison(stackInSlot)) continue;
            poisonStack = stackInSlot;
        }
        ItemStack result = weaponStack.m_41777_();
        ItemHelper.setPoisons(result, poisonStack);
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SkillTreeRecipeSerializers.WEAPON_POISONING.get();
    }

    public static class Serializer
    implements RecipeSerializer<WeaponPoisoningRecipe> {
        public WeaponPoisoningRecipe fromJson(ResourceLocation id, JsonObject jsonObject) {
            return new WeaponPoisoningRecipe(id);
        }

        public WeaponPoisoningRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            return new WeaponPoisoningRecipe(id);
        }

        public void toNetwork(FriendlyByteBuf buf, WeaponPoisoningRecipe recipe) {
        }
    }
}

