/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class PassiveSkill {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ResourceLocation id;
    private final ResourceLocation treeId;
    private final ResourceLocation backgroundTexture;
    private final ResourceLocation iconTexture;
    @Nullable
    private ResourceLocation connectedTreeId;
    private final int buttonSize;
    private final boolean isStartingPoint;
    private List<Pair<Attribute, AttributeModifier>> attributeModifiers = new ArrayList<Pair<Attribute, AttributeModifier>>();
    private final List<ResourceLocation> connectedSkills = new ArrayList<ResourceLocation>();
    private int positionX;
    private int positionY;

    public PassiveSkill(ResourceLocation id, ResourceLocation treeId, int buttonSize, ResourceLocation backgroundTexture, ResourceLocation iconTexture, boolean isStartingPoint) {
        this.id = id;
        this.treeId = treeId;
        this.backgroundTexture = backgroundTexture;
        this.iconTexture = iconTexture;
        this.buttonSize = buttonSize;
        this.isStartingPoint = isStartingPoint;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ResourceLocation getTreeId() {
        return this.treeId;
    }

    public int getButtonSize() {
        return this.buttonSize;
    }

    public ResourceLocation getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public ResourceLocation getIconTexture() {
        return this.iconTexture;
    }

    @Nullable
    public ResourceLocation getConnectedTreeId() {
        return this.connectedTreeId;
    }

    public void setConnectedTree(ResourceLocation treeId) {
        this.connectedTreeId = treeId;
    }

    public boolean isStartingPoint() {
        return this.isStartingPoint;
    }

    public List<Pair<Attribute, AttributeModifier>> getAttributeModifiers() {
        return this.attributeModifiers;
    }

    public void addAttributeBonus(Attribute attribute, AttributeModifier modifier) {
        this.attributeModifiers.add((Pair<Attribute, AttributeModifier>)Pair.of((Object)attribute, (Object)modifier));
    }

    public void connect(PassiveSkill otherSkill) {
        this.connectedSkills.add(otherSkill.getId());
    }

    public void setPosition(int x, int y) {
        this.positionX = x;
        this.positionY = y;
    }

    public int getPositionX() {
        return this.positionX;
    }

    public int getPositionY() {
        return this.positionY;
    }

    public List<ResourceLocation> getConnectedSkills() {
        return this.connectedSkills;
    }

    public JsonObject writeToJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("button_size", (Number)this.getButtonSize());
        jsonObject.addProperty("tree", this.getTreeId().toString());
        jsonObject.addProperty("background_texture", this.getBackgroundTexture().toString());
        jsonObject.addProperty("icon_texture", this.getIconTexture().toString());
        if (this.connectedTreeId != null) {
            jsonObject.addProperty("connected_tree", this.getConnectedTreeId().toString());
        }
        if (this.isStartingPoint()) {
            jsonObject.addProperty("starting_point", Boolean.valueOf(true));
        }
        if (!this.getAttributeModifiers().isEmpty()) {
            JsonArray modifiersJsonArray = new JsonArray();
            this.getAttributeModifiers().forEach(pair -> {
                Attribute attribute = (Attribute)pair.getLeft();
                AttributeModifier modifier = (AttributeModifier)pair.getRight();
                JsonObject modifierJsonObject = new JsonObject();
                String attributeId = ForgeRegistries.ATTRIBUTES.getKey((Object)attribute).toString();
                modifierJsonObject.addProperty("attribute", attributeId);
                modifierJsonObject.addProperty("amount", (Number)modifier.m_22218_());
                modifierJsonObject.addProperty("operation", modifier.m_22217_().name().toLowerCase());
                modifiersJsonArray.add((JsonElement)modifierJsonObject);
            });
            jsonObject.add("attribute_modifiers", (JsonElement)modifiersJsonArray);
        }
        JsonObject positionJsonObject = new JsonObject();
        positionJsonObject.addProperty("x", (Number)this.positionX);
        positionJsonObject.addProperty("y", (Number)this.positionY);
        jsonObject.add("position", (JsonElement)positionJsonObject);
        if (!this.getConnectedSkills().isEmpty()) {
            JsonArray connectionsJsonArray = new JsonArray();
            this.getConnectedSkills().forEach(skillId -> connectionsJsonArray.add(skillId.toString()));
            jsonObject.add("connections", (JsonElement)connectionsJsonArray);
        }
        return jsonObject;
    }

    public static PassiveSkill loadFromJson(ResourceLocation id, JsonObject jsonObject) {
        int buttonSize = jsonObject.get("button_size").getAsInt();
        ResourceLocation treeId = new ResourceLocation(jsonObject.get("tree").getAsString());
        ResourceLocation backgroundTexture = new ResourceLocation(jsonObject.get("background_texture").getAsString());
        ResourceLocation iconTexture = new ResourceLocation(jsonObject.get("icon_texture").getAsString());
        ResourceLocation connectedTreeId = jsonObject.has("connected_tree") ? new ResourceLocation(jsonObject.get("connected_tree").getAsString()) : null;
        boolean isStartingPoint = jsonObject.has("starting_point");
        PassiveSkill passiveSkill = new PassiveSkill(id, treeId, buttonSize, backgroundTexture, iconTexture, isStartingPoint);
        passiveSkill.connectedTreeId = connectedTreeId;
        if (jsonObject.has("attribute_modifiers")) {
            JsonArray modifiersJsonArray = jsonObject.get("attribute_modifiers").getAsJsonArray();
            modifiersJsonArray.forEach(modifierJsonElement -> {
                JsonObject modifierJsonObject = (JsonObject)modifierJsonElement;
                ResourceLocation attributeId = new ResourceLocation(modifierJsonObject.get("attribute").getAsString());
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeId);
                if (attribute == null) {
                    LOGGER.error("Attribute {} does not exist", (Object)attributeId);
                }
                double amount = modifierJsonObject.get("amount").getAsDouble();
                AttributeModifier.Operation operation = AttributeModifier.Operation.valueOf((String)modifierJsonObject.get("operation").getAsString().toUpperCase());
                UUID uniqueId = UUID.randomUUID();
                AttributeModifier modifier = new AttributeModifier(uniqueId, "Passive Skill Bonus", amount, operation);
                passiveSkill.addAttributeBonus(attribute, modifier);
            });
        }
        JsonObject positionJsonObject = jsonObject.get("position").getAsJsonObject();
        int positionX = positionJsonObject.get("x").getAsInt();
        int positionY = positionJsonObject.get("y").getAsInt();
        passiveSkill.setPosition(positionX, positionY);
        if (jsonObject.has("connections")) {
            JsonArray connectionsJsonArray = jsonObject.get("connections").getAsJsonArray();
            connectionsJsonArray.forEach(connectionJsonElement -> {
                ResourceLocation connectedSkillId = new ResourceLocation(connectionJsonElement.getAsString());
                passiveSkill.connectedSkills.add(connectedSkillId);
            });
        }
        return passiveSkill;
    }

    public void writeToByteBuf(FriendlyByteBuf buf) {
        buf.m_130070_(this.getId().toString());
        buf.m_130070_(this.getTreeId().toString());
        buf.writeInt(this.getButtonSize());
        buf.m_130070_(this.getBackgroundTexture().toString());
        buf.m_130070_(this.getIconTexture().toString());
        buf.writeBoolean(this.isStartingPoint());
        buf.writeInt(this.getPositionX());
        buf.writeInt(this.getPositionY());
        buf.writeInt(this.getConnectedSkills().size());
        this.getConnectedSkills().forEach(skillId -> buf.m_130070_(skillId.toString()));
        buf.writeBoolean(this.getConnectedTreeId() != null);
        if (this.connectedTreeId != null) {
            buf.m_130070_(this.getConnectedTreeId().toString());
        }
        buf.writeInt(this.getAttributeModifiers().size());
        this.getAttributeModifiers().forEach(pair -> {
            Attribute attribute = (Attribute)pair.getLeft();
            String attributeId = ForgeRegistries.ATTRIBUTES.getKey((Object)attribute).toString();
            buf.m_130070_(attributeId);
            AttributeModifier modifier = (AttributeModifier)pair.getRight();
            double amount = modifier.m_22218_();
            AttributeModifier.Operation operation = modifier.m_22217_();
            buf.writeDouble(amount);
            buf.writeInt(operation.ordinal());
        });
    }

    public static PassiveSkill loadFromByteBuf(FriendlyByteBuf buf) {
        ResourceLocation skillId = new ResourceLocation(buf.m_130277_());
        ResourceLocation treeId = new ResourceLocation(buf.m_130277_());
        int buttonSize = buf.readInt();
        ResourceLocation backgroundTexture = new ResourceLocation(buf.m_130277_());
        ResourceLocation iconTexture = new ResourceLocation(buf.m_130277_());
        boolean isStartingPoint = buf.readBoolean();
        int positionX = buf.readInt();
        int positionY = buf.readInt();
        PassiveSkill passiveSkill = new PassiveSkill(skillId, treeId, buttonSize, backgroundTexture, iconTexture, isStartingPoint);
        passiveSkill.setPosition(positionX, positionY);
        int connectionsCount = buf.readInt();
        for (int i = 0; i < connectionsCount; ++i) {
            ResourceLocation connectedSkillId = new ResourceLocation(buf.m_130277_());
            passiveSkill.connectedSkills.add(connectedSkillId);
        }
        boolean hasConnectedTreeId = buf.readBoolean();
        if (hasConnectedTreeId) {
            ResourceLocation connectedTreeId;
            passiveSkill.connectedTreeId = connectedTreeId = new ResourceLocation(buf.m_130277_());
        }
        int attributeModifiersCount = buf.readInt();
        for (int i = 0; i < attributeModifiersCount; ++i) {
            String attributeId = buf.m_130277_();
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attributeId));
            double amount = buf.readDouble();
            AttributeModifier.Operation operation = AttributeModifier.Operation.values()[buf.readInt()];
            passiveSkill.addAttributeBonus(attribute, new AttributeModifier(UUID.randomUUID(), "Passive Skill Bonus", amount, operation));
        }
        return passiveSkill;
    }
}

