/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.util;

import daripher.skilltree.init.SkillTreeAttributes;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class FoodHelper {
    private static final String RESTORATION_BONUS_TAG = "RestorationBonus";
    private static final String LIFE_REGENERATION_BONUS_TAG = "LifeRegenBonus";
    private static final String DAMAGE_BONUS_TAG = "DamageBonus";
    private static final String CRIT_DAMAGE_BONUS_TAG = "CritDamageBonus";
    private static final String HEALING_BONUS_TAG = "HealingBonus";

    public static void setCraftedFoodBonuses(@NotNull ItemStack craftedItem, Player player) {
        double healingPerRestorationBonus;
        double critDamagePerRestorationBonus;
        double damagePerRestorationBonus;
        double lifeRegenerationBonus;
        double restorationBonus = player.m_21133_((Attribute)SkillTreeAttributes.COOKED_FOOD_SATURATION.get()) - 1.0;
        if (restorationBonus > 0.0) {
            FoodHelper.setRestorationBonus(craftedItem, (float)restorationBonus);
        }
        if ((lifeRegenerationBonus = player.m_21133_((Attribute)SkillTreeAttributes.COOKED_FOOD_LIFE_REGENERATION.get())) > 0.0) {
            FoodHelper.setLifeRegenerationBonus(craftedItem, (float)lifeRegenerationBonus);
        }
        if ((damagePerRestorationBonus = player.m_21133_((Attribute)SkillTreeAttributes.COOKED_FOOD_DAMAGE_PER_SATURATION.get()) - 1.0) > 0.0) {
            FoodHelper.setDamageBonus(craftedItem, (float)damagePerRestorationBonus);
        }
        if ((critDamagePerRestorationBonus = player.m_21133_((Attribute)SkillTreeAttributes.COOKED_FOOD_CRITICAL_DAMAGE_PER_SATURATION.get()) - 1.0) > 0.0) {
            FoodHelper.setCritDamageBonus(craftedItem, (float)critDamagePerRestorationBonus);
        }
        if ((healingPerRestorationBonus = player.m_21133_((Attribute)SkillTreeAttributes.COOKED_FOOD_HEALING_PER_SATURATION.get())) > 0.0) {
            FoodHelper.setHealingBonus(craftedItem, (float)healingPerRestorationBonus);
        }
    }

    public static void setRestorationBonus(ItemStack itemStack, float bonus) {
        itemStack.m_41784_().m_128350_(RESTORATION_BONUS_TAG, bonus);
    }

    public static boolean hasRestorationBonus(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128441_(RESTORATION_BONUS_TAG);
    }

    public static float getRestorationBonus(ItemStack itemStack) {
        return itemStack.m_41783_().m_128457_(RESTORATION_BONUS_TAG);
    }

    public static void setLifeRegenerationBonus(ItemStack itemStack, float bonus) {
        itemStack.m_41784_().m_128350_(LIFE_REGENERATION_BONUS_TAG, bonus);
    }

    public static boolean hasLifeRegenerationBonus(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128441_(LIFE_REGENERATION_BONUS_TAG);
    }

    public static float getLifeRegenerationBonus(ItemStack itemStack) {
        return itemStack.m_41783_().m_128457_(LIFE_REGENERATION_BONUS_TAG);
    }

    public static void setDamageBonus(ItemStack itemStack, float bonus) {
        itemStack.m_41784_().m_128350_(DAMAGE_BONUS_TAG, bonus);
    }

    public static boolean hasDamageBonus(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128441_(DAMAGE_BONUS_TAG);
    }

    public static float getDamageBonus(ItemStack itemStack) {
        return itemStack.m_41783_().m_128457_(DAMAGE_BONUS_TAG);
    }

    public static void setCritDamageBonus(ItemStack itemStack, float bonus) {
        itemStack.m_41784_().m_128350_(CRIT_DAMAGE_BONUS_TAG, bonus);
    }

    public static boolean hasCritDamageBonus(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128441_(CRIT_DAMAGE_BONUS_TAG);
    }

    public static float getCritDamageBonus(ItemStack itemStack) {
        return itemStack.m_41783_().m_128457_(CRIT_DAMAGE_BONUS_TAG);
    }

    public static void setHealingBonus(ItemStack itemStack, float bonus) {
        itemStack.m_41784_().m_128350_(HEALING_BONUS_TAG, bonus);
    }

    public static boolean hasHealingBonus(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128441_(HEALING_BONUS_TAG);
    }

    public static float getHealingBonus(ItemStack itemStack) {
        return itemStack.m_41783_().m_128457_(HEALING_BONUS_TAG);
    }
}

