/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.util;

import daripher.skilltree.gem.GemHelper;
import daripher.skilltree.init.SkillTreeAttributes;
import daripher.skilltree.init.SkillTreeItems;
import daripher.skilltree.item.ItemHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class PlayerHelper {
    public static float getDamageMultiplier(Player player, LivingEntity target, boolean melee) {
        float multiplier = 1.0f;
        if (target.m_21023_(MobEffects.f_19614_)) {
            multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_AGAINST_POISONED.get()) - 1.0f;
        }
        if (ItemHelper.isShield(player.m_21206_())) {
            multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_WITH_SHIELD.get()) - 1.0f;
            multiplier = melee ? (multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.MELEE_DAMAGE_WITH_SHIELD.get()) - 1.0f) : (multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.PROJECTILE_DAMAGE_WITH_SHIELD.get()) - 1.0f);
        }
        if (ItemHelper.isWeapon(player.m_21205_()) && player.m_21205_().m_41793_()) {
            multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_WITH_ENCHANTED_WEAPON.get()) - 1.0f;
        }
        if (ItemHelper.isBow(player.m_21205_())) {
            multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.BOW_DAMAGE.get()) - 1.0f;
            if (player.m_21205_().m_41793_()) {
                multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.ENCHANTED_BOW_DAMAGE.get()) - 1.0f;
            }
        }
        if (ItemHelper.isCrossbow(player.m_21205_())) {
            multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.CROSSBOW_DAMAGE.get()) - 1.0f;
            if (player.m_21205_().m_41793_()) {
                multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.ENCHANTED_CROSSBOW_DAMAGE.get()) - 1.0f;
            }
        }
        if (ItemHelper.isAxe(player.m_21205_())) {
            multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.AXE_DAMAGE.get()) - 1.0f;
            if (player.m_21205_().m_41793_()) {
                multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.ENCHANTED_AXE_DAMAGE.get()) - 1.0f;
            }
        }
        if (ItemHelper.isSword(player.m_21205_())) {
            multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.SWORD_DAMAGE.get()) - 1.0f;
            if (player.m_21205_().m_41793_()) {
                multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.ENCHANTED_SWORD_DAMAGE.get()) - 1.0f;
            }
        }
        if (ItemHelper.isTrident(player.m_21205_()) && melee) {
            multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.TRIDENT_DAMAGE.get()) - 1.0f;
            if (player.m_21205_().m_41793_()) {
                multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.ENCHANTED_TRIDENT_DAMAGE.get()) - 1.0f;
            }
        }
        if (ItemHelper.hasPoisons(player.m_21205_())) {
            multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_WITH_POISONED_WEAPON.get()) - 1.0f;
        }
        if (GemHelper.hasGem(player.m_21205_(), 0)) {
            int gems = GemHelper.getGemsCount(player.m_21205_());
            double damagePerGem = player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_PER_GEM_IN_WEAPON.get()) - 1.0;
            multiplier = (float)((double)multiplier + damagePerGem * (double)gems);
            multiplier = (float)((double)multiplier + (player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_WITH_GEM_IN_WEAPON.get()) - 1.0));
            int adamites = GemHelper.getGemsCount(player.m_21205_(), (Item)SkillTreeItems.ADAMITE.get());
            double damagePerAdamite = player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_PER_ADAMITE_IN_WEAPON.get()) - 1.0;
            multiplier = (float)((double)multiplier + damagePerAdamite * (double)adamites);
            int iriscites = GemHelper.getGemsCount(player.m_21205_(), (Item)SkillTreeItems.IRISCITE.get());
            double damagePerIriscite = player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_PER_IRISCITE_IN_WEAPON.get()) - 1.0;
            multiplier = (float)((double)multiplier + damagePerIriscite * (double)iriscites);
            if (GemHelper.hasOnlyDifferentGems(player.m_21205_())) {
                multiplier = (float)((double)multiplier + (player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_WITH_DIFFERENT_WEAPON_GEMS.get()) - 1.0));
            }
            if (GemHelper.hasOnlySameGems(player.m_21205_())) {
                multiplier = (float)((double)multiplier + (player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_WITH_SAME_WEAPON_GEMS.get()) - 1.0));
            }
            if (melee) {
                double meleeDamagePerGem = player.m_21133_((Attribute)SkillTreeAttributes.MELEE_DAMAGE_PER_GEM_IN_WEAPON.get()) - 1.0;
                multiplier = (float)((double)multiplier + meleeDamagePerGem * (double)gems);
            } else {
                double projectileDamagePerGem = player.m_21133_((Attribute)SkillTreeAttributes.PROJECTILE_DAMAGE_PER_GEM_IN_WEAPON.get()) - 1.0;
                multiplier = (float)((double)multiplier + projectileDamagePerGem * (double)gems);
            }
        }
        if (player.m_36324_().m_38702_() >= 10) {
            multiplier = (float)((double)multiplier + (player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_IF_NOT_HUNGRY.get()) - 1.0));
            multiplier = melee ? (float)((double)multiplier + (player.m_21133_((Attribute)SkillTreeAttributes.MELEE_DAMAGE_IF_NOT_HUNGRY.get()) - 1.0)) : (float)((double)multiplier + (player.m_21133_((Attribute)SkillTreeAttributes.PROJECTILE_DAMAGE_IF_NOT_HUNGRY.get()) - 1.0));
        }
        if (!player.m_21220_().isEmpty()) {
            double damagePerEffect = player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_PER_POTION_EFFECT.get()) - 1.0;
            multiplier = (float)((double)multiplier + (double)player.m_21220_().size() * damagePerEffect);
            multiplier = (float)((double)multiplier + (player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_UNDER_POTION_EFFECT.get()) - 1.0));
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemInSlot = player.m_6844_(slot);
            if (!itemInSlot.m_41793_()) continue;
            float damagePerEnchantment = (float)player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_PER_ENCHANTMENT.get()) - 1.0f;
            int enchantments = itemInSlot.getAllEnchantments().size();
            multiplier += damagePerEnchantment * (float)enchantments;
        }
        for (Integer enchantmentLevel : player.m_21205_().getAllEnchantments().values()) {
            float damagePerEnchantmentLevel = (float)player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_PER_WEAPON_ENCHANTMENT_LEVEL.get()) - 1.0f;
            multiplier += damagePerEnchantmentLevel * (float)enchantmentLevel.intValue();
        }
        int foodLevel = player.m_36324_().m_38702_();
        if (foodLevel > 0) {
            double damagePerSatisfiedHunger = player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_PER_SATISFIED_HUNGER.get()) - 1.0;
            multiplier = (float)((double)multiplier + (double)foodLevel * damagePerSatisfiedHunger);
        }
        double damagePerArrowInEnemy = player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_PER_ARROW_IN_ENEMY.get()) - 1.0;
        multiplier = (float)((double)multiplier + damagePerArrowInEnemy * (double)target.m_21234_());
        double damageBonusPerDistance = player.m_21133_((Attribute)SkillTreeAttributes.DAMAGE_PER_DISTANCE.get()) - 1.0;
        multiplier = (float)((double)multiplier + damageBonusPerDistance * (double)player.m_20270_((Entity)target));
        return multiplier;
    }

    public static float getProjectileDamageMultiplier(Player player, LivingEntity target, Projectile projectile) {
        boolean criticalHit;
        float critChance = (float)(player.m_21133_((Attribute)SkillTreeAttributes.PROJECTILE_CRIT_CHANCE.get()) - 1.0);
        critChance += PlayerHelper.getCritChance(player, target);
        float multiplier = (float)player.m_21133_((Attribute)SkillTreeAttributes.PROJECTILE_DAMAGE.get());
        if (target.m_21023_(MobEffects.f_19614_)) {
            multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.PROJECTILE_DAMAGE_AGAINST_POISONED.get()) - 1.0f;
        }
        if (projectile instanceof ThrownPotion) {
            multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.SPLASH_POTION_DAMAGE.get()) - 1.0f;
        }
        if (projectile instanceof ThrownTrident) {
            multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.TRIDENT_DAMAGE.get()) - 1.0f;
        }
        if (PlayerHelper.isArrow(projectile)) {
            multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.ARROW_DAMAGE.get()) - 1.0f;
        }
        if (PlayerHelper.isTippedArrow(projectile)) {
            multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.TIPPED_ARROW_DAMAGE.get()) - 1.0f;
        }
        boolean bl = criticalHit = player.m_217043_().m_188501_() < critChance;
        if (criticalHit) {
            multiplier += PlayerHelper.getCritDamageMultiplier(player, target);
            multiplier = (float)((double)multiplier + (player.m_21133_((Attribute)SkillTreeAttributes.PROJECTILE_CRIT_DAMAGE.get()) - 1.0));
        }
        return multiplier += PlayerHelper.getDamageMultiplier(player, target, false) - 1.0f;
    }

    private static boolean isTippedArrow(Projectile projectile) {
        if (!(projectile instanceof Arrow)) {
            return false;
        }
        ItemStack arrowStack = ItemStack.f_41583_;
        try {
            Method getPickupItemMethod = ObfuscationReflectionHelper.findMethod(AbstractArrow.class, (String)"m_7941_", (Class[])new Class[0]);
            arrowStack = (ItemStack)getPickupItemMethod.invoke((Object)projectile, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return arrowStack.m_41720_() == Items.f_42738_;
    }

    protected static boolean isArrow(Projectile projectile) {
        if (!(projectile instanceof Arrow)) {
            return false;
        }
        ItemStack arrowStack = ItemStack.f_41583_;
        try {
            Method getPickupItemMethod = ObfuscationReflectionHelper.findMethod(AbstractArrow.class, (String)"m_7941_", (Class[])new Class[0]);
            arrowStack = (ItemStack)getPickupItemMethod.invoke((Object)projectile, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return arrowStack.m_41720_() instanceof ArrowItem;
    }

    public static float getCritChance(Player player, LivingEntity target) {
        float chance = (float)(player.m_21133_((Attribute)SkillTreeAttributes.CRIT_CHANCE.get()) - 1.0);
        if (target.m_21023_(MobEffects.f_19614_)) {
            chance += (float)player.m_21133_((Attribute)SkillTreeAttributes.CRIT_CHANCE_AGAINST_POISONED.get()) - 1.0f;
        }
        if (ItemHelper.isShield(player.m_21206_())) {
            chance += (float)player.m_21133_((Attribute)SkillTreeAttributes.CRIT_CHANCE_WITH_SHIELD.get()) - 1.0f;
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemInSlot = player.m_6844_(slot);
            if (!itemInSlot.m_41793_()) continue;
            float critChancePerEnchantment = (float)player.m_21133_((Attribute)SkillTreeAttributes.CRIT_CHANCE_PER_ENCHANTMENT.get()) - 1.0f;
            int enchantmentCount = itemInSlot.getAllEnchantments().size();
            chance += critChancePerEnchantment * (float)enchantmentCount;
        }
        return chance;
    }

    public static float getCritDamageMultiplier(Player player, LivingEntity target) {
        int foodLevel;
        float multiplier = 1.5f;
        multiplier = (float)((double)multiplier + (player.m_21133_((Attribute)SkillTreeAttributes.CRIT_DAMAGE.get()) - 1.0));
        ItemStack mainhandItem = player.m_21205_();
        if (ItemHelper.isWeapon(mainhandItem)) {
            float critDamagePerWeaponEnchantment = (float)player.m_21133_((Attribute)SkillTreeAttributes.CRIT_DAMAGE_PER_WEAPON_ENCHANTMENT.get()) - 1.0f;
            int enchantments = mainhandItem.getAllEnchantments().size();
            multiplier += critDamagePerWeaponEnchantment * (float)enchantments;
        }
        if (ItemHelper.isShield(player.m_21206_())) {
            multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.CRIT_DAMAGE_WITH_SHIELD.get()) - 1.0f;
        }
        if ((foodLevel = player.m_36324_().m_38702_()) > 0) {
            double critDamagePerSatisfiedHunger = player.m_21133_((Attribute)SkillTreeAttributes.CRIT_DAMAGE_PER_SATISFIED_HUNGER.get()) - 1.0;
            multiplier = (float)((double)multiplier + (double)foodLevel * critDamagePerSatisfiedHunger);
        }
        if (target.m_21023_(MobEffects.f_19614_)) {
            multiplier += (float)player.m_21133_((Attribute)SkillTreeAttributes.CRIT_DAMAGE_AGAINST_POISONED.get()) - 1.0f;
        }
        return multiplier;
    }

    public static boolean canEvadeDamage(DamageSource source) {
        EntityDamageSource damageSource;
        return source instanceof EntityDamageSource && (damageSource = (EntityDamageSource)source).m_7640_() instanceof LivingEntity;
    }

    public static float getGemPower(Player player, ItemStack itemStack) {
        double gemPower = player.m_21133_((Attribute)SkillTreeAttributes.GEM_POWER.get());
        boolean craftingArmor = ItemHelper.isArmor(itemStack) || ItemHelper.isShield(itemStack);
        boolean craftingWeapon = ItemHelper.isWeapon(itemStack);
        if (craftingArmor) {
            double gemPowerInArmor = player.m_21133_((Attribute)SkillTreeAttributes.GEM_POWER_IN_ARMOR.get()) - 1.0;
            gemPower += gemPowerInArmor;
        } else if (craftingWeapon) {
            double gemPowerInWeapon = player.m_21133_((Attribute)SkillTreeAttributes.GEM_POWER_IN_WEAPON.get()) - 1.0;
            gemPower += gemPowerInWeapon;
        }
        return (float)gemPower;
    }

    public static void hurtShield(Player player, ItemStack shield, float amount) {
        if (shield.canPerformAction(ToolActions.SHIELD_BLOCK)) {
            if (!player.f_19853_.f_46443_) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)shield.m_41720_()));
            }
            if (amount >= 3.0f) {
                int i = 1 + Mth.m_14143_((float)amount);
                shield.m_41622_(i, (LivingEntity)player, player_ -> {
                    player_.m_21190_(InteractionHand.OFF_HAND);
                    ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)shield, (InteractionHand)InteractionHand.OFF_HAND);
                });
                if (shield.m_41619_()) {
                    player.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                    player.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + player.f_19853_.f_46441_.m_188501_() * 0.4f);
                }
            }
        }
    }
}

