/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionHelper {
    private static final String CUSTOM_POTION_COLOR_TAG = "CustomPotionColor";
    private static final String ACTUAL_POTION_TAG = "ActualPotion";
    private static final String MIXED_POTION_TAG = "MixedPotion";

    public static boolean isHarmfulPotion(ItemStack itemStack) {
        List effects = PotionUtils.m_43547_((ItemStack)itemStack);
        for (MobEffectInstance effect : effects) {
            if (effect.m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue;
            return true;
        }
        return false;
    }

    public static boolean isBeneficialPotion(ItemStack itemStack) {
        List effects = PotionUtils.m_43547_((ItemStack)itemStack);
        for (MobEffectInstance effect : effects) {
            if (effect.m_19544_().m_19483_() != MobEffectCategory.BENEFICIAL) continue;
            return true;
        }
        return false;
    }

    public static void setPotionColor(ItemStack itemStack, int color) {
        CompoundTag itemTag = itemStack.m_41783_();
        if (itemTag != null) {
            itemTag.m_128405_(CUSTOM_POTION_COLOR_TAG, color);
        }
    }

    public static void setActualPotion(ItemStack itemStack, Potion potion) {
        ResourceLocation potionId = ForgeRegistries.POTIONS.getKey((Object)potion);
        if (potion == Potions.f_43598_) {
            itemStack.m_41749_(ACTUAL_POTION_TAG);
        } else {
            itemStack.m_41784_().m_128359_(ACTUAL_POTION_TAG, potionId.toString());
        }
    }

    public static ItemStack getActualPotionStack(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return ItemStack.f_41583_;
        }
        if (!itemStack.m_41783_().m_128441_(ACTUAL_POTION_TAG)) {
            return itemStack;
        }
        Potion actualPotion = PotionHelper.getActualPotion(itemStack);
        ItemStack actualPotionStack = new ItemStack((ItemLike)itemStack.m_41720_());
        PotionUtils.m_43549_((ItemStack)actualPotionStack, (Potion)actualPotion);
        return actualPotionStack;
    }

    public static Potion getActualPotion(ItemStack potionStack) {
        if (!potionStack.m_41782_()) {
            return Potions.f_43598_;
        }
        if (!potionStack.m_41783_().m_128441_(ACTUAL_POTION_TAG)) {
            return PotionUtils.m_43579_((ItemStack)potionStack);
        }
        String actualPotionId = potionStack.m_41783_().m_128461_(ACTUAL_POTION_TAG);
        Potion actualPotion = Potion.m_43489_((String)actualPotionId);
        return actualPotion;
    }

    public static boolean isSuperiorPotion(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128441_(ACTUAL_POTION_TAG);
    }

    public static boolean isMixture(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128441_(MIXED_POTION_TAG);
    }

    public static boolean isPotion(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof PotionItem;
    }

    public static void enhancePotion(ItemStack itemStack, float amplificationChance, float durationBonus) {
        Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
        List effects = potion.m_43488_();
        if (effects.isEmpty()) {
            return;
        }
        List<MobEffectInstance> enhancedEffects = PotionHelper.enhanceEffects(effects, amplificationChance, durationBonus);
        PotionUtils.m_43549_((ItemStack)itemStack, (Potion)Potions.f_43598_);
        PotionUtils.m_43552_((ItemStack)itemStack, enhancedEffects);
        PotionHelper.setActualPotion(itemStack, potion);
        PotionHelper.setPotionColor(itemStack, PotionUtils.m_43559_((Potion)potion));
    }

    private static List<MobEffectInstance> enhanceEffects(List<MobEffectInstance> effects, float amplificationChance, float durationBonus) {
        Random random = new Random();
        ArrayList<MobEffectInstance> enhancedEffects = new ArrayList<MobEffectInstance>();
        effects.forEach(effect -> {
            int duration = (int)((float)effect.m_19557_() * (1.0f + durationBonus));
            int amplifier = effect.m_19564_();
            float chance = amplificationChance;
            while (chance > 1.0f) {
                chance -= 1.0f;
                ++amplifier;
            }
            if (random.nextFloat() < chance) {
                ++amplifier;
            }
            enhancedEffects.add(new MobEffectInstance(effect.m_19544_(), duration, amplifier));
        });
        return enhancedEffects;
    }

    public static ItemStack mixPotions(ItemStack potionStack1, ItemStack potionStack2) {
        List<Object> potions = Arrays.asList(potionStack1, potionStack2);
        potions = potions.stream().sorted(PotionHelper::comparePotions).toList();
        ItemStack result = new ItemStack((ItemLike)potionStack1.m_41720_(), 2);
        ArrayList effects = new ArrayList();
        potions.stream().map(PotionUtils::m_43547_).forEach(effects::addAll);
        PotionUtils.m_43552_((ItemStack)result, effects);
        PotionHelper.setPotionColor(result, PotionUtils.m_43575_((ItemStack)((ItemStack)potions.get(0))));
        result.m_41784_().m_128379_(MIXED_POTION_TAG, true);
        return result;
    }

    private static int comparePotions(ItemStack potionStack1, ItemStack potionStack2) {
        return potionStack1.m_41778_().compareTo(potionStack2.m_41778_());
    }
}

