/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.client.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.caitie.roamers.client.layers.TextureLayer;
import net.caitie.roamers.entity.AbstractCharacter;
import net.caitie.roamers.entity.PlayerDescendant;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HeadWearLayer<T extends PlayerLikeCharacter, M extends PlayerModel<T>>
extends TextureLayer<T, M> {
    private static final String path = "textures/layers/accessories/";
    protected static final ResourceLocation SAVANNA_MALE = new ResourceLocation("roamers", "textures/layers/accessories/savanna_headwear_male.png");
    protected static final ResourceLocation SAVANNA_FEMALE = new ResourceLocation("roamers", "textures/layers/accessories/savanna_headwear_female.png");
    protected static final ResourceLocation DESERT_MALE = new ResourceLocation("roamers", "textures/layers/accessories/desert_headwear_male.png");
    protected static final ResourceLocation BADLANDS_MALE = new ResourceLocation("roamers", "textures/layers/accessories/badlands_headwear_male.png");
    protected static final ResourceLocation BADLANDS_FEMALE = new ResourceLocation("roamers", "textures/layers/accessories/badlands_headwear_female.png");

    public HeadWearLayer(RenderLayerParent<T, M> parent, boolean render) {
        super(parent, render);
    }

    @Override
    public void renderTexture(PoseStack stack, MultiBufferSource source, int i, T entity, float v, float v1, float v2, float v3, float v4, float v5) {
        if (!(entity.m_20145_() || entity.m_6162_() || entity instanceof PlayerDescendant)) {
            VertexConsumer vertexConsumer = source.m_6299_(RenderType.m_110458_((ResourceLocation)this.createHeadWear(entity)));
            ((PlayerModel)this.m_117386_()).m_7695_(stack, vertexConsumer, i, LivingEntityRenderer.m_115338_(entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    protected ResourceLocation createHeadWear(T entity) {
        return this.getLocation(((AbstractCharacter)((Object)entity)).getRace(), ((AbstractCharacter)((Object)entity)).isMale());
    }

    protected ResourceLocation getLocation(AbstractCharacter.Race race, boolean male) {
        if (race == AbstractCharacter.Race.SAVANNA) {
            return male ? SAVANNA_MALE : SAVANNA_FEMALE;
        }
        if (race == AbstractCharacter.Race.DESERT) {
            return male ? DESERT_MALE : BLANK;
        }
        if (race == AbstractCharacter.Race.BADLANDS) {
            return male ? BADLANDS_MALE : BADLANDS_FEMALE;
        }
        return BLANK;
    }
}

