/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity;

import com.google.common.base.Predicate;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.caitie.roamers.NameGenerator;
import net.caitie.roamers.RoamersMod;
import net.caitie.roamers.entity.AbstractCharacter;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.caitie.roamers.entity.ai.PlayerLikeAI;
import net.caitie.roamers.entity.ai.goals.CookFoodGoal;
import net.caitie.roamers.entity.ai.goals.DefendFriendsGoal;
import net.caitie.roamers.entity.ai.goals.FollowPlayerGoal;
import net.caitie.roamers.entity.ai.goals.HuntingGoal;
import net.caitie.roamers.entity.ai.goals.PickUpItemGoal;
import net.caitie.roamers.entity.ai.goals.PlaceTorchGoal;
import net.caitie.roamers.entity.ai.goals.PlayerLikeMeleeGoal;
import net.caitie.roamers.entity.ai.goals.SleepGoal;
import net.caitie.roamers.entity.ai.tasks.BabyPlayTask;
import net.caitie.roamers.entity.ai.tasks.BuildTask;
import net.caitie.roamers.entity.ai.tasks.CraftingTask;
import net.caitie.roamers.entity.ai.tasks.FarmTask;
import net.caitie.roamers.entity.ai.tasks.FishTask;
import net.caitie.roamers.entity.ai.tasks.MineTask;
import net.caitie.roamers.entity.inventory.CharacterInventory;
import net.caitie.roamers.gui.CharacterInventoryMenu;
import net.caitie.roamers.init.RoamersModEntities;
import net.caitie.roamers.init.RoamersModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.Nullable;

public class PlayerDescendant
extends PlayerLikeCharacter
implements OwnableEntity {
    private final Predicate<LivingEntity> BABY_HURT_BY = entity -> this.m_21188_() == entity;
    protected CharacterInventory characterInventory = new CharacterInventory(this);
    public AssignedChore currentChore = AssignedChore.NONE;
    private final PlayerLikeAI AI;
    public static List<TagKey<Item>> MINEABLE_ITEMS = List.of(Tags.Items.RAW_MATERIALS, Tags.Items.GEMS);
    protected static final EntityDataAccessor<Optional<UUID>> PARENT_PLAYER = SynchedEntityData.m_135353_(PlayerDescendant.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> CLOTHES_COLOR = SynchedEntityData.m_135353_(PlayerDescendant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public HurtByTargetGoal descHurtByTargetGoal;
    public AvoidEntityGoal<LivingEntity> descAvoidEntityGoal;

    public PlayerDescendant(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<PlayerDescendant>)((EntityType)RoamersModEntities.PLAYER_DESCENDANT.get()), world);
    }

    public PlayerDescendant(EntityType<PlayerDescendant> type, Level world) {
        super((EntityType<? extends PlayerLikeCharacter>)type, world);
        this.f_21342_ = new PlayerDescendantMoveControl(this);
        this.AI = new PlayerLikeAI(this){
            final PlayerDescendant desc;
            FollowPlayerGoal followGoal;
            {
                this.desc = PlayerDescendant.this;
            }

            @Override
            public void initGoals() {
                this.craftTask = new CraftingTask(this.desc);
                this.mineTask = new MineTask((PlayerLikeCharacter)this.desc, Blocks.f_49999_.m_5456_(), true);
                this.buildTask = new BuildTask(this.desc);
                this.farmTask = new FarmTask(this.desc, (TagKey<Item>)AbstractCharacter.PLANTABLES, RoamersMod.CONFIG.descendantFarmingRange);
                this.fishTask = new FishTask(this.desc, true);
                this.huntingGoal = new HuntingGoal((AbstractCharacter)this.desc, AbstractCharacter.HUNTABLES, false);
                if (!this.desc.isCreative()) {
                    this.doorGoal = new OpenDoorGoal((Mob)this.desc, true){

                        public boolean m_8036_() {
                            return !this.f_25189_.f_20911_ && super.m_8036_();
                        }

                        protected void m_25195_(boolean open) {
                            BlockState blockstate;
                            if (this.f_25191_ && !this.f_25189_.f_20911_ && (blockstate = this.f_25189_.f_19853_.m_8055_(this.f_25190_)).m_60734_() instanceof DoorBlock) {
                                ((DoorBlock)blockstate.m_60734_()).m_153165_((Entity)this.f_25189_, this.f_25189_.f_19853_, blockstate, this.f_25190_, open);
                                this.f_25189_.m_6674_(InteractionHand.MAIN_HAND);
                            }
                        }
                    };
                }
                this.lookAtPlayerGoal = new LookAtPlayerGoal((Mob)this.desc, Player.class, 8.0f);
                this.lookAtEntityGoal = new LookAtPlayerGoal((Mob)this.desc, PathfinderMob.class, 6.0f);
                this.lookAroundGoal = new RandomLookAroundGoal((Mob)this.desc);
                this.randomStrollGoal = this.desc.isCreative() ? new WaterAvoidingRandomFlyingGoal((PathfinderMob)this.desc, 0.85) : new WaterAvoidingRandomStrollGoal((PathfinderMob)this.desc, 0.85);
                this.playGoal = new BabyPlayTask(this.desc);
                this.desc.descHurtByTargetGoal = new HurtByTargetGoal((PathfinderMob)this.desc, new Class[0]){

                    public boolean m_8036_() {
                        return !PlayerDescendant.this.m_6162_() && super.m_8036_() && this.f_26137_ != PlayerDescendant.this.m_21826_();
                    }
                };
                this.desc.descAvoidEntityGoal = new AvoidEntityGoal<LivingEntity>((PathfinderMob)this.desc, LivingEntity.class, 8.0f, 0.9, 0.9){
                    private int cryTicks;
                    {
                        this.cryTicks = 0;
                    }

                    public boolean m_8036_() {
                        return super.m_8036_() && PlayerDescendant.this.m_6162_() && PlayerDescendant.this.BABY_HURT_BY.test((Object)this.f_25016_);
                    }

                    public void m_8056_() {
                        super.m_8056_();
                        PlayerDescendant.this.sprint(true);
                    }

                    public void m_8037_() {
                        super.m_8037_();
                        if (++this.cryTicks >= 5) {
                            PlayerDescendant.this.f_19853_.m_7605_((Entity)PlayerDescendant.this, (byte)42);
                            this.cryTicks = 0;
                        }
                    }

                    public void m_8041_() {
                        super.m_8041_();
                        this.cryTicks = 0;
                        PlayerDescendant.this.sprint(false);
                    }
                };
                this.coreGoals = new ObjectArrayList(List.of(new PickUpItemGoal(this.desc, 0.9), new FloatGoal((Mob)this.desc), new SleepGoal(this.desc)));
            }

            @Override
            public void postInit() {
                this.currentBrain = this.desc.m_6162_() ? this.BABY_BRAIN : this.BRAIN;
                this.coreGoals = new ObjectArrayList(List.of(new PickUpItemGoal(this.desc, 0.9), new PlayerLikeMeleeGoal(this.desc, 1.0, true), new SleepGoal(this.desc), new FloatGoal((Mob)this.desc), new CookFoodGoal(this.desc, 0.9, 10)));
                if (!this.desc.isCreative()) {
                    this.coreGoals.add((Object)this.doorGoal);
                }
                this.overrideBrainState(this.currentBrain, PlayerLikeAI.State.CORE, (List<Goal>)this.coreGoals);
                this.overrideBrainState(this.currentBrain, PlayerLikeAI.State.TARGETING, List.of(this.desc.descHurtByTargetGoal));
                this.overrideBrainState(this.currentBrain, PlayerLikeAI.State.ATTACKING, List.of(this.huntingGoal));
                this.addGoalToBrain(this.currentBrain, this.playGoal, PlayerLikeAI.State.IDLE);
                this.addGoalToBrain(this.currentBrain, (Goal)new DefendFriendsGoal(this.desc), PlayerLikeAI.State.TARGETING);
                if (RoamersMod.CONFIG.allowTorchPlacing) {
                    this.addGoalToBrain(this.currentBrain, new PlaceTorchGoal(this.desc), PlayerLikeAI.State.MINING);
                }
                super.postInit();
            }

            @Override
            public void checkTasks() {
                if (!this.desc.isDepressed() && !this.desc.hasFullInventory()) {
                    ItemStack assignedItem = this.desc.getAssignedItem();
                    switch (this.desc.currentChore) {
                        case MINE: {
                            if (!this.desc.canMine() || assignedItem.m_41619_()) break;
                            this.reassessMineTask(new MineTask((PlayerLikeCharacter)this.desc, assignedItem.m_41720_(), true));
                            this.switchCurrentState(PlayerLikeAI.State.MINING);
                            return;
                        }
                        case CHOP: {
                            if (!this.desc.canMine()) break;
                            if (!assignedItem.m_41619_()) {
                                this.reassessMineTask(new MineTask((PlayerLikeCharacter)this.desc, assignedItem.m_41720_(), true));
                            } else {
                                this.reassessMineTask(new MineTask((PlayerLikeCharacter)this.desc, (TagKey<Item>)ItemTags.f_13182_, true));
                            }
                            this.switchCurrentState(PlayerLikeAI.State.MINING);
                            return;
                        }
                        case FARM: {
                            if (!this.desc.canFarm()) break;
                            this.switchCurrentState(PlayerLikeAI.State.FARMING);
                            return;
                        }
                        case FISH: {
                            if (!this.desc.canFish()) break;
                            this.switchCurrentState(PlayerLikeAI.State.FISHING);
                            return;
                        }
                        case HUNT: {
                            this.stopGoal((Goal)this.huntingGoal);
                            if (!this.desc.shouldHunt()) break;
                            this.huntingGoal = !assignedItem.m_41619_() ? new HuntingGoal((AbstractCharacter)this.desc, false, assignedItem.m_41720_()) : new HuntingGoal((AbstractCharacter)this.desc, AbstractCharacter.HUNTABLES, false);
                            this.switchCurrentState(PlayerLikeAI.State.ATTACKING);
                            return;
                        }
                        case FOLLOW: {
                            this.stopGoal(this.followGoal);
                            if (!this.desc.shouldFollow()) break;
                            this.terminateTasks();
                            this.followGoal = new FollowPlayerGoal(this.desc, 10.0f, this.desc.m_6162_() ? 1.0f : 3.0f);
                            this.addGoalToSelector(this.followGoal, 1);
                            return;
                        }
                    }
                }
                this.defaultState();
            }
        };
        this.f_21364_ = 0;
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.bedPos = null;
    }

    public boolean m_142535_(float v, float v1, DamageSource source) {
        return !this.isCreative() && super.m_142535_(v, v1, source);
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.isCreative() && !damageSource.m_19378_()) {
            return false;
        }
        return super.m_6469_(damageSource, amount);
    }

    public boolean isPushedByFluid(FluidType type) {
        return !this.isCreative() && super.isPushedByFluid(type);
    }

    @Override
    protected void m_8024_() {
        this.assignChore();
        super.m_8024_();
    }

    @Override
    public void m_7023_(Vec3 vec3) {
        if (this.isCreative()) {
            if (this.m_6142_() || this.m_6109_()) {
                this.m_19920_(0.1f, vec3);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
                this.m_183634_();
            }
            this.m_21043_((LivingEntity)this, false);
        } else {
            super.m_7023_(vec3);
        }
    }

    public boolean m_6162_() {
        return RoamersMod.CONFIG.descendantForeverBaby || super.m_6162_();
    }

    @Override
    public boolean canBuild() {
        return false;
    }

    @Override
    public SimpleContainer m_35311_() {
        return this.characterInventory;
    }

    protected void m_8099_() {
        super.m_8099_();
    }

    public ItemStack getAssignedItem() {
        return this.characterInventory.m_8020_(5);
    }

    public DyeColor getClothingColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(CLOTHES_COLOR)));
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance instance, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        this.createPerson(this.m_20183_());
        if (type == MobSpawnType.SPAWN_EGG) {
            this.m_146762_(RoamersMod.CONFIG.babyAgeTicks < 0 ? RoamersMod.CONFIG.babyAgeTicks : -72000);
        }
        this.setClothingColor(Arrays.asList(DyeColor.values()).get(this.f_19796_.m_188503_(DyeColor.values().length)));
        if (this.getRace() == AbstractCharacter.Race.ARTIC) {
            this.m_35311_().m_6836_(0, ((Item)RoamersModItems.WOOL_HELMET.get()).m_7968_());
            this.m_35311_().m_6836_(1, ((Item)RoamersModItems.WOOL_CHESTPLATE.get()).m_7968_());
            this.m_35311_().m_6836_(2, ((Item)RoamersModItems.WOOL_LEGGINGS.get()).m_7968_());
            this.m_35311_().m_6836_(3, ((Item)RoamersModItems.WOOL_BOOTS.get()).m_7968_());
        }
        return super.m_6518_(accessor, instance, type, data, tag);
    }

    @Override
    public boolean canFishTreasures() {
        return true;
    }

    public boolean isWorking() {
        return this.currentChore != AssignedChore.FOLLOW && this.currentChore != AssignedChore.NONE;
    }

    @Override
    public boolean m_7243_(ItemStack itemStack) {
        return this.m_35311_().m_19183_(itemStack);
    }

    public void assignChore() {
        if (this.currentChore == AssignedChore.FOLLOW) {
            return;
        }
        if (!RoamersMod.CONFIG.allowDescendantChores) {
            return;
        }
        ItemStack stack = this.characterInventory.m_8020_(4);
        ItemStack item = this.characterInventory.m_8020_(5);
        if (stack.m_204117_(PICKAXES) && this.isValidItemForMining(item)) {
            this.currentChore = AssignedChore.MINE;
            return;
        }
        if (stack.m_204117_(AXES)) {
            this.currentChore = AssignedChore.CHOP;
            return;
        }
        if (stack.m_150930_(Items.f_42523_)) {
            this.currentChore = AssignedChore.FISH;
            return;
        }
        if (stack.m_204117_(HOES)) {
            this.currentChore = AssignedChore.FARM;
            return;
        }
        if (stack.m_204117_(SWORDS)) {
            this.currentChore = AssignedChore.HUNT;
            return;
        }
        if (stack.m_204117_(COOKABLES)) {
            this.currentChore = AssignedChore.COOK;
        }
    }

    @Override
    public boolean isMining() {
        return this.currentChore == AssignedChore.FOLLOW ? this.m_21120_(InteractionHand.MAIN_HAND).m_204117_(PICKAXES) : this.currentChore == AssignedChore.MINE;
    }

    protected boolean isValidItemForMining(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.m_150930_(Items.f_42413_)) {
            return true;
        }
        for (TagKey<Item> tagkeys : MINEABLE_ITEMS) {
            if (!stack.m_204117_(tagkeys)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PlayerLikeAI getAI() {
        return this.AI;
    }

    @Override
    public boolean canMine() {
        return RoamersMod.CONFIG.allowDescendantChores && this.hasGoodRelationshipWithParent() && !this.hasFullInventory() && (this.currentChore == AssignedChore.MINE && this.hasTaggedItemsInInventory((TagKey<Item>)PICKAXES) || this.currentChore == AssignedChore.CHOP && this.hasTaggedItemsInInventory((TagKey<Item>)AXES)) && !this.shouldSleep() && !this.isHungry();
    }

    @Override
    public boolean canFarm() {
        return RoamersMod.CONFIG.allowDescendantChores && this.hasGoodRelationshipWithParent() && !this.hasFullInventory() && this.currentChore == AssignedChore.FARM && this.hasTaggedItemsInInventory((TagKey<Item>)HOES) && !this.shouldSleep() && !this.isStarving();
    }

    @Override
    public boolean canFish() {
        return RoamersMod.CONFIG.allowDescendantChores && !this.hatesParent() && !this.hasFullInventory() && this.currentChore == AssignedChore.FISH && this.hasItemsInInventory(Items.f_42523_) && !this.shouldSleep() && !this.isHungry();
    }

    @Override
    public boolean canContinueToFish() {
        return this.canFish();
    }

    @Override
    public boolean canContinueToMine() {
        return this.canMine();
    }

    @Override
    public boolean canContinueToFarm() {
        return this.canFarm();
    }

    @Override
    public boolean shouldHunt() {
        return RoamersMod.CONFIG.allowDescendantChores && !this.hatesParent() && !this.hasFullInventory() && this.currentChore == AssignedChore.HUNT && this.hasTaggedItemsInInventory((TagKey<Item>)SWORDS) && !this.shouldSleep() && !this.isStarving();
    }

    public boolean shouldFollow() {
        return !this.hatesParent() && this.currentChore == AssignedChore.FOLLOW && !this.m_5803_();
    }

    public boolean hasGoodRelationshipWithParent() {
        return this.m_21826_() != null && this.isFriend((Player)this.m_21826_());
    }

    public boolean hasGreatRelationshipWithParent() {
        return this.m_21826_() != null && this.isBestFriend((Player)this.m_21826_());
    }

    public boolean hatesParent() {
        return this.m_21826_() != null && this.isEnemy((Player)this.m_21826_());
    }

    public void setClothingColor(DyeColor dyeColor) {
        this.f_19804_.m_135381_(CLOTHES_COLOR, (Object)dyeColor.m_41060_());
    }

    @Override
    public void m_6667_(DamageSource source) {
        Component deathMessage = this.m_21231_().m_19293_();
        super.m_6667_(source);
        if (!this.f_19853_.f_46443_ && this.f_19853_.m_46469_().m_46207_(GameRules.f_46142_) && this.m_21826_() instanceof ServerPlayer) {
            this.m_21826_().m_213846_((Component)Component.m_237113_((String)("\u00a7c" + deathMessage.getString())));
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.m_21805_() != null) {
            tag.m_128362_("ParentPlayer", this.m_21805_());
        }
        tag.m_128359_("Chore", this.currentChore.toString());
        tag.m_128405_("ClothingColor", ((Integer)this.f_19804_.m_135370_(CLOTHES_COLOR)).intValue());
        this.bedPos = null;
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        UUID uuid;
        super.m_7378_(tag);
        if (tag.m_128403_("ParentPlayer") && (uuid = tag.m_128342_("ParentPlayer")) != null) {
            this.setParentUUID(uuid);
        }
        if (tag.m_128441_("ClothingColor")) {
            this.f_19804_.m_135381_(CLOTHES_COLOR, (Object)tag.m_128451_("ClothingColor"));
        }
        if (tag.m_128441_("Chore")) {
            this.currentChore = AssignedChore.valueOf(tag.m_128461_("Chore"));
        }
        this.bedPos = null;
    }

    @Override
    public void equipArmor() {
        if (!this.f_20911_ && this.shouldEquipArmor(null) && this.hasTaggedItemsInInventory((TagKey<Item>)Tags.Items.ARMORS)) {
            int boots;
            int leggings;
            int chestplate;
            int helmet;
            if (this.shouldEquipArmor(EquipmentSlot.HEAD) && (helmet = this.characterInventory.getItemsSlotWithTaggedItem((TagKey<Item>)Tags.Items.ARMORS_HELMETS)) > -1) {
                this.m_6674_(InteractionHand.MAIN_HAND);
                this.characterInventory.swapSlots(0, helmet);
                return;
            }
            if (this.shouldEquipArmor(EquipmentSlot.CHEST) && (chestplate = this.characterInventory.getItemsSlotWithTaggedItem((TagKey<Item>)Tags.Items.ARMORS_CHESTPLATES)) > -1) {
                this.m_6674_(InteractionHand.MAIN_HAND);
                this.characterInventory.swapSlots(1, chestplate);
                return;
            }
            if (this.shouldEquipArmor(EquipmentSlot.LEGS) && (leggings = this.characterInventory.getItemsSlotWithTaggedItem((TagKey<Item>)Tags.Items.ARMORS_LEGGINGS)) > -1) {
                this.m_6674_(InteractionHand.MAIN_HAND);
                this.characterInventory.swapSlots(2, leggings);
                return;
            }
            if (this.shouldEquipArmor(EquipmentSlot.FEET) && (boots = this.characterInventory.getItemsSlotWithTaggedItem((TagKey<Item>)Tags.Items.ARMORS_BOOTS)) > -1) {
                this.m_6674_(InteractionHand.MAIN_HAND);
                this.characterInventory.swapSlots(3, boots);
            }
        }
    }

    public boolean shouldEquipArmor(@Nullable EquipmentSlot slot) {
        return slot != null ? this.m_6844_(slot).m_41619_() : this.m_6844_(EquipmentSlot.HEAD).m_41619_() || this.m_6844_(EquipmentSlot.CHEST).m_41619_() || this.m_6844_(EquipmentSlot.LEGS).m_41619_() || this.m_6844_(EquipmentSlot.FEET).m_41619_();
    }

    public void chooseName(Player player) {
        this.m_6593_((Component)Component.m_237113_((String)new NameGenerator().createDescendantName(this, player)));
    }

    public boolean isCreative() {
        if (!RoamersMod.CONFIG.doDescendantCreativeModeFlight) {
            return false;
        }
        Player player = (Player)this.m_21826_();
        if (player == null) {
            return false;
        }
        return player.m_7500_();
    }

    @Override
    public InteractionResult m_6071_(final Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        player.m_6674_(hand);
        if (this.m_5803_() && !this.f_19853_.m_5776_()) {
            this.m_5796_();
            this.wakeCooldown = 100;
            this.removeRelationPoints(player, this.m_6162_() ? 5 : 1);
            return InteractionResult.CONSUME;
        }
        if (!this.m_5803_() && player.m_6144_() && (stack.m_41619_() || !stack.m_204117_(FOODS) && !stack.m_204117_(PLANTABLES)) && this.m_21826_() == player && player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return PlayerDescendant.this.m_5446_();
                }

                public AbstractContainerMenu m_7208_(int id, Inventory inv, Player plr) {
                    FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                    buf.m_130064_(player.m_20183_());
                    buf.writeByte(0);
                    buf.m_130130_(PlayerDescendant.this.m_19879_());
                    return new CharacterInventoryMenu(id, inv, buf);
                }
            }, byteBuf -> {
                byteBuf.m_130064_(player.m_20183_());
                byteBuf.writeByte(0);
                byteBuf.m_130130_(this.m_19879_());
            });
            return InteractionResult.CONSUME;
        }
        if (this.m_21826_() == player && stack.m_41720_() instanceof DyeItem) {
            DyeColor dyeColor = ((DyeItem)stack.m_41720_()).m_41089_();
            if (dyeColor != this.getClothingColor()) {
                this.setClothingColor(dyeColor);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                return InteractionResult.CONSUME;
            }
        } else if (this.m_21826_() == player && (stack.m_41619_() || !stack.m_204117_(FOODS) && !stack.m_204117_(PLANTABLES))) {
            this.currentChore = this.currentChore == AssignedChore.FOLLOW ? AssignedChore.NONE : AssignedChore.FOLLOW;
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return this.giveFood(player, hand);
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(PARENT_PLAYER)).orElse(null);
    }

    public void setParentUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(PARENT_PLAYER, Optional.ofNullable(uuid));
    }

    @Nullable
    public Entity m_21826_() {
        try {
            UUID uuid = this.m_21805_();
            return uuid == null ? null : this.f_19853_.m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PARENT_PLAYER, Optional.empty());
        this.f_19804_.m_135372_(CLOTHES_COLOR, (Object)DyeColor.WHITE.m_41060_());
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 20.0);
        builder = builder.m_22268_(Attributes.f_22280_, 0.6);
        return builder;
    }

    @Override
    @Nullable
    public BlockPos getHomePos() {
        return null;
    }

    public static enum AssignedChore {
        FISH,
        MINE,
        CHOP,
        HUNT,
        FARM,
        COOK,
        FOLLOW,
        NONE;

    }

    class PlayerDescendantMoveControl
    extends MoveControl {
        private final PlayerDescendant descendant;
        public final FlyingPathNavigation creativeNavigation;
        public final GroundPathNavigation normalNavigation;

        public PlayerDescendantMoveControl(PlayerDescendant descendant) {
            super((Mob)descendant);
            this.descendant = descendant;
            this.creativeNavigation = new FlyingPathNavigation((Mob)descendant, PlayerDescendant.this.f_19853_);
            this.normalNavigation = new GroundPathNavigation((Mob)descendant, PlayerDescendant.this.f_19853_);
            this.creativeNavigation.m_26440_(true);
            this.creativeNavigation.m_7008_(true);
            this.normalNavigation.m_26477_(true);
            this.normalNavigation.m_7008_(true);
        }

        public void m_8126_() {
            this.updateNavigation();
            if (PlayerDescendant.this.f_21344_ instanceof FlyingPathNavigation) {
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.f_24974_.m_20242_(true);
                    double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                    double d1 = this.f_24976_ - this.f_24974_.m_20186_();
                    double d2 = this.f_24977_ - this.f_24974_.m_20189_();
                    double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                    if (d3 < 2.500000277905201E-7) {
                        this.f_24974_.m_21567_(0.0f);
                        this.f_24974_.m_21564_(0.0f);
                        return;
                    }
                    float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f, 90.0f));
                    float f1 = this.f_24974_.m_20096_() ? (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)) : (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22280_));
                    this.f_24974_.m_7910_(f1);
                    double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                    if (Math.abs(d1) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                        float f2 = (float)(-(Mth.m_14136_((double)d1, (double)d4) * 57.2957763671875));
                        this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), f2, 20.0f));
                        this.f_24974_.m_21567_(d1 > 0.0 ? f1 : -f1);
                    }
                } else {
                    this.f_24974_.m_21567_(0.0f);
                    this.f_24974_.m_21564_(0.0f);
                }
            } else {
                super.m_8126_();
            }
        }

        public PathNavigation getNavigation() {
            return PlayerDescendant.this.f_21344_;
        }

        public void updateNavigation() {
            if (this.descendant.isCreative()) {
                if (!(this.descendant.m_21573_() instanceof FlyingPathNavigation)) {
                    this.refreshDescendantBrain();
                    PlayerDescendant.this.f_21344_ = (PathNavigation)this.creativeNavigation;
                    this.descendant.getAI().refreshBrain();
                }
            } else if (!(this.descendant.m_21573_() instanceof GroundPathNavigation)) {
                this.refreshDescendantBrain();
                PlayerDescendant.this.f_21344_ = (PathNavigation)this.normalNavigation;
                this.descendant.m_20242_(false);
                this.descendant.getAI().refreshBrain();
            }
        }

        private void refreshDescendantBrain() {
            if (this.descendant.getAI() != null) {
                if (this.descendant.getAI().currentBrain != null) {
                    this.descendant.getAI().stopAllGoals();
                    this.descendant.getAI().currentBrain.clear();
                }
                this.descendant.getAI().doorGoal = null;
            }
        }
    }
}

