/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity;

import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.caitie.roamers.RoamersMod;
import net.caitie.roamers.entity.AbstractCharacter;
import net.caitie.roamers.entity.PlayerDescendant;
import net.caitie.roamers.entity.PlayerLike;
import net.caitie.roamers.entity.RoamerEntity;
import net.caitie.roamers.entity.ai.PlayerLikeAI;
import net.caitie.roamers.entity.ai.TaskUtils;
import net.caitie.roamers.entity.ai.tasks.BuildTask;
import net.caitie.roamers.entity.genes.EyeColors;
import net.caitie.roamers.entity.genes.HairColors;
import net.caitie.roamers.entity.genes.SkinColors;
import net.caitie.roamers.init.RoamersModEntityDataSerializers;
import net.caitie.roamers.util.BuilderManager;
import net.caitie.roamers.util.CraftingManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public abstract class PlayerLikeCharacter
extends AbstractCharacter
implements PlayerLike {
    public static final EntityDataAccessor<Genetics> GENES = SynchedEntityData.m_135353_(PlayerLikeCharacter.class, (EntityDataSerializer)((EntityDataSerializer)RoamersModEntityDataSerializers.GENETICS.get()));
    public static TagKey PICKAXES = Tags.Items.TOOLS_PICKAXES;
    public static TagKey AXES = Tags.Items.TOOLS_AXES;
    public static TagKey SWORDS = Tags.Items.TOOLS_SWORDS;
    public static TagKey SHOVELS = Tags.Items.TOOLS_SHOVELS;
    public static TagKey HOES = Tags.Items.TOOLS_HOES;
    protected boolean isSneaking = false;
    public final GoalSelector taskSelector;
    private final CraftingManager craftingManager = new CraftingManager(this);
    private final BuilderManager buildManager = new BuilderManager(this);
    private int foodLevel = 20;
    private int lastFoodLevel = 20;
    private float saturationLevel = 5.0f;
    private float exhaustionLevel;
    private int foodTickTimer;
    private int eatTimer = 0;
    private int eatCount = 0;
    public int miningCooldown = 10;
    public int buildingCooldown = 20;
    public int farmingCooldown = 20;
    public int fishingCooldown = 20;
    public boolean eating;
    public Item wantsToCraftItem = null;
    public Item wantsToMine = null;
    private Activity currentActivity = Activity.IDLE;
    private PlayerLike.BuilderGoal buildingGoal = PlayerLike.BuilderGoal.NONE;
    public BlockPos structurePos;
    public Rotation structureRot;
    @Nullable
    public BlockPos farmPos;
    @Nullable
    public BlockPos bedPos;
    @Nullable
    public BlockPos craftingTablePos = null;
    public int wakeCooldown;
    public int buildType = 0;

    public PlayerLikeCharacter(EntityType<? extends PlayerLikeCharacter> chr, Level world) {
        super(chr, world);
        this.m_21557_(false);
        this.taskSelector = new GoalSelector(world.m_46658_());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance instance, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (type == MobSpawnType.BREEDING && tag != null) {
            if (this instanceof RoamerEntity) {
                Genetics momGenes = Genetics.loadFromNBTOrDefault(this, tag.m_128469_("MomGenes"));
                Genetics dadGenes = Genetics.loadFromNBTOrDefault(this, tag.m_128469_("DadGenes"));
                this.setGenes(Genetics.createFromBreeding(momGenes, dadGenes, this));
            } else if (this instanceof PlayerDescendant) {
                Genetics parentGenes = Genetics.loadFromNBTOrDefault(this, tag.m_128469_("ParentGenes"));
                this.setGenes(Genetics.createPlayerDescendantGenes(parentGenes, AbstractCharacter.Race.valueOf(tag.m_128461_("Race")), (PlayerDescendant)this));
            }
        } else {
            this.setGenes(Genetics.DefaultVariations.shuffle(Genetics.DefaultVariations.findRace(this.getRace())));
        }
        return super.m_6518_(accessor, instance, type, data, tag);
    }

    @Override
    public AbstractCharacter.Race race() {
        return this.getRace();
    }

    @Override
    public BuilderManager getBuilderManager() {
        return this.buildManager;
    }

    @Override
    public boolean canBuild() {
        return this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_) && RoamersMod.CONFIG.allowBuilding && !this.m_6162_();
    }

    @Override
    public boolean canCraft() {
        return RoamersMod.CONFIG.allowCrafting && !this.m_6162_();
    }

    @Override
    public boolean canFarm() {
        return RoamersMod.CONFIG.allowFarming && !this.m_6162_();
    }

    @Override
    public boolean canMine() {
        return this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_) && RoamersMod.CONFIG.allowMining && !this.m_6162_();
    }

    public boolean shouldSleep() {
        if (this.hasBed()) {
            return !this.m_5803_() && (!this.f_19853_.m_46461_() || this.isDepressed()) && this.wakeCooldown <= 0;
        }
        return false;
    }

    public boolean hasBed() {
        return this.bedPos != null && this.f_19853_.m_8055_(this.bedPos).isBed((BlockGetter)this.f_19853_, this.bedPos, null);
    }

    @Override
    public boolean canFish() {
        return RoamersMod.CONFIG.allowFishing && !this.m_6162_() && !this.hasTaggedItemsInInventory((TagKey<Item>)EDIBLES) && this.hasItemsInInventory(Items.f_42523_) && this.isHungry();
    }

    public void checkDepression() {
        if (RoamersMod.CONFIG.allowMoods && RoamersMod.CONFIG.allowDepression) {
            if (!this.childrenUUIDs.isEmpty() && !this.isDepressed()) {
                int i = this.f_19796_.m_188503_(this.childrenUUIDs.size());
                AbstractCharacter baby = this.getNearestChildByUUID((UUID)this.childrenUUIDs.get(i), true);
                if (this.childrenUUIDs.get(i) != null && baby == null || baby.m_21224_()) {
                    this.setMood(AbstractCharacter.Mood.DEPRESSED, 6000);
                    this.childrenUUIDs.remove(i);
                    return;
                }
            }
            if (RoamersMod.CONFIG.allowClaustrophobia) {
                boolean confined = this.checkIfConfined();
                if (!(this.m_5803_() || this.isHomeOrBuilding() || this.isPlayingOnBed() || this.moodCheck != 5)) {
                    if (confined) {
                        if (this.isMining() && this.moodValue > -1400 && Mth.m_216271_((RandomSource)this.f_19796_, (int)0, (int)100) < 10) {
                            this.shrinkMoodValue();
                        } else if (!this.isMining() && this.moodValue > -1400) {
                            this.shrinkMoodValue();
                        }
                    }
                } else if ((this.isPlayingOnBed() || this.isHomeOrBuilding() || !confined) && this.moodCheck == 5 && this.moodValue < 0) {
                    this.addMoodValue();
                }
            }
        }
    }

    public boolean isHomeOrBuilding() {
        if (this.getHomePos() != null && this.getHomePos().m_203195_((Position)this.m_20182_(), 10.0)) {
            return true;
        }
        return this.currentActivity == Activity.BUILDING;
    }

    public boolean isPlayingOnBed() {
        return this.m_6162_() && this.m_20075_().m_204336_(BlockTags.f_13038_);
    }

    public boolean checkIfConfined() {
        if (RoamersMod.CONFIG.allowClaustrophobia) {
            if (TaskUtils.isInConfinedSpace(this, TaskUtils.createSpace(this, 2))) {
                return true;
            }
            return !TaskUtils.isOutside(this);
        }
        return false;
    }

    @Override
    public boolean hasFullInventory() {
        int flag = 0;
        for (int i = 6; i < this.m_35311_().m_6643_(); ++i) {
            ItemStack item = this.m_35311_().m_8020_(i);
            if (item.m_41619_()) continue;
            ++flag;
        }
        return flag >= this.m_35311_().m_6643_() - 6;
    }

    public void equipArmor() {
        if (!this.f_20911_) {
            if (this.hasTaggedItemsInInventory((TagKey<Item>)Tags.Items.ARMORS_HELMETS) && this.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                this.m_6674_(InteractionHand.MAIN_HAND);
                this.m_8061_(EquipmentSlot.HEAD, this.getTaggedItemsInInventory((TagKey<Item>)Tags.Items.ARMORS_HELMETS));
            }
            if (this.hasTaggedItemsInInventory((TagKey<Item>)Tags.Items.ARMORS_CHESTPLATES) && this.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
                this.m_6674_(InteractionHand.MAIN_HAND);
                this.m_8061_(EquipmentSlot.CHEST, this.getTaggedItemsInInventory((TagKey<Item>)Tags.Items.ARMORS_CHESTPLATES));
            }
            if (this.hasTaggedItemsInInventory((TagKey<Item>)Tags.Items.ARMORS_LEGGINGS) && this.m_6844_(EquipmentSlot.LEGS).m_41619_()) {
                this.m_6674_(InteractionHand.MAIN_HAND);
                this.m_8061_(EquipmentSlot.LEGS, this.getTaggedItemsInInventory((TagKey<Item>)Tags.Items.ARMORS_LEGGINGS));
            }
            if (this.hasTaggedItemsInInventory((TagKey<Item>)Tags.Items.ARMORS_BOOTS) && this.m_6844_(EquipmentSlot.FEET).m_41619_()) {
                this.m_6674_(InteractionHand.MAIN_HAND);
                this.m_8061_(EquipmentSlot.FEET, this.getTaggedItemsInInventory((TagKey<Item>)Tags.Items.ARMORS_BOOTS));
            }
        }
    }

    public boolean canFishTreasures() {
        return false;
    }

    protected void m_30232_() {
        super.m_30232_();
        if (!this.f_19853_.f_46443_ && this.getAI() != null) {
            this.getAI().refreshBrain();
        }
    }

    public void m_8119_() {
        if (RoamersMod.CONFIG.allowHunger) {
            boolean flag;
            this.lastFoodLevel = this.foodLevel;
            if (this.exhaustionLevel > 4.0f) {
                this.exhaustionLevel -= 4.0f;
                if (this.saturationLevel > 0.0f) {
                    this.saturationLevel = Math.max(this.saturationLevel - 1.0f, 0.0f);
                } else {
                    this.foodLevel = Math.max(this.foodLevel - 1, 0);
                }
            }
            if ((flag = RoamersMod.CONFIG.allowRegenAfterEating) && this.saturationLevel > 0.0f && this.isHurt() && this.foodLevel >= 20) {
                ++this.foodTickTimer;
                if (this.foodTickTimer >= 10) {
                    float f = Math.min(this.saturationLevel, 6.0f);
                    this.m_5634_(f / 6.0f);
                    this.addExhaustion(f);
                    this.foodTickTimer = 0;
                }
            } else if (flag && this.foodLevel >= 18 && this.isHurt()) {
                ++this.foodTickTimer;
                if (this.foodTickTimer >= 80) {
                    this.m_5634_(1.0f);
                    this.addExhaustion(6.0f);
                    this.foodTickTimer = 0;
                }
            } else if (this.foodLevel <= 0) {
                ++this.foodTickTimer;
                if (this.foodTickTimer >= 80) {
                    if (this.m_21223_() > 1.0f && this.f_19853_.m_46791_() != Difficulty.HARD || RoamersMod.CONFIG.allowStarvation) {
                        this.m_6469_(DamageSource.f_19313_, 1.0f);
                    }
                    this.foodTickTimer = 0;
                }
            } else {
                this.foodTickTimer = 0;
            }
        }
        if (this.m_20142_() && this.isStarving()) {
            this.sprint(false);
        }
        super.m_8119_();
        if (this.miningCooldown > 0) {
            --this.miningCooldown;
        }
        if (this.buildingCooldown > 0) {
            --this.buildingCooldown;
        }
        if (this.farmingCooldown > 0) {
            --this.farmingCooldown;
        }
        if (this.fishingCooldown > 0) {
            --this.fishingCooldown;
        }
        if (this.wakeCooldown > 0) {
            --this.wakeCooldown;
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_6142_()) {
            this.f_19853_.m_46473_().m_6180_("plcAi");
            this.playerLikeAiTick();
            this.f_19853_.m_46473_().m_7238_();
        }
        this.m_21203_();
        this.equipArmor();
        if (!this.m_21525_() && RoamersMod.CONFIG.allowEating && (this.isHungry() || this.isHurt() && this.foodLevel < 20 && RoamersMod.CONFIG.allowRegenAfterEating)) {
            this.eatTick();
        }
    }

    protected void playerLikeAiTick() {
        if (this.getAI().currentBrain == null) {
            this.getAI().initAI();
        } else {
            this.f_19853_.m_46473_().m_6180_("plcAiTick");
            this.serverAiTick();
            this.f_19853_.m_46473_().m_7238_();
        }
        PlayerLikeAI ai = this.getAI();
        if (!this.m_5803_() && !this.m_5912_()) {
            if (this.isDepressed()) {
                ai.disableFlag(Goal.Flag.LOOK);
                this.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)this.m_20183_().m_7495_()));
            } else {
                ai.enableFlag(Goal.Flag.LOOK);
            }
        } else if (this.m_5803_()) {
            ai.stopAllGoals();
            if (this.f_19853_.m_46461_() && !this.isDepressed()) {
                this.m_5796_();
            }
        }
    }

    private void serverAiTick() {
        if (this.m_6142_()) {
            int i = this.f_19853_.m_7654_().m_129921_() + this.m_19879_();
            if (i % 2 != 0 && this.f_19797_ > 1) {
                this.f_19853_.m_46473_().m_6180_("taskSelector");
                this.taskSelector.m_186081_(false);
                this.f_19853_.m_46473_().m_7238_();
            } else {
                this.f_19853_.m_46473_().m_6180_("taskSelector");
                this.taskSelector.m_25373_();
                this.f_19853_.m_46473_().m_7238_();
                this.f_19853_.m_46473_().m_6180_("playerLikeAI");
                this.getAI().tickAI();
                this.f_19853_.m_46473_().m_7238_();
            }
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_6142_()) {
            if (this.canCraft() && !this.m_5803_()) {
                if (this.wantsToCraftItem == null) {
                    this.craftEssentials();
                }
                boolean amount = this.getWantedBuildingBlock() != null && this.wantsToCraftItem == this.getWantedBuildingBlock().m_5456_() ? !this.hasItemsInInventory(this.wantsToCraftItem) : this.craftingManager.testInventory(this.wantsToCraftItem);
                this.craftingManager.tick(20, this.craftingManager.canCraftInInventory(this.wantsToCraftItem) && amount);
            }
            if (this.canBuild()) {
                this.findBuilderGoal();
                this.buildManager.tick();
            }
            this.checkDepression();
        }
    }

    public abstract PlayerLikeAI getAI();

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_5803_() && !this.f_19853_.m_5776_()) {
            this.m_5796_();
            this.wakeCooldown = 100;
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        Entity entity = damageSource.m_7639_();
        if (this.m_6162_() && entity instanceof PlayerLikeCharacter && ((PlayerLikeCharacter)entity).m_6162_()) {
            return false;
        }
        if (entity instanceof Player) {
            if (this.isBestFriend((Player)entity) && this.getTrait() != AbstractCharacter.Traits.HOTHEAD) {
                this.m_6710_(null);
                this.m_21561_(false);
            }
            if (!this.m_6162_() && !this.isDepressed()) {
                this.setMood(this.getTrait() == AbstractCharacter.Traits.HOTHEAD ? AbstractCharacter.Mood.FURIOUS : AbstractCharacter.Mood.ANGRY, 800);
                this.getAI().switchCurrentState(PlayerLikeAI.State.ATTACKING);
            }
        }
        return super.m_6469_(damageSource, amount);
    }

    public void checkIfValidFarm() {
        if (this.farmPos != null) {
            if (!this.f_19853_.m_46801_(this.farmPos)) {
                this.farmPos = null;
                return;
            }
            if (!this.farmPos.m_203195_((Position)this.m_20182_(), 200.0)) {
                this.farmPos = null;
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        if (entity instanceof Player && this.isFriend((Player)entity)) {
            this.m_6710_(null);
            this.m_21561_(false);
        }
        return super.m_7327_(entity);
    }

    public void m_6710_(@Nullable LivingEntity entity) {
        if (entity != null) {
            if (this.childrenUUIDs.contains(entity.m_20148_())) {
                return;
            }
            if (entity instanceof PlayerLikeCharacter && entity.m_6162_()) {
                return;
            }
        }
        super.m_6710_(entity);
    }

    public void m_7023_(Vec3 vec3) {
        double x1 = this.m_20185_();
        double y1 = this.m_20186_();
        double z1 = this.m_20189_();
        super.m_7023_(vec3);
        if (this.m_6084_()) {
            this.checkMovement(this.m_20185_() - x1, this.m_20186_() - y1, this.m_20189_() - z1);
        }
    }

    public void checkMovement(double x, double y, double z) {
        if (!this.m_20159_()) {
            int l;
            if (this.m_20069_()) {
                int k = Math.round((float)Math.sqrt(x * x + z * z) * 100.0f);
                if (k > 0) {
                    this.addExhaustion(0.05f * (float)k * 0.01f);
                }
            } else if (this.m_20096_() && (l = Math.round((float)Math.sqrt(x * x + z * z) * 100.0f)) > 0) {
                if (this.m_20142_()) {
                    this.addExhaustion(0.15f * (float)l * 0.01f);
                } else {
                    this.addExhaustion(0.05f * (float)l * 0.01f);
                }
            }
        }
    }

    public void findBuilderGoal() {
        if (this.getHomePos() != null) {
            if (this.craftingTablePos != null && this.f_19853_.m_8055_(this.craftingTablePos).m_60713_(Blocks.f_50091_)) {
                this.setBuildingGoal(PlayerLike.BuilderGoal.HUT);
                return;
            }
            if (this.f_19853_.m_8055_(this.getHomePos()).m_60713_(Blocks.f_50683_)) {
                this.setBuildingGoal(PlayerLike.BuilderGoal.CRAFTING_TABLE);
                return;
            }
        }
        this.setBuildingGoal(PlayerLike.BuilderGoal.CAMPFIRE);
    }

    public boolean isMining() {
        return this.currentActivity == Activity.MINING || this.currentActivity == Activity.CHOPPING || this.currentActivity == Activity.DIGGING;
    }

    protected void craftEssentials() {
        if (this.getCurrentActivity() == Activity.FARMING && !this.hasItemsInInventory(Items.f_42499_) && this.getCraftingManager().canCraftItemOrIngredients(Items.f_42499_)) {
            this.wantsToCraftItem = Items.f_42499_;
            return;
        }
        if (this.getCurrentActivity() != Activity.COMBAT && !this.hasItemsInInventory(Items.f_42000_) && this.getCraftingManager().canCraftItemOrIngredients(Items.f_42000_) && this.shouldMakeTorch()) {
            this.wantsToCraftItem = Items.f_42000_;
            return;
        }
        if (this.isHungry() && this.currentActivity != Activity.COMBAT && this.canCraftBread()) {
            this.wantsToCraftItem = Items.f_42406_;
            return;
        }
        if (this.canBuild() && this.buildingGoal == PlayerLike.BuilderGoal.CRAFTING_TABLE) {
            this.wantsToCraftItem = Items.f_41960_;
            return;
        }
        this.wantsToCraftItem = this.getWantedBuildingBlock() != null ? this.getWantedBuildingBlock().m_5456_() : null;
    }

    protected boolean canCraftBread() {
        return !this.hasItemsInInventory(Items.f_42406_) && this.getCraftingManager().canCraftItemOrIngredients(Items.f_42406_);
    }

    protected boolean shouldMakeTorch() {
        return this.f_19853_.m_46803_(this.m_20183_()) <= 7;
    }

    public TagKey<Item> getNeededToolType(Activity activity) {
        return switch (activity) {
            case Activity.MINING -> PICKAXES;
            case Activity.CHOPPING -> AXES;
            case Activity.COMBAT -> SWORDS;
            case Activity.DIGGING -> SHOVELS;
            case Activity.FARMING -> HOES;
            default -> null;
        };
    }

    public ItemStack getFoodItemsInInventory(boolean starving) {
        ItemStack retval = ItemStack.f_41583_;
        if (!this.hasTaggedItemsInInventory((TagKey<Item>)EDIBLES)) {
            if (starving) {
                for (int i = 0; i < this.m_35311_().m_6643_(); ++i) {
                    ItemStack flagItem = this.m_35311_().m_8020_(i);
                    if (!flagItem.m_204117_(COOKABLES) || !flagItem.m_41614_()) continue;
                    retval = flagItem;
                    break;
                }
            }
            return retval;
        }
        for (int i = 0; i < this.m_35311_().m_6643_(); ++i) {
            ItemStack flagItem = this.m_35311_().m_8020_(i);
            if (!flagItem.m_204117_(EDIBLES) || !flagItem.m_41614_()) continue;
            retval = flagItem;
            break;
        }
        return retval;
    }

    public Genetics getGenes() {
        return (Genetics)this.f_19804_.m_135370_(GENES);
    }

    public Genetics getGenesOrDefault() {
        if (this.getGenes() != null) {
            return this.getGenes();
        }
        return new Genetics(this.getRace());
    }

    public void setGenes(Genetics newGenes) {
        this.f_19804_.m_135381_(GENES, (Object)newGenes);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.getGenes().saveToNBT(tag);
        this.getAI().saveTasks();
        tag.m_128359_("BuildingGoal", this.buildingGoal.name());
        tag.m_128405_("HungerLevel", this.foodLevel);
        tag.m_128405_("HungerTick", this.foodTickTimer);
        tag.m_128350_("Saturation", this.saturationLevel);
        tag.m_128350_("Exhaustion", this.exhaustionLevel);
        if (this.farmPos != null) {
            tag.m_128405_("FarmX", this.farmPos.m_123341_());
            tag.m_128405_("FarmY", this.farmPos.m_123342_());
            tag.m_128405_("FarmZ", this.farmPos.m_123343_());
        }
        if (this.bedPos != null) {
            tag.m_128405_("BedX", this.bedPos.m_123341_());
            tag.m_128405_("BedY", this.bedPos.m_123342_());
            tag.m_128405_("BedZ", this.bedPos.m_123343_());
        }
        if (this.craftingTablePos != null) {
            tag.m_128405_("CraftX", this.craftingTablePos.m_123341_());
            tag.m_128405_("CraftY", this.craftingTablePos.m_123342_());
            tag.m_128405_("CraftZ", this.craftingTablePos.m_123343_());
        }
        tag.m_128405_("BuildType", this.buildType);
        if (this.structurePos != null) {
            tag.m_128405_("StructureX", this.structurePos.m_123341_());
            tag.m_128405_("StructureY", this.structurePos.m_123342_());
            tag.m_128405_("StructureZ", this.structurePos.m_123343_());
            if (this.structureRot != null) {
                tag.m_128359_("StructureRot", this.structureRot.toString());
            }
        }
        this.buildManager.getOrCreateData(tag);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GENES, (Object)new Genetics(this.getRace()));
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        Genetics genetics = Genetics.loadFromNBT(tag);
        if (genetics != null) {
            this.setGenes(genetics);
        } else {
            this.setGenes(Genetics.DefaultVariations.shuffle(Genetics.DefaultVariations.findRace(this.getRace())));
        }
        if (tag.m_128441_("FarmX")) {
            this.farmPos = new BlockPos(tag.m_128451_("FarmX"), tag.m_128451_("FarmY"), tag.m_128451_("FarmZ"));
        }
        if (tag.m_128441_("BedX")) {
            this.bedPos = new BlockPos(tag.m_128451_("BedX"), tag.m_128451_("BedY"), tag.m_128451_("BedZ"));
        }
        if (tag.m_128441_("CraftX")) {
            this.craftingTablePos = new BlockPos(tag.m_128451_("CraftX"), tag.m_128451_("CraftY"), tag.m_128451_("CraftZ"));
        }
        if (tag.m_128441_("BuildingGoal")) {
            this.buildingGoal = PlayerLike.BuilderGoal.valueOf(tag.m_128461_("BuildingGoal"));
        }
        if (tag.m_128441_("BuildType")) {
            this.buildType = tag.m_128451_("BuildType");
        }
        if (tag.m_128441_("StructureX")) {
            this.structurePos = new BlockPos(tag.m_128451_("StructureX"), tag.m_128451_("StructureY"), tag.m_128451_("StructureZ"));
            if (tag.m_128441_("StructureRot")) {
                this.structureRot = Rotation.valueOf((String)tag.m_128461_("StructureRot"));
            }
        }
        if (tag.m_128441_("HungerLevel")) {
            this.foodLevel = tag.m_128451_("HungerLevel");
            this.foodTickTimer = tag.m_128451_("HungerTick");
            this.saturationLevel = tag.m_128457_("Saturation");
            this.exhaustionLevel = tag.m_128457_("Exhaustion");
        }
        this.buildManager.getOrCreateData(tag);
    }

    @Override
    public boolean shouldHunt() {
        return super.shouldHunt() && this.currentActivity != Activity.COOKING && !this.hasFood() && this.getAmountOfTaggedItems(HUNTABLES) <= 6;
    }

    public boolean m_6144_() {
        return this.isSneaking;
    }

    public void setSneaking(boolean b) {
        this.isSneaking = b;
    }

    public Activity getCurrentActivity() {
        return this.currentActivity;
    }

    public void setCurrentActivity(Activity activity) {
        this.currentActivity = activity;
    }

    @Override
    public PlayerLike.BuilderGoal getBuildingGoal() {
        return this.buildingGoal;
    }

    @Override
    public BlockPos bpos() {
        return this.m_20183_();
    }

    @Override
    public boolean canContinueToBuild() {
        if (this.buildingGoal == PlayerLike.BuilderGoal.CAMPFIRE) {
            return this.canBuild() && !this.isHungry();
        }
        return this.canBuild() && !this.isHungry() && !this.shouldSleep();
    }

    @Override
    public boolean canContinueToMine() {
        return this.canMine() && !this.shouldSleep() && !this.isHungry();
    }

    public boolean canContinueToFarm() {
        return this.canFarm() && (!this.shouldSleep() || this.isHungry());
    }

    public boolean canContinueToFish() {
        return this.canFish() && this.getAmountOfTaggedItems(COOKABLES) < 6 && !this.shouldSleep();
    }

    @Override
    public Level level() {
        return this.f_19853_;
    }

    public void setBuildingGoal(PlayerLike.BuilderGoal goal) {
        this.buildingGoal = goal;
        if (goal == PlayerLike.BuilderGoal.CAMPFIRE) {
            this.buildManager.setBuildingBlock(Blocks.f_50683_);
        } else if (goal == PlayerLike.BuilderGoal.CRAFTING_TABLE) {
            this.buildManager.setBuildingBlock(Blocks.f_50091_);
        } else if (goal == PlayerLike.BuilderGoal.HUT) {
            this.buildManager.setWantedStructure(this.race().toString().toLowerCase() + "_" + goal.toString().toLowerCase() + this.buildType);
        }
    }

    @Override
    public BuildTask getBuildingTask() {
        return this.getAI().buildTask;
    }

    public void sprint(boolean b) {
        if (b && !this.isStarving()) {
            this.m_6858_(b);
        } else {
            this.m_6858_(false);
        }
    }

    public void jump() {
        this.m_6135_();
        if (this.m_20142_()) {
            this.addExhaustion(0.2f);
        } else {
            this.addExhaustion(0.05f);
        }
    }

    public int getHungerLevel() {
        return this.foodLevel;
    }

    public int getLastHungerLevel() {
        return this.lastFoodLevel;
    }

    public float getSaturation() {
        return this.saturationLevel;
    }

    public float getExhaustion() {
        return this.exhaustionLevel;
    }

    public boolean isHungry() {
        return this.foodLevel <= 16;
    }

    public boolean isStarving() {
        return this.foodLevel <= 6;
    }

    public CraftingManager getCraftingManager() {
        return this.craftingManager;
    }

    @Override
    public Item getWantedCraftingItem() {
        return this.wantsToCraftItem;
    }

    @Override
    public Block getWantedBuildingBlock() {
        return this.buildManager.getBuildingBlock();
    }

    public void setWantedCraftingItem(Item item) {
        this.wantsToCraftItem = item;
    }

    public void setHungerLevel(int i) {
        this.foodLevel = i;
    }

    public void setLastHungerLevel(int i) {
        this.lastFoodLevel = i;
    }

    public void setSaturationLevel(float f) {
        this.saturationLevel = f;
    }

    public void setExhaustionLevel(float f) {
        this.exhaustionLevel = f;
    }

    public void addExhaustion(float f) {
        this.exhaustionLevel = Math.min(this.exhaustionLevel + f, 40.0f);
    }

    public void eatTick() {
        ItemStack food = this.getFoodItemsInInventory(this.isStarving());
        if (food != ItemStack.f_41583_) {
            int finishEat;
            this.m_8061_(EquipmentSlot.MAINHAND, food);
            int n = finishEat = food.getFoodProperties((LivingEntity)this).m_38748_() ? 5 : 7;
            if (this.eatCount >= finishEat) {
                this.eatFood(food);
                this.m_35311_().m_19170_(food.m_41720_(), 1);
                this.m_146850_(GameEvent.f_157806_);
                this.eatCount = 0;
                this.eating = false;
            } else if (++this.eatTimer >= 4) {
                this.eating = true;
                this.f_19853_.m_7605_((Entity)this, (byte)63);
                this.m_5496_(SoundEvents.f_11912_, this.m_6100_() + 0.5f * (float)this.f_19796_.m_188503_(2), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                ++this.eatCount;
                this.eatTimer = 0;
            }
        }
    }

    @Override
    public void m_7581_(ItemEntity itement) {
        if (this.m_35311_().m_19183_(itement.m_32055_())) {
            Entity ent = itement.m_238333_();
            if (ent instanceof Player) {
                ItemStack stack = itement.m_32055_();
                if (this.getWantedBuildingBlock() != null && stack.m_150930_(this.getWantedBuildingBlock().m_5456_())) {
                    this.addRelationPoints((Player)ent, stack.m_41613_() / 2 + 1);
                } else if (this.wantsToCraftItem != null && stack.m_150930_(this.wantsToCraftItem)) {
                    this.addRelationPoints((Player)ent, stack.m_41613_() / 2 + 1);
                } else if (this.craftingManager.getCraftingItem() != null && stack.m_150930_(this.craftingManager.getCraftingItem())) {
                    this.addRelationPoints((Player)ent, stack.m_41613_() / 2 + 1);
                } else if (this.wantsToMine != null && stack.m_150930_(this.wantsToMine)) {
                    this.addRelationPoints((Player)ent, stack.m_41613_() / 2 + 1);
                } else if (this.craftingManager.getWantedIngredient() != null && this.craftingManager.getWantedIngredient().test(stack)) {
                    this.addRelationPoints((Player)ent, stack.m_41613_() / 2 + 1);
                }
                if (!this.isInLove() && this.m_146764_() == 0 && this instanceof RoamerEntity && this.getRelationship((Player)ent) >= RoamersMod.CONFIG.maxRelationStatus && (itement.m_32055_().m_204117_(FOODS) || itement.m_32055_().m_204117_(TREASURES))) {
                    this.setMood(AbstractCharacter.Mood.IN_LOVE, 1200);
                }
            }
            super.m_7581_(itement);
        }
    }

    public void eatFood(ItemStack itemstack) {
        FoodProperties foodprop;
        if (itemstack.m_41614_() && (foodprop = itemstack.getFoodProperties((LivingEntity)this)) != null) {
            this.eatFood(foodprop.m_38744_(), foodprop.m_38745_());
        }
    }

    public void eatFood(int i, float f) {
        this.foodLevel = Math.min(i + this.foodLevel, 20);
        this.saturationLevel = Math.min(this.saturationLevel + (float)i * f * 2.0f, (float)this.foodLevel);
        this.m_5496_(SoundEvents.f_12321_, 0.5f, this.m_6100_() - 0.1f + this.f_19796_.m_188501_() * 0.1f);
    }

    public boolean hasFood() {
        return this.hasTaggedItemsInInventory((TagKey<Item>)EDIBLES);
    }

    public boolean hasRawFood() {
        return this.hasTaggedItemsInInventory((TagKey<Item>)COOKABLES);
    }

    public static enum Activity {
        MINING,
        CHOPPING,
        DIGGING,
        COMBAT,
        FARMING,
        FISHING,
        BUILDING,
        COOKING,
        CRAFTING,
        IDLE;

    }

    public static class Genetics {
        public static final String GENES = "Genes";
        public static final String RACE = "Race";
        public static final String ALBINO = "Albino";
        public static final String EYE_COLORS = "EyeColors";
        public static final String HAIR_COLOR = "HairColor";
        public static final String SKIN_COLOR = "SkinColor";
        public static final String HAIR_STYLE = "HairStyle";
        public static final String CLOTHING = "Clothing";
        protected final AbstractCharacter.Race race;
        protected int[] eyeColors;
        protected int hairColor;
        protected int skinColor;
        protected int hairStyleNumber;
        protected String customClothing = null;
        protected boolean albino;
        protected boolean heterochromia;

        public Genetics(AbstractCharacter.Race race) {
            this.race = race;
            DefaultGenetics defaultGenetics = DefaultGenetics.findDefaultGenetics(race);
            this.eyeColors = defaultGenetics.getEyeColor();
            this.hairColor = defaultGenetics.getHairColor();
            this.skinColor = defaultGenetics.getSkinColor();
            this.hairStyleNumber = defaultGenetics.getHairStyle();
            this.albino = false;
            this.heterochromia = false;
        }

        public Genetics(PlayerLikeCharacter character, int[] eyeColors, int hairColor, int skinColor, int hairStyle) {
            this.albino = character.m_217043_().m_188503_(100) == 0;
            this.race = character.getRace();
            if (this.albino) {
                this.eyeColors = new int[]{EyeColors.ALBINO.getDecimalColor(), EyeColors.ALBINO.getDecimalColor()};
                this.hairColor = HairColors.SNOWY_WHITE.getDecimalColor();
            } else {
                this.eyeColors = eyeColors;
                this.hairColor = hairColor;
            }
            this.skinColor = skinColor;
            this.hairStyleNumber = hairStyle;
            this.heterochromia = eyeColors[0] != eyeColors[1];
        }

        public Genetics(AbstractCharacter.Race race, boolean albino, int[] eyeColors, int hairColor, int skinColor, int hairStyle) {
            this.race = race;
            this.albino = albino;
            this.eyeColors = eyeColors;
            this.hairColor = hairColor;
            this.skinColor = skinColor;
            this.hairStyleNumber = hairStyle;
            this.heterochromia = eyeColors[0] != eyeColors[1];
        }

        public static Genetics createFromBreeding(Genetics momGenes, Genetics dadGenes, PlayerLikeCharacter offspring) {
            int[] nArray;
            boolean heterochromia;
            RandomSource random = offspring.m_217043_();
            DefaultVariations momVariants = DefaultVariations.findRace(momGenes.race);
            DefaultVariations dadVariants = DefaultVariations.findRace(dadGenes.race);
            int momVariantEyes = momVariants.getEyeColor();
            int dadVariantEyes = dadVariants.getEyeColor();
            boolean bl = heterochromia = random.m_188503_(30) == 0;
            if (heterochromia) {
                if (random.m_188499_()) {
                    int[] nArray2 = new int[2];
                    nArray2[0] = momGenes.eyeColors[0];
                    nArray = nArray2;
                    nArray2[1] = dadGenes.eyeColors[1];
                } else {
                    int[] nArray3 = new int[2];
                    nArray3[0] = dadGenes.eyeColors[0];
                    nArray = nArray3;
                    nArray3[1] = momGenes.eyeColors[1];
                }
            } else if (random.m_188499_()) {
                nArray = random.m_188499_() ? momGenes.eyeColors : dadGenes.eyeColors;
            } else if (random.m_188499_()) {
                int[] nArray4 = new int[2];
                nArray4[0] = momVariantEyes;
                nArray = nArray4;
                nArray4[1] = momVariantEyes;
            } else {
                int[] nArray5 = new int[2];
                nArray5[0] = dadVariantEyes;
                nArray = nArray5;
                nArray5[1] = dadVariantEyes;
            }
            int[] eyes = nArray;
            int haircolor = random.m_188499_() ? (random.m_188499_() ? momGenes.getHairColor() : dadGenes.getHairColor()) : (random.m_188499_() ? momVariants.getHairColor() : dadVariants.getHairColor());
            int skinColor = random.m_188499_() ? momGenes.skinColor : dadGenes.skinColor;
            int hairStyle = offspring.isMale() ? dadGenes.hairStyleNumber : momGenes.hairStyleNumber;
            return new Genetics(offspring, eyes, haircolor, skinColor, hairStyle);
        }

        public static Genetics createPlayerDescendantGenes(Genetics parentGenes, AbstractCharacter.Race race, PlayerDescendant offspring) {
            int[] nArray;
            EyeColors eye1;
            DefaultVariations defaultGenes = DefaultVariations.findRace(race);
            RandomSource random = offspring.m_217043_();
            EyeColors eye0 = EyeColors.getEyeColor(parentGenes.eyeColors[0]);
            boolean heterochromia = eye0 != (eye1 = EyeColors.getEyeColor(parentGenes.eyeColors[1])) || random.m_188503_(30) == 0;
            int defaultEyes = defaultGenes.getEyeColor();
            if (heterochromia) {
                if (eye0 != eye1) {
                    if (random.m_188499_()) {
                        int[] nArray2 = new int[2];
                        nArray2[0] = parentGenes.eyeColors[0];
                        nArray = nArray2;
                        nArray2[1] = parentGenes.eyeColors[1];
                    } else {
                        int[] nArray3 = new int[2];
                        nArray3[0] = parentGenes.eyeColors[1];
                        nArray = nArray3;
                        nArray3[1] = parentGenes.eyeColors[0];
                    }
                } else if (random.m_188499_()) {
                    int[] nArray4 = new int[2];
                    nArray4[0] = defaultEyes;
                    nArray = nArray4;
                    nArray4[1] = parentGenes.eyeColors[0];
                } else {
                    int[] nArray5 = new int[2];
                    nArray5[0] = parentGenes.eyeColors[1];
                    nArray = nArray5;
                    nArray5[1] = defaultEyes;
                }
            } else if (random.m_188499_()) {
                int[] nArray6 = new int[2];
                nArray6[0] = defaultEyes;
                nArray = nArray6;
                nArray6[1] = defaultEyes;
            } else {
                nArray = parentGenes.eyeColors;
            }
            int[] offspringEyes = nArray;
            int offspringHair = random.m_188499_() ? defaultGenes.getHairColor() : parentGenes.hairColor;
            int offspringSkin = random.m_188499_() ? parentGenes.skinColor : defaultGenes.defaultGenes.skincolor;
            int offspringStyle = parentGenes.hairStyleNumber;
            return new Genetics(offspring, offspringEyes, offspringHair, offspringSkin, offspringStyle);
        }

        public static Genetics copy(Genetics genetics) {
            Genetics genes = new Genetics(genetics.race, genetics.albino, genetics.eyeColors, genetics.hairColor, genetics.skinColor, genetics.hairStyleNumber);
            if (genetics.customClothing != null) {
                genes.customClothing = genetics.customClothing;
            }
            return genes;
        }

        public void saveToNBT(CompoundTag tag) {
            tag.m_128365_(GENES, (Tag)this.save());
        }

        public CompoundTag save() {
            CompoundTag genes = new CompoundTag();
            genes.m_128359_(RACE, this.race.name());
            genes.m_128379_(ALBINO, this.albino);
            genes.m_128385_(EYE_COLORS, this.eyeColors);
            genes.m_128405_(HAIR_COLOR, this.hairColor);
            genes.m_128405_(HAIR_STYLE, this.hairStyleNumber);
            genes.m_128405_(SKIN_COLOR, this.skinColor);
            if (this.customClothing != null) {
                genes.m_128359_(CLOTHING, this.customClothing);
            }
            return genes;
        }

        public static Genetics loadFromNBTOrDefault(PlayerLikeCharacter character, CompoundTag tag) {
            Genetics genetics = Genetics.loadFromNBT(tag);
            return genetics == null ? new Genetics(character.getRace()) : genetics;
        }

        public static Genetics loadFromTag(CompoundTag genes) {
            Genetics genetics = new Genetics(AbstractCharacter.Race.valueOf(genes.m_128461_(RACE)), genes.m_128471_(ALBINO), genes.m_128465_(EYE_COLORS), genes.m_128451_(HAIR_COLOR), genes.m_128451_(SKIN_COLOR), genes.m_128451_(HAIR_STYLE));
            if (genes.m_128441_(CLOTHING)) {
                genetics.customClothing = genes.m_128461_(CLOTHING);
            }
            return genetics;
        }

        public static Genetics loadFromNBT(CompoundTag tag) {
            Genetics genetics = null;
            if (tag.m_128441_(GENES)) {
                CompoundTag genes = tag.m_128469_(GENES);
                genetics = Genetics.loadFromTag(genes);
            }
            return genetics;
        }

        public int getHairColor() {
            return this.hairColor;
        }

        public int[] getEyeColors() {
            return this.eyeColors;
        }

        public int getSkinColor() {
            return this.skinColor;
        }

        public int getHairStyle() {
            return this.hairStyleNumber;
        }

        public String getCustomClothing() {
            return this.customClothing;
        }

        public static float[] getTextureColors(int decimal) {
            int i = (decimal & 0xFF0000) >> 16;
            int j = (decimal & 0xFF00) >> 8;
            int k = (decimal & 0xFF) >> 0;
            return new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
        }

        public String toString() {
            String race = this.race.name();
            String skin = SkinColors.getSkinColor(this.skinColor).name();
            String eye0 = EyeColors.getEyeColor(this.eyeColors[0]).name();
            String eye1 = EyeColors.getEyeColor(this.eyeColors[1]).name();
            String hair = HairColors.getHairColor(this.hairColor).name();
            return "[Race: " + race + ", Skin: " + skin + ", Eyes:[" + eye0 + ", " + eye1 + "], Hair: " + hair + ", HairStyle: " + this.hairStyleNumber + ", Clothes: " + this.customClothing + "]";
        }

        public static enum DefaultGenetics {
            CELTIC(AbstractCharacter.Race.PLAINS, new int[]{EyeColors.DARK_GREEN.getDecimalColor(), EyeColors.DARK_GREEN.getDecimalColor()}, HairColors.PLAINS_RED.getDecimalColor(), SkinColors.PEACHY_WHITE.getDecimalColor(), 0),
            SAVANIC(AbstractCharacter.Race.SAVANNA, new int[]{EyeColors.HAZEL.getDecimalColor(), EyeColors.HAZEL.getDecimalColor()}, HairColors.BROWN.getDecimalColor(), SkinColors.TAN_WHITE.getDecimalColor(), 0),
            NORDIC(AbstractCharacter.Race.TAIGA, new int[]{EyeColors.LIGHT_BLUE.getDecimalColor(), EyeColors.LIGHT_BLUE.getDecimalColor()}, HairColors.BLONDE.getDecimalColor(), SkinColors.LIGHT_WHITE.getDecimalColor(), 0),
            DESERTIC(AbstractCharacter.Race.DESERT, new int[]{EyeColors.BLACK.getDecimalColor(), EyeColors.BLACK.getDecimalColor()}, HairColors.DARK_BROWN.getDecimalColor(), SkinColors.DARK_BROWN.getDecimalColor(), 3),
            MESANIC(AbstractCharacter.Race.BADLANDS, new int[]{EyeColors.RUSTIC.getDecimalColor(), EyeColors.RUSTIC.getDecimalColor()}, HairColors.DUSTY_BLONDE.getDecimalColor(), SkinColors.BROWN.getDecimalColor(), 2),
            JUNGESE(AbstractCharacter.Race.JUNGLE, new int[]{EyeColors.BLACK.getDecimalColor(), EyeColors.BLACK.getDecimalColor()}, HairColors.BLACK.getDecimalColor(), SkinColors.TAN.getDecimalColor(), 1),
            ESKIMO(AbstractCharacter.Race.ARTIC, new int[]{EyeColors.DARK_BLUE.getDecimalColor(), EyeColors.DARK_BLUE.getDecimalColor()}, HairColors.BLACK.getDecimalColor(), SkinColors.LIGHT_WHITE.getDecimalColor(), 0);

            private final AbstractCharacter.Race race;
            private final int[] eyecolor;
            private final int haircolor;
            private final int skincolor;
            private final int hairstyle;

            private DefaultGenetics(AbstractCharacter.Race race, int[] eyes, int hair, int skin, int style) {
                this.race = race;
                this.eyecolor = eyes;
                this.haircolor = hair;
                this.skincolor = skin;
                this.hairstyle = style;
            }

            public AbstractCharacter.Race race() {
                return this.race;
            }

            public int[] getEyeColor() {
                return this.eyecolor;
            }

            public int getHairColor() {
                return this.haircolor;
            }

            public int getSkinColor() {
                return this.skincolor;
            }

            public int getHairStyle() {
                return this.hairstyle;
            }

            static DefaultGenetics findDefaultGenetics(AbstractCharacter.Race race) {
                if (race == AbstractCharacter.Race.PLAINS) {
                    return CELTIC;
                }
                if (race == AbstractCharacter.Race.SAVANNA) {
                    return SAVANIC;
                }
                if (race == AbstractCharacter.Race.TAIGA) {
                    return NORDIC;
                }
                if (race == AbstractCharacter.Race.DESERT) {
                    return DESERTIC;
                }
                if (race == AbstractCharacter.Race.BADLANDS) {
                    return MESANIC;
                }
                if (race == AbstractCharacter.Race.JUNGLE) {
                    return JUNGESE;
                }
                if (race == AbstractCharacter.Race.ARTIC) {
                    return ESKIMO;
                }
                return CELTIC;
            }
        }

        public static enum DefaultVariations {
            CELTIC_GENES(DefaultGenetics.CELTIC, new EyeColors[]{EyeColors.DARK_GREEN, EyeColors.LIGHT_GREEN, EyeColors.LIGHT_BLUE, EyeColors.PERIWINKLE}, new HairColors[]{HairColors.PLAINS_RED, HairColors.BERRY_BLONDE, HairColors.BROWN}),
            SAVANIC_GENES(DefaultGenetics.SAVANIC, new EyeColors[]{EyeColors.HAZEL, EyeColors.BROWN, EyeColors.AMBER}, new HairColors[]{HairColors.BROWN, HairColors.AUBURN, HairColors.DARK_BROWN}),
            NORDIC_GENES(DefaultGenetics.NORDIC, new EyeColors[]{EyeColors.LIGHT_BLUE, EyeColors.DARK_BLUE, EyeColors.PERIWINKLE}, new HairColors[]{HairColors.BLONDE, HairColors.RICH_BLONDE, HairColors.BERRY_BLONDE, HairColors.SNOWY_WHITE}),
            DESERTIC_GENES(DefaultGenetics.DESERTIC, new EyeColors[]{EyeColors.BLACK, EyeColors.BROWN, EyeColors.VELVET}, new HairColors[]{HairColors.DARK_BROWN, HairColors.BLACK, HairColors.DARK_VELVET}),
            MESANIC_GENES(DefaultGenetics.MESANIC, new EyeColors[]{EyeColors.BROWN, EyeColors.VELVET, EyeColors.AMBER}, new HairColors[]{HairColors.DUSTY_BLONDE, HairColors.DARK_VELVET, HairColors.DARK_BROWN}),
            JUNGESE_GENES(DefaultGenetics.JUNGESE, new EyeColors[]{EyeColors.BLACK, EyeColors.BROWN}, new HairColors[]{HairColors.BLACK, HairColors.DARK_BROWN}),
            ESKIMO_GENES(DefaultGenetics.ESKIMO, new EyeColors[]{EyeColors.LIGHT_BLUE, EyeColors.DARK_BLUE, EyeColors.PERIWINKLE}, new HairColors[]{HairColors.BLACK, HairColors.DARK_BROWN});

            private final DefaultGenetics defaultGenes;
            private final EyeColors[] eyeColors;
            private final HairColors[] hairColors;

            private DefaultVariations(DefaultGenetics genetics, EyeColors[] eyes, HairColors[] hair) {
                this.defaultGenes = genetics;
                this.eyeColors = eyes;
                this.hairColors = hair;
            }

            public int getHairColor() {
                RandomSource randomSource = RandomSource.m_216327_();
                return Arrays.asList(this.hairColors).get(randomSource.m_188503_(this.hairColors.length)).getDecimalColor();
            }

            public int getEyeColor() {
                RandomSource randomSource = RandomSource.m_216327_();
                return Arrays.asList(this.eyeColors).get(randomSource.m_188503_(this.eyeColors.length)).getDecimalColor();
            }

            public static Genetics shuffle(DefaultVariations variations) {
                int skinColors = variations.defaultGenes.skincolor;
                int eyecolor = variations.getEyeColor();
                return new Genetics(variations.defaultGenes.race, false, new int[]{eyecolor, eyecolor}, variations.getHairColor(), skinColors, variations.defaultGenes.hairstyle);
            }

            public static DefaultVariations findRace(AbstractCharacter.Race race) {
                if (race == AbstractCharacter.Race.PLAINS) {
                    return CELTIC_GENES;
                }
                if (race == AbstractCharacter.Race.SAVANNA) {
                    return SAVANIC_GENES;
                }
                if (race == AbstractCharacter.Race.TAIGA) {
                    return NORDIC_GENES;
                }
                if (race == AbstractCharacter.Race.DESERT) {
                    return DESERTIC_GENES;
                }
                if (race == AbstractCharacter.Race.BADLANDS) {
                    return MESANIC_GENES;
                }
                if (race == AbstractCharacter.Race.JUNGLE) {
                    return JUNGESE_GENES;
                }
                if (race == AbstractCharacter.Race.ARTIC) {
                    return ESKIMO_GENES;
                }
                return CELTIC_GENES;
            }

            public DefaultGenetics getDefaultGenes() {
                return this.defaultGenes;
            }

            public EyeColors[] getEyeColors() {
                return this.eyeColors;
            }

            public HairColors[] getHairColors() {
                return this.hairColors;
            }
        }
    }
}

