/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity;

import com.google.common.base.Predicate;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.caitie.roamers.NameGenerator;
import net.caitie.roamers.RoamersMod;
import net.caitie.roamers.entity.AbstractCharacter;
import net.caitie.roamers.entity.PlayerDescendant;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.caitie.roamers.entity.ai.PlayerLikeAI;
import net.caitie.roamers.entity.ai.goals.CallChildGoal;
import net.caitie.roamers.entity.ai.goals.CookFoodGoal;
import net.caitie.roamers.entity.ai.goals.DefendFriendsGoal;
import net.caitie.roamers.entity.ai.goals.FeedChildGoal;
import net.caitie.roamers.entity.ai.goals.GiveToFriendsGoal;
import net.caitie.roamers.entity.ai.goals.MoveToHomeGoal;
import net.caitie.roamers.entity.ai.goals.PickUpItemGoal;
import net.caitie.roamers.entity.ai.goals.PlayerLikeBreedGoal;
import net.caitie.roamers.entity.ai.goals.PlayerLikeMeleeGoal;
import net.caitie.roamers.entity.ai.goals.SleepGoal;
import net.caitie.roamers.init.RoamersModEntities;
import net.caitie.roamers.init.RoamersModItems;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class RoamerEntity
extends PlayerLikeCharacter {
    private final PlayerLikeAI AI;
    public boolean isAdopted = false;
    public static final TagKey FLOWERS = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("minecraft:flowers"));
    private final Predicate<LivingEntity> BABY_HURT_BY = entity -> entity != null && (this.m_21188_() == entity || entity instanceof Player && this.getRelationship((Player)entity) <= -15);
    private final NameGenerator nameGen = new NameGenerator();
    protected HurtByTargetGoal roamerHurtByTargetGoal;
    protected AvoidEntityGoal<LivingEntity> babyAvoidAttackerGoal;

    public RoamerEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<RoamerEntity>)((EntityType)RoamersModEntities.ROAMER.get()), world);
    }

    public RoamerEntity(EntityType<RoamerEntity> type, Level world) {
        super((EntityType<? extends PlayerLikeCharacter>)type, world);
        this.AI = new PlayerLikeAI(this){
            final RoamerEntity roamer;
            {
                this.roamer = RoamerEntity.this;
            }

            @Override
            public void initGoals() {
                super.initGoals();
                this.roamer.roamerHurtByTargetGoal = new HurtByTargetGoal((PathfinderMob)this.roamer, new Class[0]){

                    public void m_8056_() {
                        if (RoamerEntity.this.m_6162_()) {
                            this.m_26047_();
                        }
                        if (!RoamerEntity.this.m_6162_() || RoamerEntity.this.hasFightingTraits() || RoamerEntity.this.isHotHead() && RoamerEntity.this.isAngry()) {
                            super.m_8056_();
                        }
                    }

                    protected void m_5766_(Mob mob, LivingEntity ent) {
                        if (!mob.m_6162_()) {
                            if (ent instanceof Player) {
                                if (((PlayerLikeCharacter)mob).childrenUUIDs.contains(RoamerEntity.this.m_20148_())) {
                                    ((PlayerLikeCharacter)mob).removeRelationPoints((Player)ent, 20);
                                    if (!((PlayerLikeCharacter)mob).isDepressed()) {
                                        ((PlayerLikeCharacter)mob).setMood(AbstractCharacter.Mood.FURIOUS, 1200);
                                    }
                                } else {
                                    ((PlayerLikeCharacter)mob).removeRelationPoints((Player)ent, 10);
                                    if (!((PlayerLikeCharacter)mob).isDepressed()) {
                                        ((PlayerLikeCharacter)mob).setMood(AbstractCharacter.Mood.ANGRY, 800);
                                    }
                                }
                            }
                            super.m_5766_(mob, ent);
                        }
                    }
                };
                this.roamer.babyAvoidAttackerGoal = new AvoidEntityGoal<LivingEntity>((PathfinderMob)this.roamer, LivingEntity.class, 8.0f, 0.9, 0.9){
                    private int cryTicks;
                    {
                        this.cryTicks = 0;
                    }

                    public boolean m_8036_() {
                        if (RoamerEntity.this.isHotHead()) {
                            return RoamerEntity.this.m_21223_() > 18.0f && RoamerEntity.this.m_6162_() && RoamerEntity.this.BABY_HURT_BY.test((Object)this.f_25016_);
                        }
                        if (RoamerEntity.this.hasFightingTraits()) {
                            return RoamerEntity.this.m_21223_() > 14.0f && RoamerEntity.this.m_6162_() && RoamerEntity.this.BABY_HURT_BY.test((Object)this.f_25016_);
                        }
                        return super.m_8036_() && RoamerEntity.this.m_6162_() && RoamerEntity.this.BABY_HURT_BY.test((Object)this.f_25016_);
                    }

                    public void m_8056_() {
                        super.m_8056_();
                        RoamerEntity.this.sprint(true);
                    }

                    public void m_8037_() {
                        super.m_8037_();
                        if (!RoamerEntity.this.hasFightingTraits() && ++this.cryTicks >= 5) {
                            RoamerEntity.this.f_19853_.m_7605_((Entity)RoamerEntity.this, (byte)42);
                            this.cryTicks = 0;
                        }
                    }

                    public void m_8041_() {
                        super.m_8041_();
                        this.cryTicks = 0;
                        RoamerEntity.this.sprint(false);
                    }
                };
            }

            @Override
            public void postInit() {
                this.currentBrain = this.roamer.m_6162_() ? this.BABY_BRAIN : this.BRAIN;
                this.coreGoals = new ObjectArrayList(List.of(new Goal[]{new PickUpItemGoal(this.roamer, 0.9), new PlayerLikeMeleeGoal(this.roamer, 1.0, true), RoamerEntity.this.roamerHurtByTargetGoal, RoamerEntity.this.babyAvoidAttackerGoal, new DefendFriendsGoal(this.roamer), new SleepGoal(this.roamer), new FloatGoal((Mob)this.roamer), this.playGoal, new GiveToFriendsGoal(this.roamer), this.doorGoal, new CookFoodGoal(this.roamer, 0.9, 10), new PlayerLikeBreedGoal(this.roamer, 0.9)}));
                this.overrideBrainState(this.currentBrain, PlayerLikeAI.State.CORE, (List<Goal>)this.coreGoals);
                this.addGoalToBrain(this.currentBrain, (Goal)new MoveToHomeGoal(this.roamer, 0.9), PlayerLikeAI.State.IDLE);
                if (!this.roamer.m_6162_()) {
                    this.addGoalToBrain(this.currentBrain, new FeedChildGoal(this.roamer), PlayerLikeAI.State.CORE);
                    this.addGoalToBrain(this.currentBrain, new CallChildGoal(this.roamer), PlayerLikeAI.State.CORE);
                }
                super.postInit();
            }
        };
        this.f_21364_ = 0;
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    protected void adoptNearbyChild() {
        List list;
        if (!this.m_6162_() && !(list = this.f_19853_.m_6443_(RoamerEntity.class, this.m_20191_().m_82377_(20.0, 20.0, 20.0), entity -> entity.m_6162_() && !entity.isAdopted)).isEmpty()) {
            this.childrenUUIDs.add(((RoamerEntity)list.get(0)).m_20148_());
            ((RoamerEntity)list.get((int)0)).isAdopted = true;
            ((RoamerEntity)list.get((int)0)).f_19853_.m_7605_((Entity)list.get(0), (byte)14);
            this.f_19853_.m_7605_((Entity)this, (byte)14);
            if (this.isSad()) {
                this.setDefaultMood();
            } else {
                this.setMood(AbstractCharacter.Mood.HAPPY, 800);
            }
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        this.adoptNearbyChild();
    }

    @Override
    public PlayerLikeAI getAI() {
        return this.AI;
    }

    @Override
    public boolean m_7243_(ItemStack stack) {
        if (this.m_6162_()) {
            return this.m_35311_().m_19183_(stack) && (stack.m_204117_(EDIBLES) || this.getRace() == AbstractCharacter.Race.ARTIC && stack.m_150930_(Items.f_42452_));
        }
        return this.m_35311_().m_19183_(stack) && !stack.m_204117_(UNDESIRED);
    }

    @Override
    public AgeableMob m_142606_(ServerLevel level, AgeableMob ageable) {
        String name;
        RoamerEntity father;
        RoamerEntity mother;
        if (this.isMale()) {
            mother = (RoamerEntity)ageable;
            father = this;
        } else {
            mother = this;
            father = (RoamerEntity)ageable;
        }
        CompoundTag tag = new CompoundTag();
        CompoundTag momGenes = new CompoundTag();
        momGenes.m_128365_("Genes", (Tag)mother.getGenes().save());
        CompoundTag dadGenes = new CompoundTag();
        dadGenes.m_128365_("Genes", (Tag)father.getGenes().save());
        tag.m_128365_("MomGenes", (Tag)momGenes);
        tag.m_128365_("DadGenes", (Tag)dadGenes);
        RoamerEntity baby = (RoamerEntity)((EntityType)RoamersModEntities.ROAMER.get()).m_20655_(level, tag, null, null, mother.m_20183_(), MobSpawnType.BREEDING, false, false);
        if (RoamersMod.CONFIG.allowNames && (name = this.nameGen.createCharacterName(baby)) != null) {
            baby.m_6593_((Component)Component.m_237113_((String)name));
        }
        if (baby.getRace() == AbstractCharacter.Race.ARTIC) {
            baby.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)RoamersModItems.WOOL_HELMET.get()));
            baby.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)RoamersModItems.WOOL_CHESTPLATE.get()));
            baby.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)RoamersModItems.WOOL_LEGGINGS.get()));
            baby.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)RoamersModItems.WOOL_BOOTS.get()));
        }
        return baby;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor slevel, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        String name;
        this.createPerson(this.m_20183_());
        int n = this.buildType = RoamersMod.CONFIG.doLegacyHouses ? 0 : this.f_19796_.m_188503_(2) + 1;
        if (RoamersMod.CONFIG.allowNames && (name = this.nameGen.createCharacterName(this)) != null) {
            this.m_6593_((Component)Component.m_237113_((String)name));
        }
        if (this.getRace() == AbstractCharacter.Race.ARTIC) {
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)RoamersModItems.WOOL_HELMET.get()));
            this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)RoamersModItems.WOOL_CHESTPLATE.get()));
            this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)RoamersModItems.WOOL_LEGGINGS.get()));
            this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)RoamersModItems.WOOL_BOOTS.get()));
        }
        if (type != MobSpawnType.BREEDING) {
            this.setHomePos(this.m_20183_());
            if (this.m_35311_().m_7983_()) {
                this.m_35311_().m_19173_(Items.f_42781_.m_7968_());
                this.m_35311_().m_19173_(Items.f_41960_.m_7968_());
                this.m_35311_().m_19173_(Items.f_42427_.m_7968_());
                this.m_35311_().m_19173_(Items.f_42428_.m_7968_());
                this.m_35311_().m_19173_(Items.f_42426_.m_7968_());
                this.m_35311_().m_19173_(Items.f_42425_.m_7968_());
                this.m_35311_().m_19173_(Items.f_42429_.m_7968_());
                this.m_35311_().m_19173_(Items.f_42523_.m_7968_());
                this.m_35311_().m_19173_(Items.f_42503_.m_7968_());
                this.m_35311_().m_19173_(Items.f_42009_.m_7968_());
                this.m_35311_().m_19173_(new ItemStack((ItemLike)Items.f_42000_, 4));
            }
            if (type != MobSpawnType.SPAWN_EGG && slevel.m_213780_().m_188503_(6) == 0) {
                String name2;
                RoamerEntity child = (RoamerEntity)((EntityType)RoamersModEntities.ROAMER.get()).m_20615_((Level)slevel.m_6018_());
                child.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                child.createPerson(this.m_20183_());
                child.setGenes(PlayerLikeCharacter.Genetics.DefaultVariations.shuffle(PlayerLikeCharacter.Genetics.DefaultVariations.findRace(this.getRace())));
                child.m_146762_(RoamersMod.CONFIG.babyAgeTicks < 0 ? RoamersMod.CONFIG.babyAgeTicks : -72000);
                int n2 = child.buildType = RoamersMod.CONFIG.doLegacyHouses ? 0 : this.f_19796_.m_188503_(2) + 1;
                if (RoamersMod.CONFIG.allowNames && (name2 = this.nameGen.createCharacterName(child)) != null) {
                    child.m_6593_((Component)Component.m_237113_((String)name2));
                }
                if (child.getRace() == AbstractCharacter.Race.ARTIC) {
                    child.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)RoamersModItems.WOOL_HELMET.get()));
                    child.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)RoamersModItems.WOOL_CHESTPLATE.get()));
                    child.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)RoamersModItems.WOOL_LEGGINGS.get()));
                    child.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)RoamersModItems.WOOL_BOOTS.get()));
                }
                slevel.m_6018_().m_47205_((Entity)child);
            }
        }
        return super.m_6518_(slevel, difficulty, type, data, tag);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_146764_() == 0 && !this.m_5803_() && this.getRelationship(player) >= RoamersMod.CONFIG.maxRelationStatus && this.isInLove() && RoamersMod.CONFIG.allowDescendants && player.m_21120_(hand).m_204117_(FLOWERS)) {
            player.m_6674_(hand);
            player.m_21120_(hand).m_41774_(1);
            this.f_19853_.m_7605_((Entity)this, (byte)18);
            this.havePlayerOffspring(player);
            this.setMood(AbstractCharacter.Mood.HAPPY, 800);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return this.giveFood(player, hand);
    }

    @Override
    public boolean canBreedWith(AbstractCharacter partner) {
        return super.canBreedWith(partner) && partner.m_6095_() == RoamersModEntities.ROAMER.get();
    }

    public void havePlayerOffspring(Player player) {
        CompoundTag tag = new CompoundTag();
        CompoundTag parentGenes = new CompoundTag();
        parentGenes.m_128365_("Genes", (Tag)this.getGenes().save());
        tag.m_128365_("ParentGenes", (Tag)parentGenes);
        tag.m_128359_("Race", this.getRace().name());
        PlayerDescendant baby = (PlayerDescendant)((EntityType)RoamersModEntities.PLAYER_DESCENDANT.get()).m_20655_((ServerLevel)this.f_19853_, tag, null, null, this.m_20183_(), MobSpawnType.BREEDING, false, false);
        baby.m_146762_(RoamersMod.CONFIG.babyAgeTicks < 0 ? RoamersMod.CONFIG.babyAgeTicks : -72000);
        if (this.isMale()) {
            baby.m_20219_(player.m_20182_());
        } else {
            baby.m_20219_(this.m_20182_());
        }
        baby.chooseName(player);
        baby.setParentUUID(player.m_20148_());
        baby.setRelationship(player, RoamersMod.CONFIG.descendantRelationOnBirth);
        baby.currentChore = PlayerDescendant.AssignedChore.FOLLOW;
        ((ServerLevel)this.f_19853_).m_47205_((Entity)baby);
        this.m_146762_(RoamersMod.CONFIG.breedCooldownTicks >= 0 ? RoamersMod.CONFIG.breedCooldownTicks : 45000);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 20.0);
        return builder;
    }
}

