/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity.ai;

import java.util.ArrayList;
import java.util.List;
import net.caitie.roamers.RoamersMod;
import net.caitie.roamers.entity.AbstractCharacter;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.caitie.roamers.events.PlaceBlockEvent;
import net.caitie.roamers.events.RemoveBlockEvent;
import net.caitie.roamers.network.GlobalVariables;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class TaskUtils {
    public static void mineBlock(PlayerLikeCharacter plk, BlockPos bpos, BlockState bstate, boolean drop) {
        if (!plk.f_19853_.f_46443_) {
            plk.m_6674_(InteractionHand.MAIN_HAND);
            plk.f_19853_.m_46961_(bpos, false);
            RemoveBlockEvent.execute((LevelAccessor)plk.f_19853_, bpos);
            if (drop) {
                if (bstate.m_204336_(BlockTags.f_144274_) && !RoamersMod.CONFIG.dropDirt) {
                    return;
                }
                if (bstate.m_60713_(Blocks.f_50125_)) {
                    Block.m_49840_((Level)plk.f_19853_, (BlockPos)bpos, (ItemStack)new ItemStack((ItemLike)Items.f_42452_, ((Integer)bstate.m_61143_((Property)BlockStateProperties.f_61417_)).intValue()));
                    return;
                }
                Block.m_49950_((BlockState)bstate, (Level)plk.f_19853_, (BlockPos)bpos);
            }
        }
    }

    public static List<BlockPos> getBlocksInWayOfPath(PlayerLikeCharacter plk, Path path, int rangeX, int rangeY, int rangeZ, boolean leavesAndLogsOnly) {
        ArrayList<BlockPos> retval = new ArrayList<BlockPos>();
        if (path != null) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (int i = 0; i < path.m_77398_() - 1; ++i) {
                nodes.add(path.m_77375_(i));
            }
            for (Node node : nodes) {
                BlockPos nodePos = node.m_77288_();
                for (int x = -rangeX + nodePos.m_123341_(); x < rangeX + nodePos.m_123341_(); ++x) {
                    for (int y = nodePos.m_123342_(); y < rangeY + nodePos.m_123342_(); ++y) {
                        for (int z = -rangeZ + nodePos.m_123343_(); z < rangeZ + nodePos.m_123343_(); ++z) {
                            BlockPos bpos = new BlockPos(x, y, z);
                            BlockState bstate = plk.f_19853_.m_8055_(bpos);
                            if (leavesAndLogsOnly && !bstate.m_204336_(BlockTags.f_13106_) && !bstate.m_204336_(BlockTags.f_13035_) || !TaskUtils.isValidBlockToMine(plk, bpos, bstate) || bstate.m_60734_() instanceof DoorBlock) continue;
                            retval.add(bpos);
                        }
                    }
                }
            }
            if (retval.isEmpty()) {
                return null;
            }
            return retval;
        }
        return null;
    }

    public static boolean canReachWithNoCollision(PlayerLikeCharacter ent, BlockPos target) {
        Path path = ent.m_21573_().m_7864_(target, 0);
        if (path != null && path.m_77403_()) {
            return true;
        }
        List<BlockPos> blocks = TaskUtils.getBlocksInWayOfPath(ent, path, 0, ent.m_6162_() ? 1 : 2, 0, false);
        return blocks == null;
    }

    public static List<BlockPos> createSpace(AbstractCharacter chr, int size) {
        ArrayList<BlockPos> space = new ArrayList<BlockPos>();
        for (int x = chr.m_20183_().m_123341_() - size; x < chr.m_20183_().m_123341_() + size; ++x) {
            for (int y = chr.m_20183_().m_123342_(); y < chr.m_20183_().m_123342_() + size; ++y) {
                for (int z = chr.m_20183_().m_123343_() - size; z < chr.m_20183_().m_123343_() + size; ++z) {
                    space.add(new BlockPos(x, y, z));
                }
            }
        }
        return space;
    }

    public static List<BlockPos> createSpace(BlockPos blockPos, int size, int ySize) {
        ArrayList<BlockPos> space = new ArrayList<BlockPos>();
        for (int x = blockPos.m_123341_() - size; x < blockPos.m_123341_() + size; ++x) {
            for (int y = blockPos.m_123342_(); y < blockPos.m_123342_() + ySize; ++y) {
                for (int z = blockPos.m_123343_() - size; z < blockPos.m_123343_() + size; ++z) {
                    space.add(new BlockPos(x, y, z));
                }
            }
        }
        return space;
    }

    public static boolean isInConfinedSpace(AbstractCharacter chr, List<BlockPos> space) {
        for (BlockPos bpos : space) {
            if (TaskUtils.canReachWithNoCollision((PlayerLikeCharacter)chr, bpos)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWantedItemNearby(PlayerLikeCharacter character) {
        return !character.f_19853_.m_6443_(ItemEntity.class, character.m_20191_().m_82377_(6.25, 3.25, 6.25), item -> item != null && (item.m_32057_() == null || !item.m_32057_().equals(character.m_20148_())) && character.m_142582_((Entity)item) && character.m_7243_(item.m_32055_()) && character.m_35311_().m_19183_(item.m_32055_())).isEmpty();
    }

    public static boolean isOutside(AbstractCharacter chr) {
        List<BlockPos> room = TaskUtils.createSpace(chr, 2);
        for (BlockPos blockPos : room) {
            if (!chr.f_19853_.m_46861_(blockPos)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInRange(PlayerLikeCharacter plk, BlockPos wanted) {
        return wanted.m_203195_((Position)plk.m_20182_(), 6.0);
    }

    public static boolean shouldBreakBlocks(PlayerLikeCharacter plk) {
        return !((ServerLevel)plk.f_19853_).m_8802_(plk.m_20183_());
    }

    public static Path createPathThroughBlocks(PlayerLikeCharacter plk, BlockPos wanted) {
        if (wanted != null) {
            float oldBlockPath = plk.m_21439_(BlockPathTypes.BLOCKED);
            plk.m_21441_(BlockPathTypes.BLOCKED, 0.0f);
            Path path = plk.m_21573_().m_7864_(wanted, 0);
            plk.m_21441_(BlockPathTypes.BLOCKED, oldBlockPath);
            return path;
        }
        return null;
    }

    public static BlockPos getTorchPlacement(PlayerLikeCharacter plk, int xZRange, int yRange) {
        BlockPos startPos = plk.m_20183_();
        for (int x = -xZRange + startPos.m_123341_(); x < xZRange + startPos.m_123341_(); ++x) {
            for (int y = -yRange + startPos.m_123342_(); y < yRange + startPos.m_123342_(); ++y) {
                for (int z = -xZRange + startPos.m_123343_(); z < xZRange + startPos.m_123343_(); ++z) {
                    BlockPos bpos = new BlockPos(x, y, z);
                    if (!TaskUtils.canReachWithNoCollision(plk, bpos) || plk.f_19853_.m_45524_(bpos.m_7494_(), 0) >= 6 || !TaskUtils.isValidBlockToPlaceOn(plk, bpos, Blocks.f_50081_.m_49966_())) continue;
                    return bpos.m_7494_();
                }
            }
        }
        return null;
    }

    public static boolean isValidBlockToPlaceOn(PlayerLikeCharacter plk, BlockPos bpos, BlockState bstate) {
        if (bpos != null) {
            BlockState blockState = plk.f_19853_.m_8055_(bpos);
            BlockState aboveState = plk.f_19853_.m_8055_(bpos.m_7494_());
            if (plk.canBuild() && plk.getCurrentActivity() == PlayerLikeCharacter.Activity.BUILDING && plk.getBuildingTask() != null && bstate.m_60734_() != plk.getWantedBuildingBlock()) {
                if (plk.getBuildingTask().startingBlockPos == bpos) {
                    return false;
                }
                if (plk.getBuildingTask().builtPositions.contains((Object)bpos)) {
                    return false;
                }
            }
            return blockState.m_60767_().m_76333_() && !blockState.m_60767_().m_76332_() && !aboveState.m_60767_().m_76332_() && TaskUtils.isReplaceableOrPlant(aboveState) && !GlobalVariables.MapVariables.get((LevelAccessor)plk.f_19853_).placed_blocks.contains(GlobalVariables.MapVariables.getLongKey(bpos.m_7494_()));
        }
        return false;
    }

    public static boolean isValidBlockToMine(PlayerLikeCharacter plk, BlockPos bpos, BlockState bstate) {
        return !bstate.m_60767_().m_76336_() && !bstate.m_60713_(Blocks.f_50081_) && !bstate.m_60767_().m_76332_() && !GlobalVariables.MapVariables.get((LevelAccessor)plk.f_19853_).placed_blocks.contains(GlobalVariables.MapVariables.getLongKey(bpos));
    }

    public static void mineBlockWithTool(PlayerLikeCharacter plk, ItemStack tool, BlockPos bpos, BlockState bstate, boolean drop) {
        plk.m_21008_(InteractionHand.MAIN_HAND, tool);
        TaskUtils.mineBlock(plk, bpos, bstate, drop);
    }

    public static boolean placeBlock(PlayerLikeCharacter plk, BlockPos bpos, BlockState bstate) {
        if (TaskUtils.placeBreakableBlock(plk, bpos, bstate)) {
            PlaceBlockEvent.execute(bpos, plk.f_19853_);
            return true;
        }
        return false;
    }

    public static boolean placeBreakableBlock(PlayerLikeCharacter plk, BlockPos bpos, BlockState bstate) {
        if (TaskUtils.canReachWithNoCollision(plk, bpos)) {
            plk.m_6674_(InteractionHand.MAIN_HAND);
            plk.f_19853_.m_46597_(bpos, bstate);
            bstate.m_60734_().m_6402_(plk.f_19853_, bpos, bstate, (LivingEntity)plk, plk.getItemsInInventory(bstate.m_60734_().m_5456_()));
            plk.f_19853_.m_5594_(null, bpos, bstate.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            plk.m_35311_().m_19170_(bstate.m_60734_().m_5456_(), 1);
            return true;
        }
        return false;
    }

    public static void emptyBucket(PlayerLikeCharacter plk, ItemStack bucketItem, BlockPos bpos) {
        if (bucketItem.m_41720_() instanceof BucketItem) {
            BucketItem bucket = (BucketItem)bucketItem.m_41720_();
            plk.m_6674_(InteractionHand.MAIN_HAND);
            Fluid fluid = bucket.getFluid();
            plk.m_21008_(InteractionHand.MAIN_HAND, bucketItem);
            plk.m_21563_().m_24946_((double)bpos.m_123341_(), (double)bpos.m_123342_(), (double)bpos.m_123343_());
            TaskUtils.placeBlock(plk, bpos, fluid.m_76145_().m_76188_());
            plk.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42446_));
        }
    }

    public static void fillBucket(PlayerLikeCharacter plk, Fluid fluid, ItemStack bucket, BlockPos bpos) {
        if (bucket.m_150930_(Items.f_42446_) && plk.f_19853_.m_142433_(bpos, f -> f.m_192917_(fluid) && f.m_76170_())) {
            plk.m_6674_(InteractionHand.MAIN_HAND);
            ItemStack filledBucket = new ItemStack((ItemLike)fluid.m_6859_());
            plk.m_21008_(InteractionHand.MAIN_HAND, bucket);
            plk.m_21563_().m_24946_((double)bpos.m_123341_(), (double)bpos.m_123342_(), (double)bpos.m_123343_());
            plk.f_19853_.m_46597_(bpos, Blocks.f_50016_.m_49966_());
            plk.f_19853_.m_5594_(null, bpos, (SoundEvent)fluid.m_142520_().get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            plk.m_21008_(InteractionHand.MAIN_HAND, filledBucket);
        }
    }

    public static boolean useBonemeal(PlayerLikeCharacter plk, ItemStack bonemeal, BlockPos bpos) {
        if (bonemeal.m_41720_() instanceof BoneMealItem) {
            BonemealableBlock bonemealableblock;
            plk.m_6674_(InteractionHand.MAIN_HAND);
            BlockState bstate = plk.f_19853_.m_8055_(bpos);
            plk.m_21008_(InteractionHand.MAIN_HAND, bonemeal);
            if (bstate.m_60734_() instanceof BonemealableBlock && (bonemealableblock = (BonemealableBlock)bstate.m_60734_()).m_7370_((BlockGetter)plk.f_19853_, bpos, bstate, plk.f_19853_.f_46443_)) {
                if (plk.f_19853_ instanceof ServerLevel) {
                    if (bonemealableblock.m_214167_(plk.f_19853_, plk.f_19853_.m_213780_(), bpos, bstate)) {
                        bonemealableblock.m_214148_((ServerLevel)plk.f_19853_, plk.f_19853_.m_213780_(), bpos, bstate);
                    }
                    bonemeal.m_41774_(1);
                }
                return true;
            }
        }
        return false;
    }

    public static Class<? extends LivingEntity> findEntityThatDropsItem(PlayerLikeCharacter plk, Item drop) {
        LootContext.Builder lootContext = new LootContext.Builder((ServerLevel)plk.f_19853_);
        List list = plk.f_19853_.m_6443_(LivingEntity.class, plk.m_20191_().m_82377_(20.0, 12.0, 20.0), entity -> {
            lootContext.m_78972_(LootContextParams.f_81458_, (Object)plk);
            lootContext.m_78972_(LootContextParams.f_81455_, entity);
            LootTable lootTable = ((ServerLevel)plk.f_19853_).m_7654_().m_129898_().m_79217_(entity.m_5743_());
            for (ItemStack items : lootTable.m_230922_(lootContext.m_78975_(LootContextParamSet.m_165477_().m_81405_()))) {
                if (!items.m_150930_(drop)) continue;
                return true;
            }
            return false;
        });
        if (!list.isEmpty()) {
            return ((LivingEntity)list.get(0)).getClass();
        }
        return null;
    }

    public static ItemStack findTool(PlayerLikeCharacter plk, BlockState bstate) {
        if (bstate.m_204336_(BlockTags.f_144282_)) {
            return plk.getTaggedItemsInInventory((TagKey<Item>)PlayerLikeCharacter.PICKAXES);
        }
        if (bstate.m_204336_(BlockTags.f_144280_)) {
            return plk.getTaggedItemsInInventory((TagKey<Item>)PlayerLikeCharacter.AXES);
        }
        if (bstate.m_204336_(BlockTags.f_144283_)) {
            return plk.getTaggedItemsInInventory((TagKey<Item>)PlayerLikeCharacter.SHOVELS);
        }
        if (bstate.m_204336_(BlockTags.f_144281_)) {
            return plk.getTaggedItemsInInventory((TagKey<Item>)PlayerLikeCharacter.HOES);
        }
        return ItemStack.f_41583_;
    }

    public static void lookAndMoveTo(PathfinderMob chr, BlockPos wanted, double speed) {
        Path path = chr.m_21573_().m_7864_(wanted, 0);
        if (path != null) {
            chr.m_21573_().m_26536_(path, speed);
            chr.m_21563_().m_24946_((double)wanted.m_123341_(), (double)wanted.m_123342_(), (double)wanted.m_123343_());
        }
    }

    public static void lookAndMoveTo(PathfinderMob chr, Path path, double speed) {
        if (path != null) {
            chr.m_21573_().m_26536_(path, speed);
            chr.m_21563_().m_24946_((double)path.m_77406_().m_123341_(), (double)path.m_77406_().m_123342_(), (double)path.m_77406_().m_123343_());
        }
    }

    public static void lookAndMoveTo(PathfinderMob chr, Entity ent, double speed) {
        Path path = chr.m_21573_().m_6570_(ent, 0);
        if (path != null) {
            chr.m_21573_().m_26536_(path, speed);
            chr.m_21563_().m_148051_(ent);
        }
    }

    public static void lookAndMoveTo(PathfinderMob chr, Vec3 vec3, double speed) {
        Path path = chr.m_21573_().m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
        if (path != null) {
            chr.m_21573_().m_26536_(path, speed);
            chr.m_21563_().m_24964_(vec3);
        }
    }

    public static void moveTo(PathfinderMob chr, BlockPos wanted, double speed) {
        Path path = chr.m_21573_().m_7864_(wanted, 0);
        if (path != null) {
            chr.m_21573_().m_26536_(path, speed);
        }
    }

    public static void moveTo(PathfinderMob chr, Path path, double speed) {
        if (path != null) {
            chr.m_21573_().m_26536_(path, speed);
        }
    }

    public static void moveTo(PathfinderMob chr, Entity ent, double speed) {
        Path path = chr.m_21573_().m_6570_(ent, 0);
        if (path != null) {
            chr.m_21573_().m_26536_(path, speed);
        }
    }

    public static void moveTo(PathfinderMob chr, Vec3 vec3, double speed) {
        Path path = chr.m_21573_().m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
        if (path != null) {
            chr.m_21573_().m_26536_(path, speed);
        }
    }

    public static void lookAt(PathfinderMob chr, BlockPos pos) {
        if (pos != null) {
            chr.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)pos));
        }
    }

    public static void lookAt(PathfinderMob chr, Entity ent) {
        if (ent != null) {
            chr.m_21563_().m_148051_(ent);
        }
    }

    public static boolean isReplaceableOrPlant(BlockState bstate) {
        return bstate.m_60767_().m_76336_() || bstate.m_60767_() == Material.f_76300_;
    }
}

