/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity.ai.goals;

import java.util.EnumSet;
import net.caitie.roamers.RoamersMod;
import net.caitie.roamers.entity.PlayerDescendant;
import net.caitie.roamers.entity.ai.goals.ControlledTickGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class FollowPlayerGoal
extends ControlledTickGoal {
    protected final PlayerDescendant plrDes;
    protected Player parent;
    protected final float startDistance;
    protected final float stopDistance;
    private int timeToRecalcPath;
    private float oldWaterCost;
    public boolean isInUse;

    public FollowPlayerGoal(PlayerDescendant plrDes, float startDistance, float stopDistance) {
        super(plrDes);
        this.plrDes = plrDes;
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.plrDes.currentChore != PlayerDescendant.AssignedChore.FOLLOW) {
            return false;
        }
        if (this.plrDes.hatesParent()) {
            return false;
        }
        Player parent = (Player)this.plrDes.m_21826_();
        if (parent == null) {
            return false;
        }
        if (parent.m_5833_()) {
            return false;
        }
        if (this.plrDes.m_20280_((Entity)parent) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.parent = parent;
        return true;
    }

    public boolean m_8045_() {
        return this.plrDes.currentChore == PlayerDescendant.AssignedChore.FOLLOW && !this.plrDes.hatesParent() && this.parent != null && !this.parent.m_5833_() && !(this.plrDes.m_20280_((Entity)this.parent) <= (double)(this.stopDistance * this.stopDistance));
    }

    @Override
    public void m_8056_() {
        this.isInUse = true;
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.plrDes.m_21439_(BlockPathTypes.WATER);
        this.plrDes.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    @Override
    public void m_8041_() {
        this.isInUse = false;
        this.parent = null;
        this.plrDes.m_21573_().m_26573_();
        this.plrDes.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    @Override
    public void doTick() {
        this.plrDes.m_21563_().m_148051_((Entity)this.parent);
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (!this.plrDes.m_20159_()) {
                if (RoamersMod.CONFIG.doDescendantTeleporting && this.plrDes.m_20280_((Entity)this.parent) >= 144.0) {
                    this.teleport();
                    return;
                }
                this.plrDes.m_21573_().m_5624_((Entity)this.parent, this.plrDes.isDepressed() ? 0.5 : (this.plrDes.m_6162_() ? 1.0 : 0.9));
            }
        }
    }

    @Override
    public void doUpdateTick() {
    }

    public void teleport() {
        BlockPos blockpos = this.parent.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleport(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return;
        }
    }

    protected boolean maybeTeleport(int x, int y, int z) {
        if (Math.abs((double)x - this.parent.m_20185_()) < 2.0 && Math.abs((double)z - this.parent.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleport(new BlockPos(x, y, z))) {
            return false;
        }
        this.plrDes.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.plrDes.m_146908_(), this.plrDes.m_146909_());
        this.plrDes.m_21573_().m_26573_();
        return true;
    }

    private boolean canTeleport(BlockPos blockPos) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.plrDes.f_19853_, (BlockPos.MutableBlockPos)blockPos.m_122032_());
        if (blockpathtypes == BlockPathTypes.OPEN && this.plrDes.isCreative()) {
            BlockPos blockpos = blockPos.m_121996_((Vec3i)this.plrDes.m_20183_());
            return this.plrDes.f_19853_.m_45756_((Entity)this.plrDes, this.plrDes.m_20191_().m_82338_(blockpos));
        }
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.plrDes.f_19853_.m_8055_(blockPos.m_7495_());
        if (blockstate.m_60734_() instanceof LeavesBlock && !this.plrDes.isCreative()) {
            return false;
        }
        BlockPos blockpos = blockPos.m_121996_((Vec3i)this.plrDes.m_20183_());
        return this.plrDes.f_19853_.m_45756_((Entity)this.plrDes, this.plrDes.m_20191_().m_82338_(blockpos));
    }

    private int randomIntInclusive(int i, int j) {
        return this.plrDes.m_217043_().m_188503_(j - i + 1) + i;
    }
}

