/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity.ai.goals;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.caitie.roamers.RoamersMod;
import net.caitie.roamers.entity.AbstractCharacter;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.caitie.roamers.entity.RoamerEntity;
import net.caitie.roamers.entity.ai.TaskUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.AABB;

public class HuntingGoal
extends TargetGoal {
    protected AbstractCharacter chr;
    protected TagKey huntables;
    protected Item wantedDrop;
    protected LivingEntity target;
    private Predicate<LivingEntity> animals;
    protected TargetingConditions targetConditions;
    public boolean isInUse;

    public HuntingGoal(AbstractCharacter chr, TagKey huntables, boolean mustSee) {
        super((Mob)chr, mustSee, false);
        this.chr = chr;
        this.huntables = huntables;
        this.targetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(this.animals);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public HuntingGoal(AbstractCharacter chr, boolean mustSee, Item wantedDrop) {
        super((Mob)chr, mustSee, false);
        this.chr = chr;
        this.wantedDrop = wantedDrop;
        this.targetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(this.animals);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_8036_() {
        if ((this.chr.getHomePos() == null || this.chr.getHomePos() == BlockPos.f_121853_) && RoamersMod.CONFIG.allowBuilding && this.chr instanceof RoamerEntity && !((RoamerEntity)this.chr).isHungry()) {
            return false;
        }
        if (!this.chr.shouldHunt()) return false;
        if (this.wantedDrop != null) {
            Class<? extends LivingEntity> entClass = TaskUtils.findEntityThatDropsItem((PlayerLikeCharacter)this.chr, this.wantedDrop);
            if (entClass == null) return false;
            this.animals = animal -> animal.getClass().equals(entClass) && !animal.m_6162_();
        } else {
            this.animals = animal -> animal.m_6095_().m_204039_(this.huntables) && !animal.m_6162_();
        }
        this.findTarget();
        if (this.target == null) return false;
        return true;
    }

    public void m_8056_() {
        this.isInUse = true;
        this.chr.m_6710_(this.target);
        super.m_8056_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.isInUse = false;
    }

    public boolean m_6767_() {
        return this.chr.m_21188_() == null;
    }

    protected AABB getTargetSearchArea(double range) {
        return this.chr.m_20191_().m_82377_(range, 4.0, range);
    }

    protected void findTarget() {
        this.target = this.chr.f_19853_.m_45982_(this.chr.f_19853_.m_6443_(LivingEntity.class, this.getTargetSearchArea(this.m_7623_()), this.animals), this.targetConditions, (LivingEntity)this.chr, this.chr.m_20185_(), this.chr.m_20188_(), this.chr.m_20189_());
    }
}

