/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity.ai.goals;

import java.util.EnumSet;
import net.caitie.roamers.RoamersMod;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.caitie.roamers.entity.ai.TaskUtils;
import net.caitie.roamers.entity.ai.goals.ControlledTickGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;

public class PlaceTorchGoal
extends ControlledTickGoal {
    protected final PlayerLikeCharacter plk;
    protected BlockPos torchPos;
    protected int tryTicks;
    public boolean isInUse;

    public PlaceTorchGoal(PlayerLikeCharacter plk) {
        super(plk);
        this.plk = plk;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (RoamersMod.CONFIG.allowTorchPlacing && !this.plk.hasItemsInInventory(Items.f_42000_)) {
            if (this.plk.wantsToCraftItem == null) {
                this.plk.wantsToCraftItem = Items.f_42000_;
            }
            return false;
        }
        return RoamersMod.CONFIG.allowTorchPlacing && this.tryTicks > -600 && this.tryTicks < 600 && this.plk.f_19853_.m_45524_(this.plk.m_20183_(), 0) < 6;
    }

    @Override
    public void m_8056_() {
        this.isInUse = true;
        this.torchPos = null;
        this.tryTicks = 0;
        this.setTorchPos();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void doUpdateTick() {
        if (this.torchPos != null) {
            if (this.plk.f_19853_.m_45524_(this.torchPos, 0) < 6 && TaskUtils.isValidBlockToPlaceOn(this.plk, this.torchPos.m_7495_(), Blocks.f_50081_.m_49966_())) {
                if (TaskUtils.isInRange(this.plk, this.torchPos) && !this.plk.f_20911_) {
                    TaskUtils.placeBreakableBlock(this.plk, this.torchPos, Blocks.f_50081_.m_49966_());
                    this.torchPos = null;
                } else {
                    TaskUtils.lookAndMoveTo((PathfinderMob)this.plk, this.torchPos, 0.9);
                    ++this.tryTicks;
                    return;
                }
            }
        } else {
            this.setTorchPos();
        }
        --this.tryTicks;
    }

    @Override
    public void doTick() {
    }

    private void setTorchPos() {
        this.torchPos = TaskUtils.isValidBlockToPlaceOn(this.plk, this.plk.m_20183_(), Blocks.f_50081_.m_49966_()) ? this.plk.m_20183_().m_7494_() : TaskUtils.getTorchPlacement(this.plk, 4, 2);
    }

    @Override
    public void m_8041_() {
        this.isInUse = false;
        this.tryTicks = 0;
        this.torchPos = null;
    }
}

