/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity.ai.tasks;

import java.util.EnumSet;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.caitie.roamers.entity.ai.TaskUtils;
import net.caitie.roamers.entity.ai.tasks.Task;
import net.caitie.roamers.util.CraftingManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.CraftingTableBlock;

public class CraftingTask
extends Task {
    protected CraftingManager craftManager;
    protected BlockPos craftingPos = BlockPos.f_121853_;
    boolean swing = false;
    boolean canCraft;
    private int verticalSearchStart;

    public CraftingTask(PlayerLikeCharacter character) {
        super(character);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public void doUpdateTick() {
        this.checkIfValidCraftingTable();
        this.canCraft = CraftingTask.canContinueCrafting(this.character);
        if (this.craftingPos != BlockPos.f_121853_ && this.isReachedTarget()) {
            this.character.m_21573_().m_26573_();
            if (!this.swing && !this.character.f_20911_) {
                this.character.m_6674_(InteractionHand.MAIN_HAND);
                this.swing = true;
            }
            this.craftManager.tick(40, true);
        }
    }

    @Override
    public void doTick() {
        if (this.craftingPos != null && this.craftingPos != BlockPos.f_121853_) {
            this.character.m_21563_().m_24946_((double)this.craftingPos.m_123341_(), (double)this.craftingPos.m_123342_(), (double)this.craftingPos.m_123343_());
            if (!this.isReachedTarget()) {
                this.moveMobToBlock();
            }
        }
    }

    @Override
    public int getUpdateTime() {
        return 10;
    }

    @Override
    public boolean shouldStart() {
        if (this.craftManager == null) {
            this.craftManager = this.character.getCraftingManager();
        }
        if (this.craftManager == null) {
            return false;
        }
        if (this.character.craftingTablePos == null) {
            return false;
        }
        if (this.character.hasFullInventory()) {
            return false;
        }
        if (!this.character.canCraft() || this.character.m_5803_()) {
            return false;
        }
        if (this.character.getCurrentActivity() == PlayerLikeCharacter.Activity.COMBAT || this.character.isMining() || this.character.getCurrentActivity() == PlayerLikeCharacter.Activity.BUILDING) {
            return false;
        }
        if (this.craftManager.getCraftingItem() == null || this.craftManager.canCraftInInventory(this.craftManager.getCraftingItem())) {
            return false;
        }
        if (CraftingTask.canContinueCrafting(this.character)) {
            this.checkIfValidCraftingTable();
            if (this.findNearestBlock()) {
                this.canCraft = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canContinue() {
        if (this.character.hasFullInventory()) {
            return false;
        }
        return this.character.canCraft() && this.craftingPos != BlockPos.f_121853_ && !this.character.m_5912_() && this.character.getWantedCraftingItem() != null && this.canCraft && this.character.m_21188_() == null;
    }

    public boolean m_6767_() {
        return false;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.character.m_21573_().m_26573_();
        TaskUtils.lookAt((PathfinderMob)this.character, this.craftingPos);
        this.swing = false;
        if (this.isReachedTarget() && !this.character.f_20911_) {
            this.character.m_6674_(InteractionHand.MAIN_HAND);
            this.swing = true;
        }
        this.character.setCurrentActivity(PlayerLikeCharacter.Activity.CRAFTING);
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.swing = false;
        this.character.setCurrentActivity(PlayerLikeCharacter.Activity.IDLE);
    }

    public boolean findNearestBlock() {
        if (this.character.craftingTablePos != null && this.character.craftingTablePos != BlockPos.f_121853_ && this.isValidTarget((LevelReader)this.character.f_19853_, this.character.craftingTablePos)) {
            this.craftingPos = this.character.craftingTablePos;
            return true;
        }
        return false;
    }

    public boolean isValidTarget(LevelReader reader, BlockPos blkpos) {
        return reader.m_8055_(blkpos).m_60734_() instanceof CraftingTableBlock;
    }

    public boolean isReachedTarget() {
        return this.craftingPos.m_203195_((Position)this.character.m_20182_(), 4.0);
    }

    protected void moveMobToBlock() {
        this.character.m_21573_().m_26519_((double)this.craftingPos.m_123341_() + 0.5, (double)this.craftingPos.m_123342_(), (double)this.craftingPos.m_123343_() + 0.5, 0.9);
    }

    public void checkIfValidCraftingTable() {
        if (this.character.craftingTablePos != null && !this.isValidTarget((LevelReader)this.character.f_19853_, this.character.craftingTablePos)) {
            this.character.craftingTablePos = null;
            this.craftingPos = BlockPos.f_121853_;
        }
    }

    public static boolean canContinueCrafting(PlayerLikeCharacter character) {
        CraftingManager craftManager = character.getCraftingManager();
        Item item = craftManager.checkCraftingDependents(craftManager.getCraftingItem());
        return !craftManager.testInventory(character.wantsToCraftItem) && (craftManager.canCraftItemOrIngredients(craftManager.getCraftingItem()) || item != null && craftManager.canCraftItemOrIngredients(item));
    }
}

