/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity.ai.tasks;

import java.util.EnumSet;
import java.util.List;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.caitie.roamers.entity.ai.tasks.Task;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class FishTask
extends Task {
    protected final PlayerLikeCharacter fisherman;
    protected final boolean onlyFish;
    protected ItemStack fishingRod;
    private final int verticalSearchRange = 5;
    private final int searchRange = 20;
    protected int verticalSearchStart;
    protected BlockPos waterPos;
    protected BlockPos standPos;
    protected FishingType currentFishingType;
    protected int waitTicks;
    protected float oldPathfindingMalus;
    protected List<Item> fish = List.of(Items.f_42526_, Items.f_42527_);
    protected List<Item> fishingLootExoticFish = List.of(Items.f_42529_, Items.f_42528_);
    protected List<Item> fishingLootJunk = List.of(Items.f_42094_, Items.f_42463_, Items.f_42398_, Items.f_42500_, Items.f_42454_, Items.f_42401_, Items.f_42532_, Items.f_42583_);
    protected List<Item> fishingLootTreasure = List.of(Items.f_42656_, Items.f_42450_, Items.f_42523_, Items.f_42517_, Items.f_42411_, Items.f_42715_);

    public FishTask(PlayerLikeCharacter fisher, boolean onlyFish) {
        super(fisher);
        this.fisherman = fisher;
        this.onlyFish = onlyFish;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public boolean shouldStart() {
        if (this.fisherman.getCurrentActivity() != PlayerLikeCharacter.Activity.FISHING && this.fisherman.canContinueToFish()) {
            this.standPos = this.findFishingPos();
            if (this.standPos != null) {
                this.fishingRod = this.findFishingRod();
                return this.fishingRod != null;
            }
        }
        return false;
    }

    @Override
    public boolean canContinue() {
        return this.fisherman.canContinueToFish() && this.fishingRod != null;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.fisherman.m_21008_(InteractionHand.MAIN_HAND, this.fishingRod);
        this.fisherman.setCurrentActivity(PlayerLikeCharacter.Activity.FISHING);
        this.oldPathfindingMalus = this.fisherman.m_21439_(BlockPathTypes.WATER);
        this.fisherman.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.currentFishingType = FishingType.CAST;
        this.setWaitTicks();
    }

    @Override
    public void doUpdateTick() {
    }

    @Override
    public void doTick() {
        this.fisherman.m_21563_().m_24946_((double)this.waterPos.m_123341_(), (double)this.waterPos.m_123342_(), (double)this.waterPos.m_123343_());
        if (!this.standPos.m_203195_((Position)this.fisherman.m_20182_(), 4.0)) {
            this.fisherman.m_21573_().m_26519_((double)this.standPos.m_123341_(), (double)this.standPos.m_123342_(), (double)this.standPos.m_123343_(), this.fisherman.isDepressed() ? 0.5 : 0.9);
            return;
        }
        this.fisherman.m_21573_().m_26573_();
        if (this.fisherman.fishingCooldown <= 0) {
            switch (this.currentFishingType) {
                case CAST: {
                    this.castRod();
                    this.setWaitTicks();
                    this.currentFishingType = FishingType.WAIT_AND_CATCH;
                    break;
                }
                case WAIT_AND_CATCH: {
                    --this.waitTicks;
                    if (this.waitTicks > 0) break;
                    this.catchFishingLoot();
                    this.currentFishingType = FishingType.CAST;
                    this.fisherman.fishingCooldown = 20;
                }
            }
        }
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.retrieveBobber();
        this.fisherman.m_21441_(BlockPathTypes.WATER, this.oldPathfindingMalus);
        this.fishingRod = null;
        this.fisherman.setCurrentActivity(PlayerLikeCharacter.Activity.IDLE);
    }

    public ItemStack findFishingRod() {
        return this.fisherman.getItemsInInventory(Items.f_42523_);
    }

    public void castRod() {
        this.fisherman.m_6674_(InteractionHand.MAIN_HAND);
        this.fisherman.f_19853_.m_6263_(null, this.fisherman.m_20185_(), this.fisherman.m_20186_(), this.fisherman.m_20189_(), SoundEvents.f_11941_, SoundSource.NEUTRAL, 1.0f, 0.4f / (this.fisherman.f_19853_.m_213780_().m_188501_() * 0.4f + 0.8f));
    }

    public void retrieveBobber() {
        this.fisherman.m_6674_(InteractionHand.MAIN_HAND);
        this.fisherman.f_19853_.m_6263_(null, this.fisherman.m_20185_(), this.fisherman.m_20186_(), this.fisherman.m_20189_(), SoundEvents.f_11939_, SoundSource.NEUTRAL, 1.0f, 0.4f / (this.fisherman.f_19853_.m_213780_().m_188501_() * 0.4f + 0.8f));
    }

    public void catchFishingLoot() {
        ItemStack loot = new ItemStack((ItemLike)this.fish.get(Mth.m_216271_((RandomSource)this.fisherman.f_19853_.m_213780_(), (int)0, (int)(this.fish.size() - 1))));
        if (!this.onlyFish) {
            if (this.fisherman.f_19853_.m_213780_().m_188499_() && this.fisherman.f_19853_.m_213780_().m_188499_()) {
                loot = new ItemStack((ItemLike)this.fishingLootJunk.get(Mth.m_216271_((RandomSource)this.fisherman.f_19853_.m_213780_(), (int)0, (int)(this.fishingLootJunk.size() - 1))));
            } else if (this.fisherman.f_19853_.m_213780_().m_188499_() && this.fisherman.f_19853_.m_213780_().m_188499_() && this.fisherman.f_19853_.m_213780_().m_188499_() && this.fisherman.f_19853_.m_213780_().m_188499_()) {
                Item item = this.fishingLootTreasure.get(Mth.m_216271_((RandomSource)this.fisherman.f_19853_.m_213780_(), (int)0, (int)(this.fishingLootTreasure.size() - 1)));
                loot = new ItemStack((ItemLike)item);
                if (item == Items.f_42523_ || item == Items.f_42517_ || item == Items.f_42411_) {
                    loot = EnchantmentHelper.m_220292_((RandomSource)this.fisherman.f_19853_.m_213780_(), (ItemStack)new ItemStack((ItemLike)item), (int)30, (boolean)true);
                }
            } else if (this.fisherman.f_19853_.m_213780_().m_188499_() && this.fisherman.f_19853_.m_213780_().m_188499_()) {
                loot = new ItemStack((ItemLike)this.fishingLootExoticFish.get(Mth.m_216271_((RandomSource)this.fisherman.f_19853_.m_213780_(), (int)0, (int)(this.fishingLootExoticFish.size() - 1))));
            }
        }
        if (this.fisherman.isSad()) {
            this.fisherman.addMoodValue();
        }
        ItemEntity itementity = new ItemEntity(this.fisherman.f_19853_, (double)this.waterPos.m_123341_(), (double)this.waterPos.m_123342_(), (double)this.waterPos.m_123343_(), loot);
        double d0 = this.fisherman.m_20185_() - (double)this.waterPos.m_123341_();
        double d1 = this.fisherman.m_20186_() - (double)this.waterPos.m_123342_();
        double d2 = this.fisherman.m_20189_() - (double)this.waterPos.m_123343_();
        itementity.m_20334_(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
        this.fisherman.f_19853_.m_6263_(null, this.fisherman.m_20185_(), this.fisherman.m_20186_(), this.fisherman.m_20189_(), SoundEvents.f_11940_, SoundSource.NEUTRAL, 0.6f, 1.0f);
        this.fisherman.f_19853_.m_7967_((Entity)itementity);
        this.retrieveBobber();
    }

    public BlockPos findFishingPos() {
        this.waterPos = this.findWater();
        if (this.waterPos != null) {
            int i = this.searchRange;
            int j = this.verticalSearchRange;
            BlockPos bpos = this.waterPos;
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            int k = this.verticalSearchStart;
            while (k <= j) {
                for (int l = 0; l < i; ++l) {
                    int i1 = 0;
                    while (i1 <= l) {
                        int j1;
                        int n = j1 = i1 < l && i1 > -l ? l : 0;
                        while (j1 <= l) {
                            mutable.m_122154_((Vec3i)bpos, i1, k - 1, j1);
                            BlockState bstate = this.fisherman.f_19853_.m_8055_((BlockPos)mutable);
                            if (this.fisherman.m_21444_((BlockPos)mutable) && bstate.m_60767_().m_76333_() && bstate.m_60643_((BlockGetter)this.fisherman.f_19853_, (BlockPos)mutable, EntityType.f_20532_) && !this.fisherman.f_19853_.m_46801_(bpos.m_7494_())) {
                                return mutable;
                            }
                            j1 = j1 > 0 ? -j1 : 1 - j1;
                        }
                        i1 = i1 > 0 ? -i1 : 1 - i1;
                    }
                }
                k = k > 0 ? -k : 1 - k;
            }
        }
        return null;
    }

    public BlockPos findWater() {
        int i = this.searchRange;
        int j = this.verticalSearchRange;
        BlockPos bpos = this.fisherman.m_20183_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int k = this.verticalSearchStart;
        while (k <= j) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        mutable.m_122154_((Vec3i)bpos, i1, k - 1, j1);
                        if (this.fisherman.f_19853_.m_46801_((BlockPos)mutable) && this.fisherman.f_19853_.m_46859_(mutable.m_7494_())) {
                            return mutable;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return null;
    }

    private void setWaitTicks() {
        this.waitTicks = Mth.m_216271_((RandomSource)this.fisherman.f_19853_.m_213780_(), (int)150, (int)650);
    }

    public boolean m_183429_() {
        return true;
    }

    static enum FishingType {
        CAST,
        WAIT_AND_CATCH;

    }
}

