/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.init;

import net.caitie.roamers.entity.BanditEntity;
import net.caitie.roamers.entity.PlayerDescendant;
import net.caitie.roamers.entity.RoamerEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RoamersModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"roamers");
    public static final RegistryObject<EntityType<RoamerEntity>> ROAMER = RoamersModEntities.register("roamer", EntityType.Builder.m_20704_(RoamerEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(10).setUpdateInterval(3).setCustomClientFactory(RoamerEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<BanditEntity>> BANDIT = RoamersModEntities.register("bandit", EntityType.Builder.m_20704_(BanditEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(10).setUpdateInterval(3).setCustomClientFactory(BanditEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<PlayerDescendant>> PLAYER_DESCENDANT = RoamersModEntities.register("player_descendant", EntityType.Builder.m_20704_(PlayerDescendant::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(10).setUpdateInterval(3).setCustomClientFactory(PlayerDescendant::new).m_20699_(0.6f, 1.8f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            RoamerEntity.init();
            BanditEntity.init();
            PlayerDescendant.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ROAMER.get(), RoamerEntity.createAttributes().m_22265_());
        event.put((EntityType)BANDIT.get(), BanditEntity.createAttributes().m_22265_());
        event.put((EntityType)PLAYER_DESCENDANT.get(), PlayerDescendant.createAttributes().m_22265_());
    }
}

