/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.caitie.roamers.recipe.RoamersRecipe;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CraftingManager {
    public static final Ingredient INVENTORY_CRAFTABLES = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41960_, Items.f_42406_, Items.f_42499_, Items.f_42000_});
    private final PlayerLikeCharacter character;
    private Item craftingItem;
    private Item originalCraftingItem;
    private Ingredient wantedIngredient;
    private int craftingIngredientAmount;
    private int time;
    public final ObjectArrayList<RoamersRecipe> RECIPES = new ObjectArrayList();

    public CraftingManager(PlayerLikeCharacter character) {
        this.character = character;
        this.initRecipes(this.character.f_19853_);
    }

    public void tick(int delay, boolean canCraft) {
        if (this.originalCraftingItem != this.character.wantsToCraftItem) {
            this.craftingItem = this.originalCraftingItem = this.character.wantsToCraftItem;
        }
        if (this.craftingItem == null) {
            this.craftingItem = this.originalCraftingItem;
        }
        if (this.craftingItem != null) {
            if (this.time <= 0) {
                if (!this.character.getCraftingManager().canCraftItem(this.craftingItem, false)) {
                    this.checkCrafting();
                    return;
                }
                if (canCraft && this.character.getCraftingManager().craftItem(this.craftingItem)) {
                    this.time = delay;
                    if (this.craftingItem == this.character.wantsToCraftItem) {
                        this.originalCraftingItem = null;
                        this.character.wantsToCraftItem = null;
                    }
                    this.craftingItem = null;
                    this.wantedIngredient = null;
                    return;
                }
                this.updateWantedIngredient();
                return;
            }
            --this.time;
        }
    }

    private void updateWantedIngredient() {
        int amount;
        Ingredient ingredient = this.character.getCraftingManager().getNeededIngredient(this.craftingItem);
        if (ingredient != null && (amount = this.character.getCraftingManager().getAmountNeeded(this.craftingItem, ingredient)) > 0) {
            this.wantedIngredient = ingredient;
            this.craftingIngredientAmount = amount;
        }
    }

    private void checkCrafting() {
        if (this.craftingItem != null) {
            Item item = this.checkCraftingDependents(this.craftingItem);
            if (item != null) {
                this.craftingItem = item;
            }
            if (this.character.getCraftingManager().getRecipeFor(this.craftingItem, false) == null) {
                if (this.character.wantsToCraftItem == this.craftingItem) {
                    this.character.wantsToCraftItem = null;
                }
                this.craftingItem = null;
            }
        }
    }

    public Item checkCraftingDependents(Item craftingItem) {
        RoamersRecipe recipe;
        if (craftingItem != null && (recipe = this.character.getCraftingManager().getRecipeFor(craftingItem, false)) != null) {
            for (Ingredient ingredient : recipe.m_7527_()) {
                if (this.character.getCraftingManager().hasIngredient(craftingItem, ingredient)) continue;
                for (ItemStack itemStack : ingredient.m_43908_()) {
                    if (this.character.getCraftingManager().canCraftItem(itemStack.m_41720_(), false)) {
                        return itemStack.m_41720_();
                    }
                    if (this.character.getCraftingManager().getRecipeFor(itemStack.m_41720_(), false) == null) continue;
                    return itemStack.m_41720_();
                }
            }
        }
        return null;
    }

    public Ingredient getWantedIngredient() {
        return this.wantedIngredient;
    }

    public Item getCraftingItem() {
        return this.craftingItem;
    }

    public int getWantedIngredientAmount() {
        return this.craftingIngredientAmount;
    }

    public boolean testInventory(Item item) {
        if (item != null) {
            for (int i = 0; i < this.character.m_35311_().m_6643_(); ++i) {
                ItemStack stack = this.character.m_35311_().m_8020_(i);
                if (!stack.m_150930_(item) || stack.m_41613_() < 9) continue;
                return true;
            }
        }
        return false;
    }

    private void initRecipes(Level level) {
        this.RECIPES.addAll((Collection)level.m_7465_().m_44013_((RecipeType)RoamersRecipe.Type.INSTANCE));
    }

    public boolean craftItem(Item craftingItem) {
        RoamersRecipe recipe = this.getRecipeFor(craftingItem, true);
        RoamersRecipe backupRecipe = this.getRecipeFor(craftingItem, false);
        if (this.canCraftItem(craftingItem, true)) {
            this.craft(recipe);
            return true;
        }
        if (this.canCraftItem(craftingItem, false)) {
            this.craft(backupRecipe);
        }
        return false;
    }

    private void craft(RoamersRecipe recipe) {
        if (recipe != null) {
            SimpleContainer inventory = this.character.m_35311_();
            ItemStack resultItem = recipe.m_8043_();
            for (int i = 0; i < recipe.m_7527_().size(); ++i) {
                block1: for (Ingredient itemsToConsume : recipe.m_7527_()) {
                    for (int j = 0; j < inventory.m_6643_(); ++j) {
                        if (!itemsToConsume.test(inventory.m_8020_(j))) continue;
                        Item itemToConsume = inventory.m_8020_(j).m_41720_();
                        int amount = (Integer)recipe.getAmounts().get(i);
                        inventory.m_19170_(itemToConsume, amount);
                        continue block1;
                    }
                }
            }
            inventory.m_19173_(resultItem);
        }
    }

    public boolean canCraftItem(Item craftingItem, boolean test) {
        RoamersRecipe recipe = this.getRecipeFor(craftingItem, test);
        if (recipe != null) {
            int flag = 0;
            for (Ingredient ingredient : recipe.m_7527_()) {
                if (!this.hasIngredient(craftingItem, ingredient)) continue;
                ++flag;
            }
            return flag >= recipe.m_7527_().size();
        }
        return false;
    }

    public boolean canCraftItemOrIngredients(Item craftingItem) {
        if (this.canCraftItem(craftingItem, true)) {
            return true;
        }
        return this.canCraftItemIngredients(craftingItem);
    }

    public boolean canCraftItemIngredients(Item craftingItem) {
        return this.getRecipeFor(craftingItem, true) != null && this.getNeededIngredient(craftingItem) == null;
    }

    public boolean hasIngredient(Item craftingItem, Ingredient ingredient) {
        for (int i = 0; i < this.character.m_35311_().m_6643_(); ++i) {
            ItemStack itemStack = this.character.m_35311_().m_8020_(i);
            if (!ingredient.test(itemStack) || this.getAmountNeeded(craftingItem, ingredient) > itemStack.m_41613_()) continue;
            return true;
        }
        return false;
    }

    public Ingredient getNeededIngredient(Item craftingItem) {
        RoamersRecipe recipe = this.getRecipeFor(craftingItem, false);
        if (recipe != null) {
            for (Ingredient ingredient : recipe.m_7527_()) {
                if (this.hasIngredient(craftingItem, ingredient)) continue;
                return ingredient;
            }
        }
        return null;
    }

    public int getAmountNeeded(Item craftingItem, Ingredient ingredient) {
        RoamersRecipe recipe = this.getRecipeFor(craftingItem, false);
        if (recipe != null) {
            for (int i = 0; i < recipe.m_7527_().size(); ++i) {
                Ingredient ingredient1 = (Ingredient)recipe.m_7527_().get(i);
                if (ingredient != ingredient1) continue;
                return (Integer)recipe.getAmounts().get(i);
            }
        }
        return -1;
    }

    @Nullable
    public RoamersRecipe getRecipeFor(Item item, boolean canCraft) {
        if (item != null) {
            Stream<RoamersRecipe> stream = this.RECIPES.stream().filter(recipe -> recipe.m_8043_().m_150930_(item));
            if (canCraft) {
                return stream.filter(recipe -> {
                    int flag = 0;
                    for (Ingredient ingredient : recipe.m_7527_()) {
                        for (int i = 0; i < this.character.m_35311_().m_6643_(); ++i) {
                            ItemStack itemStack = this.character.m_35311_().m_8020_(i);
                            if (!ingredient.test(itemStack)) continue;
                            ++flag;
                        }
                    }
                    return flag >= recipe.m_7527_().size();
                }).findFirst().orElse(null);
            }
            return stream.findFirst().orElse(null);
        }
        return null;
    }

    public boolean canCraftInInventory(Item item) {
        if (item != null) {
            return INVENTORY_CRAFTABLES.test(item.m_7968_());
        }
        return false;
    }
}

