/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.caitie.roamers.RoamersMod;
import net.minecraft.world.entity.EntityType;

public class Config {
    private static final Config INSTANCE = Config.loadOrWrite();
    public boolean allowNames = true;
    public boolean allowBreeding = true;
    public int babyAgeTicks = -72000;
    public int breedCooldownTicks = 45000;
    public boolean allowEating = true;
    public boolean allowHunger = true;
    public boolean allowStarvation = false;
    public boolean allowRegenAfterEating = true;
    public boolean allowCrafting = true;
    public boolean allowBuilding = true;
    public boolean doLegacyHouses = true;
    public boolean allowMining = true;
    public boolean mineBlocksInWayOfPath = true;
    public int blockSearchRange = 24;
    public int landClearingRange = 10;
    public boolean dropDirt = true;
    public boolean allowTorchPlacing = true;
    public boolean allowHunting = true;
    public boolean allowFishing = true;
    public boolean allowFarming = true;
    public boolean allowLandTilling = true;
    public int farmingRange = 3;
    public int descendantFarmingRange = 3;
    public boolean allowChestUse = true;
    public boolean allowEnemyAggression = true;
    public boolean allowMoods = true;
    public boolean allowMoodParticles = true;
    public boolean allowDepression = true;
    public boolean allowClaustrophobia = true;
    public boolean doBanditSpawning = true;
    public int banditSpawnChance = 550000;
    public int banditSpawnDelay = 12000;
    public boolean doBanditStealing = true;
    public int friendlyRelationStatus = 30;
    public int bestFriendRelationStatus = 60;
    public int enemyRelationStatus = -50;
    public int maxRelationStatus = 100;
    public int minRelationStatus = -100;
    public boolean allowDescendants = true;
    public boolean allowDescendantChores = true;
    public boolean doDescendantTeleporting = true;
    public boolean doDescendantCreativeModeFlight = false;
    public int descendantRelationOnBirth = 0;
    public boolean descendantForeverBaby = false;
    public boolean allowDescendantMonsterAttacks = true;
    public boolean allowBanditMonsterAttacks = false;
    public boolean allowRoamerMonsterAttacks = false;
    public boolean allowAllMonsterAttacks = false;
    public List<String> neutralMonsters = ImmutableList.builder().add((Object)EntityType.f_20566_.toString()).add((Object)EntityType.f_20531_.toString()).add((Object)EntityType.f_20454_.toString()).build();
    public boolean doSimpleTextures = false;
    public boolean doPlayerClones = false;

    public static Config getInstance() {
        return INSTANCE;
    }

    public static File getConfigFile() {
        new File("./config/roamers").mkdir();
        return new File("./config/roamers/config.json");
    }

    public static Config loadOrWrite() {
        block8: {
            Config config;
            FileReader reader = new FileReader(Config.getConfigFile());
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                Config config2 = (Config)gson.fromJson((Reader)reader, Config.class);
                config2.save();
                Config.writeInfoFile();
                config = config2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException jse) {
                    RoamersMod.LOGGER.error("!!! Roamers Mod failed to launch config !!!");
                    RoamersMod.LOGGER.error("Fix errors in the config file, or delete to reset!");
                    jse.printStackTrace();
                    break block8;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            reader.close();
            return config;
        }
        Config config = new Config();
        config.save();
        Config.writeInfoFile();
        return config;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(Config.getConfigFile());){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeInfoFile() {
        try {
            FileWriter fileWriter = new FileWriter("./config/roamers/info.txt");
            fileWriter.write("ROAMERS CONFIG CHEAT SHEET\n\n**This is not the config file, any changes in this file will be erased**\n\n*allowNames*: Configures if the characters should have generated names.\nDefault:true\n\n*allowBreeding*: Configures if the characters should breed.\nDefault:true\n\n*babyAgeTicks*: Changes the age of baby characters in minecraft ticks.\nNon-negative numbers will not be used.\nDefault:-72000\n\n*breedCooldownTicks*: Sets the age of characters in minecraft ticks after they breed.\nNegative numbers will not be used.\nDefault:45000\n\n*allowEating*: Changes if characters should eat.\nDefault:true\n\n*allowHunger*: Changes if characters should drain their hunger.\nDefault:true\n\n*allowStarvation*: Changes if characters should die from starvation.\nDefault:false\n\n*allowRegenAfterEating*: Changes if characters should regenerate their health after eating.\nDefault:true\n\n*allowCrafting*: Changes whether characters should craft items.\nDefault:true\n\n*allowBuilding*: Changes whether characters should build houses.\nDefault:true\n\n*doLegacyHouses*: Sets whether roamers will build the old houses of the mod. This can be\nturned off for the roamers to build the new experimental houses.\nDefault:true\n\n*allowMining*: Changes whether characters can mine blocks.\nDefault:true\n\n*dropDirt*: Configures if dirt blocks drop when characters dig. This can be turned off for\nlag purposes.\nDefault:true\n\n*mineBlocksInWayOfPath*: Changes if characters should mine blocks in the way of their\ntargeted path. For example, mine away leaves when cutting trees, and mine tunnels\nunderground.\nDefault:true\n\n*blockSearchRange*: Changes the search range of characters for finding blocks\nDefault:24\n\n*landClearingRange*: Changes how much land roamers will clear to build their house.\nIf doLegacyHouses is turned off, try setting this number to 14 for more room.\nDefault:10\n\n*allowTorchPlacing*: Changes if characters can place torches when mining in the dark.\nDefault:true\n\n*allowHunting*: Changes whether characters should hunt animals.\nDefault:true\n\n*allowFishing*: Changes whether characters should fish.\nDefault:true\n\n*allowFarming*: Changes whether characters should farm.\nDefault:true\n\n*allowLandTilling*: Changes if characters should till land when farming.\nDefault:true\n\n*farmingRange*: Changes the size of the land that the character should till.\nDefault:3\n\n*descendantFarmingRange*: Changes the size of the land that Player Descendants should till.\nDefault:3\n\n*allowChestUse*: Changes whether characters should interact with chests.\nDefault:true\n\n*allowEnemyAggression*: Configures whether characters should attack enemy players.\nDefault:true\n\n*allowMoods*: Changes if characters can have moods that affect behavior.\nDefault:true\n\n*allowMoodParticles*: Configures if mood particles can spawn around character.\nDefault:true\n\n*allowDepression*: Changes if characters can become depressed. Depression dramatically\naffects behavior and walking speed.\nDefault:true\n\n*allowClaustrophobia*: Changes if confined spaces will negatively affect moods.\nDefault:true\n\n*doBanditSpawning*: Configures whether bandits should spawn.\nDefault:true\n\n*banditSpawnChance*: Changes how rare Bandits spawn.\nA random number is chosen in this range each tick. If the randomized number is <= 10,\nBandits can spawn. Be careful changing this number!\nDefault:550000\n\n*banditSpawnDelay*: Changes the cooldown in ticks after a group of Bandits spawn.\nThis number does not spawn new Bandits when it reaches 0, just pauses the chances to spawn\na new group while counting down.\nDefault:12000\n\n*doBanditStealing*: Configures if bandits should steal items from chests.\nDefault:true\n\n*friendlyRelationStatus*: Sets the number in relationships for friends.\nFriends will give food.\nDefault:30\n\n*bestFriendRelationStatus*: Sets the number in relationships for best friends.\nBest Friends will give food and defend you from attacking entities.\nDefault:60\n\n*enemyRelationStatus*: Sets the number in relationships for enemies.\nDefault:-50\n\n*maxRelationStatus*: Sets the maximum possible status for a relationship.\nObtaining this status in game will let you have player descendants.\nDefault:100\n\n*minRelationStatus*: Sets the least possible status for a relationship.\nDefault:-100\n\n*allowDescendants*: Changes if players can have descendants in the game.\nDefault:true\n\n*allowDescendantChores*: Configures if player descendants can do chores.\nDefault:true\n\n*doDescendantTeleporting*: Changes if descendants following their parent player.\ncan teleport to them.\nDefault:true\n\n*doDescendantCreativeModeFlight*: Changes if descendants can fly and resist damage\nwhile their parent player is in creative mode.\nDefault:false\n\n*descendantRelationOnBirth*: Sets the relationship between the descendant and\nthe parent player when they are born.\nDefault:0\n\n*descendantForeverBaby*: Changes if descendants will always be a child no matter their age.\nDefault:false\n\n*allowDescendantMonsterAttacks*: Changes if monsters should attack descendants.\nDefault:true\n\n*allowBanditMonsterAttacks*: Changes if monsters should attack bandits.\nDefault:false\n\n*allowRoamerMonsterAttacks*: Changes if monsters should attack roamers.\nDefault:false\n\n*allowAllMonsterAttacks*: Changes if monsters should attack all characters.\nIf true, this will ignore the previous three values.\nDefault:false\n\n*neutralMonsters*: a list of monster entities who's ai will not be affected to \ntarget characters.\nThis will not make the entities passive to the characters, just for the mod \nto leave their ai untouched.\nDefault:\n\"entity.minecraft.enderman\",\n\"entity.minecraft.zombified_piglin\",\n\"entity.minecraft.piglin\",\n\"entity.minecraft.warden\",\n\"entity.minecraft.giant\"\n\n*doSimpleTextures*: Controls whether characters will use simple texture files rather than\nusing their genetics. This can be used for making your own textures for the characters, or\nfor the old look of the mod. Genetics will not be affected.\nDefault:false\n\n*doPlayerClones*: Determines whether descendants should adopt the parent player's skin.\nThis will not change their genetics, just rendering their texture.\nDefault:false\n\n");
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

