/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.client.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.caitie.roamers.client.layers.TextureLayer;
import net.caitie.roamers.entity.AbstractCharacter;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BaseLayer<T extends PlayerLikeCharacter, M extends PlayerModel<T>>
extends TextureLayer<T, M> {
    protected static final String path = "textures/layers/";
    protected static final ResourceLocation MALE_BASE = new ResourceLocation("roamers", "textures/layers/skin_male.png");
    protected static final ResourceLocation MALE_CHILD_BASE = new ResourceLocation("roamers", "textures/layers/skin_male_child.png");
    protected static final ResourceLocation FEMALE_BASE = new ResourceLocation("roamers", "textures/layers/skin_female.png");
    protected static final ResourceLocation FEMALE_CHILD_BASE = new ResourceLocation("roamers", "textures/layers/skin_female_child.png");

    public BaseLayer(RenderLayerParent<T, M> parent, boolean render) {
        super(parent, render);
    }

    @Override
    public void renderTexture(PoseStack stack, MultiBufferSource source, int i, T entity, float v, float v1, float v2, float v3, float v4, float v5) {
        if (!entity.m_20145_()) {
            VertexConsumer vertexConsumer = source.m_6299_(RenderType.m_110458_((ResourceLocation)this.getSkinTexture(entity)));
            float[] colorArray = PlayerLikeCharacter.Genetics.getTextureColors(((PlayerLikeCharacter)entity).getGenesOrDefault().getSkinColor());
            ((PlayerModel)this.m_117386_()).m_7695_(stack, vertexConsumer, i, OverlayTexture.f_118083_, colorArray[0], colorArray[1], colorArray[2], 1.0f);
        }
    }

    protected ResourceLocation getSkinTexture(T entity) {
        boolean male = ((AbstractCharacter)((Object)entity)).isMale();
        if (entity.m_6162_()) {
            return male ? MALE_CHILD_BASE : FEMALE_CHILD_BASE;
        }
        return male ? MALE_BASE : FEMALE_BASE;
    }
}

