/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.client.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.caitie.roamers.client.layers.TextureLayer;
import net.caitie.roamers.entity.AbstractCharacter;
import net.caitie.roamers.entity.PlayerDescendant;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClothesLayer<T extends PlayerLikeCharacter, M extends PlayerModel<T>>
extends TextureLayer<T, M> {
    public ClothesLayer(RenderLayerParent<T, M> parent, boolean render) {
        super(parent, render);
    }

    @Override
    public void renderTexture(PoseStack stack, MultiBufferSource source, int i, T entity, float v, float v1, float v2, float v3, float v4, float v5) {
        if (!entity.m_20145_()) {
            VertexConsumer vertexConsumer = source.m_6299_(RenderType.m_110458_((ResourceLocation)this.createClothing(entity)));
            if (entity instanceof PlayerDescendant) {
                float[] colors = ((PlayerDescendant)entity).getClothingColor().m_41068_();
                ((PlayerModel)this.m_117386_()).m_7695_(stack, vertexConsumer, i, LivingEntityRenderer.m_115338_(entity, (float)0.0f), colors[0], colors[1], colors[2], 1.0f);
            } else {
                ((PlayerModel)this.m_117386_()).m_7695_(stack, vertexConsumer, i, LivingEntityRenderer.m_115338_(entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    protected ResourceLocation createClothing(T character) {
        String customClothes = ((PlayerLikeCharacter)character).getGenesOrDefault().getCustomClothing();
        if (customClothes != null) {
            return new ResourceLocation("roamers", "textures/layers/clothes/" + customClothes + ".png");
        }
        Object clothes = character instanceof PlayerDescendant ? "plrdes" : ((AbstractCharacter)((Object)character)).getRace().name().toLowerCase();
        clothes = (String)clothes + (((AbstractCharacter)((Object)character)).isMale() ? "_male" : "_female");
        if (character.m_6162_()) {
            clothes = (String)clothes + "_child";
        }
        return new ResourceLocation("roamers", "textures/layers/clothes/" + (String)clothes + ".png");
    }
}

