/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.client.renderer;

import net.caitie.roamers.RoamersMod;
import net.caitie.roamers.client.renderer.PlayerLikeMobRenderer;
import net.caitie.roamers.entity.PlayerDescendant;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerDescendantRenderer
extends PlayerLikeMobRenderer {
    public PlayerDescendantRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public ResourceLocation getTextureLocation(PlayerLikeCharacter plike) {
        if (!this.canRenderTextureLayers()) {
            Player owner = (Player)((PlayerDescendant)plike).m_142480_();
            if (RoamersMod.CONFIG.doPlayerClones && owner != null) {
                AbstractClientPlayer clientPlayer = (AbstractClientPlayer)owner;
                return clientPlayer.m_108560_();
            }
            return this.getDefaultTexture(plike);
        }
        return super.getTextureLocation(plike);
    }

    @Override
    protected boolean canRenderTextureLayers() {
        if (RoamersMod.CONFIG.doPlayerClones) {
            return false;
        }
        return super.canRenderTextureLayers();
    }

    private ResourceLocation getDefaultTexture(PlayerLikeCharacter plike) {
        String type = plike.getRace().name().toLowerCase();
        String gender = plike.isMale() ? "male" : "female";
        String location = "textures/entities/" + type + "_plrdes_" + gender;
        if (plike.m_6162_()) {
            location = location + "_child";
        }
        return new ResourceLocation("roamers", location + ".png");
    }
}

