/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.caitie.roamers.RoamersMod;
import net.caitie.roamers.client.layers.BaseLayer;
import net.caitie.roamers.client.layers.BeltLayer;
import net.caitie.roamers.client.layers.ClothesLayer;
import net.caitie.roamers.client.layers.EyeLeftLayer;
import net.caitie.roamers.client.layers.EyeRightLayer;
import net.caitie.roamers.client.layers.EyeWhitesLayer;
import net.caitie.roamers.client.layers.HairLayer;
import net.caitie.roamers.client.layers.HeadWearLayer;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerLikeMobRenderer
extends LivingEntityRenderer<PlayerLikeCharacter, PlayerModel<PlayerLikeCharacter>> {
    public PlayerLikeMobRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PlayerModel(context.m_174023_(ModelLayers.f_171162_), false), 0.5f);
        this.m_115326_(new BaseLayer(this, this.canRenderTextureLayers()));
        this.m_115326_(new EyeWhitesLayer(this, this.canRenderTextureLayers()));
        this.m_115326_(new EyeLeftLayer(this, this.canRenderTextureLayers()));
        this.m_115326_(new EyeRightLayer(this, this.canRenderTextureLayers()));
        this.m_115326_(new ClothesLayer(this, this.canRenderTextureLayers()));
        this.m_115326_(new BeltLayer(this));
        this.m_115326_(new HairLayer(this, this.canRenderTextureLayers()));
        this.m_115326_(new HeadWearLayer(this, this.canRenderTextureLayers()));
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171165_))));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        this.m_115326_((RenderLayer)new ArrowLayer(context, (LivingEntityRenderer)this));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this));
    }

    protected boolean canRenderTextureLayers() {
        return !RoamersMod.CONFIG.doSimpleTextures;
    }

    public void render(PlayerLikeCharacter plk, float f1, float f2, PoseStack poseStack, MultiBufferSource bufferSource, int i) {
        this.setModelProperties(plk);
        super.m_7392_((LivingEntity)plk, f1, f2, poseStack, bufferSource, i);
    }

    public Vec3 getRenderOffset(PlayerLikeCharacter plk, float f) {
        return plk.m_6047_() ? new Vec3(0.0, -0.125, 0.0) : super.m_7860_((Entity)plk, f);
    }

    public void setModelProperties(PlayerLikeCharacter plk) {
        PlayerModel playerModel = (PlayerModel)this.m_7200_();
        playerModel.m_8009_(true);
        playerModel.f_102817_ = plk.m_6047_();
        HumanoidModel.ArmPose armPose = PlayerLikeMobRenderer.getArmPose(plk, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose armPose1 = PlayerLikeMobRenderer.getArmPose(plk, InteractionHand.OFF_HAND);
        if (armPose.m_102897_()) {
            HumanoidModel.ArmPose armPose2 = armPose1 = plk.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
        }
        if (plk.m_5737_() == HumanoidArm.RIGHT) {
            playerModel.f_102816_ = armPose;
            playerModel.f_102815_ = armPose1;
        } else {
            playerModel.f_102816_ = armPose1;
            playerModel.f_102815_ = armPose;
        }
    }

    private static HumanoidModel.ArmPose getArmPose(PlayerLikeCharacter plk, InteractionHand hand) {
        ItemStack itemstack = plk.m_21120_(hand);
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (plk.m_7655_() == hand && plk.m_21212_() > 0) {
            UseAnim useanim = itemstack.m_41780_();
            if (useanim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useanim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useanim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useanim == UseAnim.CROSSBOW && hand == plk.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useanim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
        } else if (!plk.f_20911_ && itemstack.m_41720_() instanceof CrossbowItem && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    protected void scale(PlayerLikeCharacter plk, PoseStack poseStack, float flt) {
        poseStack.m_85841_(0.9375f, 0.9375f, 0.9375f);
    }

    protected void setupRotations(PlayerLikeCharacter plk, PoseStack poseStack, float flt0, float flt1, float flt2) {
        float f = plk.m_20998_(flt2);
        if (plk.m_21255_()) {
            super.m_7523_((LivingEntity)plk, poseStack, flt0, flt1, flt2);
            float f1 = (float)plk.m_21256_() + flt2;
            float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!plk.m_21209_()) {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(f2 * (-90.0f - plk.m_146909_())));
            }
            Vec3 vec3 = plk.m_20252_(flt2);
            Vec3 vec31 = plk.m_20184_();
            double d0 = vec31.m_165925_();
            double d1 = vec3.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec31.f_82479_ * vec3.f_82479_ + vec31.f_82481_ * vec3.f_82481_) / Math.sqrt(d0 * d1);
                double d3 = vec31.f_82479_ * vec3.f_82481_ - vec31.f_82481_ * vec3.f_82479_;
                poseStack.m_85845_(Vector3f.f_122225_.m_122270_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.m_7523_((LivingEntity)plk, poseStack, flt0, flt1, flt2);
            float f3 = plk.m_20069_() ? -90.0f - plk.m_146909_() : -90.0f;
            float f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(f4));
            if (plk.m_6067_()) {
                poseStack.m_85837_(0.0, -1.0, (double)0.3f);
            }
        } else {
            super.m_7523_((LivingEntity)plk, poseStack, flt0, flt1, flt2);
        }
    }

    public ResourceLocation getTextureLocation(PlayerLikeCharacter plike) {
        return new ResourceLocation("roamers", "textures/blank_64.png");
    }
}

