/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.caitie.roamers.RoamersMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AbstractCharacter
extends AgeableMob
implements InventoryCarrier {
    protected SimpleContainer inventory = new SimpleContainer(27);
    public static final double DEPRESSED_MOVEMENT_SPEED = 0.5;
    public static TagKey HUNTABLES = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)new ResourceLocation("roamers", "huntable_animals"));
    public static TagKey EDIBLES = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("roamers", "edible_items"));
    public static TagKey COOKABLES = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("roamers", "cookable_items"));
    public static TagKey FOODS = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("roamers", "food_items"));
    public static TagKey TREASURES = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("roamers", "treasure_items"));
    public static TagKey PLANTABLES = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("roamers", "plantable_items"));
    public static TagKey UNDESIRED = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("roamers", "unwanted_items"));
    protected static final EntityDataAccessor<Boolean> MALE = SynchedEntityData.m_135353_(AbstractCharacter.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<String> RACE = SynchedEntityData.m_135353_(AbstractCharacter.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<String> TRAIT = SynchedEntityData.m_135353_(AbstractCharacter.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected Mood currentMood = Mood.NEUTRAL;
    protected int currentMoodDuration;
    protected int moodParticleTick = 0;
    protected int moodValue;
    protected int moodCheck;
    public List<UUID> childrenUUIDs = new ArrayList<UUID>();
    public Map<String, Integer> relations = new HashMap<String, Integer>();
    @Nullable
    private BlockPos homePosition = null;
    @Nullable
    public ItemEntity lootToPickUp;

    public AbstractCharacter(EntityType<? extends AbstractCharacter> chr, Level world) {
        super(chr, world);
        this.m_21553_(true);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_21573_().m_7008_(true);
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128379_("Male", this.isMale());
        tag.m_128359_("Race", this.getRaceByName());
        tag.m_128359_("Trait", this.getTraitByName());
        if (RoamersMod.CONFIG.allowMoods) {
            CompoundTag mood = new CompoundTag();
            mood.m_128359_("mood", this.getMoodByName());
            mood.m_128405_("time", this.currentMoodDuration);
            mood.m_128405_("status", this.moodValue);
            tag.m_128365_("CurrentMood", (Tag)mood);
        }
        tag.m_128365_("Inventory", (Tag)this.getInventory().m_7927_());
        if (this.getHomePos() != null) {
            tag.m_128347_("HomeX", (double)this.homePosition.m_123341_());
            tag.m_128347_("HomeY", (double)this.homePosition.m_123342_());
            tag.m_128347_("HomeZ", (double)this.homePosition.m_123343_());
        }
        if (!this.relations.isEmpty()) {
            List<String> keys = List.copyOf(this.relations.keySet());
            CompoundTag relationsTag = new CompoundTag();
            for (int i = 0; i < keys.size(); ++i) {
                CompoundTag relation = new CompoundTag();
                if (keys.get(i) == null) continue;
                relation.m_128359_("Name", keys.get(i));
                relation.m_128405_("Relation", this.relations.getOrDefault(keys.get(i), 0).intValue());
                relationsTag.m_128365_("Player" + i, (Tag)relation);
            }
            tag.m_128365_("Relationships", (Tag)relationsTag);
        }
        super.m_7380_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128423_("Male") != null) {
            this.setMale(tag.m_128471_("Male"));
        }
        if (tag.m_128423_("Race") != null) {
            this.setRace(Race.valueOf(tag.m_128461_("Race")));
        }
        if (tag.m_128423_("Trait") != null) {
            this.setTrait(Traits.valueOf(tag.m_128461_("Trait")));
        }
        if (tag.m_128441_("CurrentMood")) {
            CompoundTag mood = tag.m_128469_("CurrentMood");
            this.setMood(Mood.valueOf(mood.m_128461_("mood")), mood.m_128451_("time"));
            this.moodValue = mood.m_128441_("status") ? mood.m_128451_("status") : 0;
        }
        this.getInventory().m_7797_(tag.m_128437_("Inventory", 10));
        if (tag.m_128441_("HomeX")) {
            this.homePosition = new BlockPos(tag.m_128459_("HomeX"), tag.m_128459_("HomeY"), tag.m_128459_("HomeZ"));
        }
        if (tag.m_128441_("Relationships")) {
            CompoundTag relationships = tag.m_128469_("Relationships");
            for (int i = 0; i < relationships.m_128440_(); ++i) {
                CompoundTag relation = relationships.m_128469_("Player" + i);
                this.relations.put(relation.m_128461_("Name"), relation.m_128451_("Relation"));
            }
        }
    }

    public AbstractCharacter getNearestChildByUUID(UUID uuid, boolean isBaby) {
        if (this.childrenUUIDs.contains(uuid)) {
            if (uuid == null) {
                return null;
            }
            List list = this.f_19853_.m_6443_(AbstractCharacter.class, this.m_142469_().m_82377_(80.0, 50.0, 80.0), entity -> uuid.equals(entity.m_142081_()));
            if (!list.isEmpty()) {
                if (isBaby) {
                    for (int i = 0; i < list.size(); ++i) {
                        if (!((AbstractCharacter)((Object)list.get(i))).m_6162_()) continue;
                        return (AbstractCharacter)((Object)list.get(i));
                    }
                    return null;
                }
                return (AbstractCharacter)((Object)list.get(0));
            }
        }
        return null;
    }

    public void m_8107_() {
        super.m_8107_();
        if (--this.moodCheck <= 0) {
            this.moodCheck = 20;
        }
        this.checkMoodValue();
        if (RoamersMod.CONFIG.allowMoods) {
            if (this.currentMoodDuration > 0) {
                --this.currentMoodDuration;
            } else {
                this.setDefaultMood();
            }
            if (RoamersMod.CONFIG.allowMoodParticles && --this.moodParticleTick <= 0) {
                this.moodParticles();
                this.moodParticleTick = 20;
            }
        }
    }

    public void checkMoodValue() {
        if (!this.isDepressed() && this.moodValue < -1000) {
            this.setMood(Mood.DEPRESSED, 1000);
        } else if (!this.isSad() && this.moodValue < -400) {
            this.setMood(Mood.SAD, 600);
        }
    }

    public void addMoodValue() {
        ++this.moodValue;
    }

    public void shrinkMoodValue() {
        --this.moodValue;
    }

    public void moodParticles() {
        switch (this.currentMood) {
            case ANGRY: {
                this.f_19853_.m_7605_((Entity)this, (byte)64);
                break;
            }
            case FURIOUS: {
                this.f_19853_.m_7605_((Entity)this, (byte)68);
                break;
            }
            case HAPPY: {
                this.f_19853_.m_7605_((Entity)this, (byte)67);
                break;
            }
            case IN_LOVE: {
                this.f_19853_.m_7605_((Entity)this, (byte)66);
                break;
            }
            case SAD: {
                this.f_19853_.m_7605_((Entity)this, (byte)42);
                break;
            }
            case DEPRESSED: {
                this.f_19853_.m_7605_((Entity)this, (byte)65);
            }
        }
    }

    public Mood getMood() {
        return this.currentMood;
    }

    public String getMoodByName() {
        return this.currentMood.name();
    }

    public void setMood(Mood mood, int duration) {
        if (RoamersMod.CONFIG.allowMoods) {
            this.currentMood = mood;
            this.currentMoodDuration = duration;
        }
    }

    public void setDefaultMood() {
        if (RoamersMod.CONFIG.allowMoods) {
            this.currentMood = Mood.NEUTRAL;
        }
    }

    public int getRelationship(Player player) {
        return this.relations.getOrDefault(player.m_7755_().getString(), 0);
    }

    public void setRelationship(Player player, int value) {
        if (value > RoamersMod.CONFIG.maxRelationStatus) {
            this.relations.put(player.m_7755_().getString(), RoamersMod.CONFIG.maxRelationStatus);
            return;
        }
        if (value < RoamersMod.CONFIG.minRelationStatus) {
            this.relations.put(player.m_7755_().getString(), RoamersMod.CONFIG.minRelationStatus);
            return;
        }
        this.relations.put(player.m_7755_().getString(), value);
    }

    public void addRelationPoints(Player player, int value) {
        int relation = this.getRelationship(player);
        this.setRelationship(player, relation + value);
        this.f_19853_.m_7605_((Entity)this, (byte)14);
    }

    public void removeRelationPoints(Player player, int value) {
        int relation = this.getRelationship(player);
        this.setRelationship(player, relation - value);
        this.f_19853_.m_7605_((Entity)this, (byte)13);
    }

    public boolean isFriend(Player player) {
        return this.getRelationship(player) >= RoamersMod.CONFIG.friendlyRelationStatus;
    }

    public boolean isBestFriend(Player player) {
        return this.getRelationship(player) >= RoamersMod.CONFIG.bestFriendRelationStatus;
    }

    public boolean isEnemy(Player player) {
        return this.getRelationship(player) <= RoamersMod.CONFIG.enemyRelationStatus;
    }

    public boolean hasFightingTraits() {
        return this.getTrait() == Traits.BRAVE || this.getTrait() == Traits.HEROIC;
    }

    public boolean isHotHead() {
        return this.getTrait() == Traits.HOTHEAD;
    }

    public boolean m_7252_(ItemStack stack) {
        return false;
    }

    public boolean shouldHunt() {
        return RoamersMod.CONFIG.allowHunting && !this.m_6162_();
    }

    @Nullable
    public BlockPos getHomePos() {
        return this.homePosition;
    }

    public void setHomePos(BlockPos bpos) {
        this.homePosition = bpos;
    }

    public void m_7581_(ItemEntity itement) {
        if (itement.m_32057_() != null && itement.m_32057_().equals(this.m_142081_())) {
            return;
        }
        if (this.getInventory().m_19183_(itement.m_32055_())) {
            Player ent;
            if (itement.m_32057_() != null && (ent = this.f_19853_.m_46003_(itement.m_32057_())) != null) {
                ItemStack stack = itement.m_32055_();
                if (stack.m_204117_(FOODS) || this.isFarmingItem(stack)) {
                    if (this.m_6162_() && stack.m_150930_(Items.f_42572_)) {
                        this.addRelationPoints(ent, stack.m_41613_() / 2 + 5);
                        this.setMood(Mood.HAPPY, this.getTrait() == Traits.GRUMPY ? 200 : 400);
                    } else {
                        this.addRelationPoints(ent, stack.m_41613_() / 2 + 1);
                    }
                } else if (stack.m_204117_(TREASURES) || stack.m_150930_(Items.f_42129_)) {
                    this.addRelationPoints(ent, stack.m_41613_() / 2 + 5);
                } else if (stack.m_204117_(PLANTABLES)) {
                    this.addRelationPoints(ent, stack.m_41613_() / 2 / 2);
                }
            }
            AbstractCharacter.pickUpItem(this, itement);
        }
    }

    protected static void pickUpItem(AbstractCharacter chr, ItemEntity entity) {
        ItemStack itemstack = entity.m_32055_();
        if (chr.m_7243_(itemstack)) {
            SimpleContainer simplecontainer = chr.getInventory();
            boolean flag = simplecontainer.m_19183_(itemstack);
            if (!flag) {
                return;
            }
            chr.m_21053_(entity);
            int i = itemstack.m_41613_();
            ItemStack itemstack1 = simplecontainer.m_19173_(itemstack);
            chr.m_7938_((Entity)entity, i - itemstack1.m_41613_());
            if (itemstack1.m_41619_()) {
                entity.m_146870_();
            } else {
                itemstack.m_41764_(itemstack1.m_41613_());
            }
        }
    }

    protected InteractionResult giveFood(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if ((itemStack.m_204117_(FOODS) || this.isFarmingItem(itemStack) || itemStack.m_204117_(PLANTABLES)) && this.getInventory().m_19183_(itemStack)) {
            player.m_6674_(hand);
            if (this.m_6162_() && itemStack.m_150930_(Items.f_42572_)) {
                this.addRelationPoints(player, itemStack.m_41613_() / 2 + 5);
                this.setMood(Mood.HAPPY, this.getTrait() == Traits.GRUMPY ? 200 : 400);
            } else if (itemStack.m_204117_(FOODS) || this.isFarmingItem(itemStack)) {
                this.addRelationPoints(player, itemStack.m_41613_() / 2 + 1);
            } else if (itemStack.m_204117_(PLANTABLES)) {
                this.addRelationPoints(player, itemStack.m_41613_() / 2 / 2);
            }
            this.getInventory().m_19173_(new ItemStack((ItemLike)itemStack.m_41720_(), 1));
            itemStack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean isFarmingItem(ItemStack stack) {
        return stack.m_150930_(Items.f_42405_) || stack.m_150930_(Items.f_42499_);
    }

    public boolean isMale() {
        return (Boolean)this.f_19804_.m_135370_(MALE);
    }

    public Race getRace() {
        return Race.valueOf(this.getRaceByName());
    }

    public String getRaceByName() {
        return (String)this.f_19804_.m_135370_(RACE);
    }

    public void setRace(Race type) {
        this.f_19804_.m_135381_(RACE, (Object)type.name());
    }

    public void setMale(boolean gender) {
        this.f_19804_.m_135381_(MALE, (Object)gender);
    }

    public Traits getTrait() {
        return Traits.valueOf(this.getTraitByName());
    }

    public boolean canBreedWith(AbstractCharacter partner) {
        return !this.m_6162_() && !partner.m_6162_() && (this.isMale() && !partner.isMale() || !this.isMale() && partner.isMale());
    }

    public String getTraitByName() {
        return (String)this.f_19804_.m_135370_(TRAIT);
    }

    public void setTrait(Traits traits) {
        this.f_19804_.m_135381_(TRAIT, (Object)traits.name());
    }

    public boolean m_6052_() {
        if (!RoamersMod.CONFIG.allowNames) {
            if (this.m_8077_()) {
                return this.m_20151_();
            }
            return false;
        }
        return this.m_8077_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity ent;
        if (this.m_5803_() && !this.f_19853_.m_5776_()) {
            this.m_5796_();
        }
        if ((ent = source.m_7639_()) instanceof Player && !this.f_19853_.m_5776_()) {
            this.removeRelationPoints((Player)ent, (int)amount + 5);
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource source) {
        RoamersMod.LOGGER.info(source.m_6157_((LivingEntity)this).getString());
        super.m_6667_(source);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MALE, (Object)true);
        this.f_19804_.m_135372_(RACE, (Object)Race.PLAINS.name());
        this.f_19804_.m_135372_(TRAIT, (Object)Traits.PASSIVE.name());
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public boolean hasFullInventory() {
        int flag = 0;
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack item = this.getInventory().m_8020_(i);
            if (item.m_41619_()) continue;
            ++flag;
        }
        return flag >= this.getInventory().m_6643_();
    }

    public boolean hasTaggedItemsInInventory(TagKey<Item> tag) {
        boolean flag = false;
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack item = this.getInventory().m_8020_(i);
            if (!item.m_204117_(tag)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public ItemStack getTaggedItemsInInventory(TagKey<Item> tag) {
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack item = this.getInventory().m_8020_(i);
            if (!item.m_204117_(tag)) continue;
            return item;
        }
        return null;
    }

    public ItemStack getItemsInInventory(Item item) {
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack itemstack = this.getInventory().m_8020_(i);
            if (!itemstack.m_150930_(item)) continue;
            return itemstack;
        }
        return null;
    }

    public ItemStack getItemTypeInInventory(Class<? extends Item> itemClass) {
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack item = this.getInventory().m_8020_(i);
            if (!itemClass.isInstance(item.m_41720_())) continue;
            return item;
        }
        return null;
    }

    public ItemStack getArmorTypeInInventory(EquipmentSlot slot) {
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack item = this.getInventory().m_8020_(i);
            if (!(item.m_41720_() instanceof ArmorItem) || !((ArmorItem)item.m_41720_()).m_40402_().equals((Object)slot)) continue;
            return item;
        }
        return null;
    }

    public boolean hasToolsInInventory() {
        boolean retval = false;
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack item = this.getInventory().m_8020_(i);
            if (!this.isTool(item)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    public int getAmountOfTaggedItems(TagKey items) {
        int r = 0;
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack item = this.getInventory().m_8020_(i);
            if (!item.m_204117_(items)) continue;
            r += item.m_41613_();
        }
        return r;
    }

    public int getAmountOfItems(Item item) {
        int r = 0;
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack itemstack = this.getInventory().m_8020_(i);
            if (!itemstack.m_150930_(item)) continue;
            r += itemstack.m_41613_();
        }
        return r;
    }

    public boolean isTool(ItemStack stack) {
        if (stack.m_41720_() instanceof HoeItem) {
            return true;
        }
        if (stack.m_41720_() instanceof SwordItem) {
            return true;
        }
        if (stack.m_41720_() instanceof ShovelItem) {
            return true;
        }
        if (stack.m_41720_() instanceof PickaxeItem) {
            return true;
        }
        return stack.m_41720_() instanceof AxeItem;
    }

    public ItemStack getMeleeWeaponsInInventory() {
        ItemStack retval = ItemStack.f_41583_;
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack item = this.getInventory().m_8020_(i);
            if (item.m_41720_() instanceof SwordItem) {
                retval = item;
                break;
            }
            if (!(item.m_41720_() instanceof AxeItem)) continue;
            retval = item;
            break;
        }
        return retval;
    }

    public boolean hasItemsInInventory(Item item) {
        boolean flag = false;
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack flagItem = this.getInventory().m_8020_(i);
            if (!flagItem.m_150930_(item)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    protected void particlesEvent(ParticleOptions type, int count) {
        for (int i = 0; i < count; ++i) {
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d1 = this.f_19796_.nextGaussian() * 0.02;
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_(type, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public void m_7822_(byte bit) {
        switch (bit) {
            case 13: {
                this.particlesEvent((ParticleOptions)ParticleTypes.f_123792_, 7);
                break;
            }
            case 14: {
                this.particlesEvent((ParticleOptions)ParticleTypes.f_123748_, 7);
                break;
            }
            case 18: {
                this.particlesEvent((ParticleOptions)ParticleTypes.f_123750_, 7);
                break;
            }
            case 42: {
                this.particlesEvent((ParticleOptions)ParticleTypes.f_123761_, 4);
                break;
            }
            case 63: {
                if (this.m_6844_(EquipmentSlot.MAINHAND) == ItemStack.f_41583_) break;
                this.spawnItemParticles(this.m_6844_(EquipmentSlot.MAINHAND), 6);
                break;
            }
            case 64: {
                this.particlesEvent((ParticleOptions)ParticleTypes.f_123762_, 4);
                break;
            }
            case 65: {
                this.particlesEvent((ParticleOptions)ParticleTypes.f_123761_, 5);
                break;
            }
            case 66: {
                this.particlesEvent((ParticleOptions)ParticleTypes.f_123750_, 4);
                break;
            }
            case 67: {
                this.particlesEvent((ParticleOptions)ParticleTypes.f_123748_, 4);
                break;
            }
            case 68: {
                this.particlesEvent((ParticleOptions)ParticleTypes.f_123792_, 4);
                break;
            }
            default: {
                super.m_7822_(bit);
            }
        }
    }

    private void spawnItemParticles(ItemStack p_21061_, int p_21062_) {
        for (int i = 0; i < p_21062_; ++i) {
            Vec3 vec3 = new Vec3(((double)this.f_19796_.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
            vec3 = vec3.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            double d0 = (double)(-this.f_19796_.nextFloat()) * 0.6 - 0.3;
            Vec3 vec31 = new Vec3(((double)this.f_19796_.nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec31 = vec31.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
            vec31 = vec31.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            vec31 = vec31.m_82520_(this.m_20185_(), this.m_20188_(), this.m_20189_());
            if (this.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, p_21061_), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_, 0.0);
                continue;
            }
            this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, p_21061_), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
        }
    }

    public boolean isHurt() {
        return this.m_21223_() < this.m_21233_();
    }

    public void tossItem(ItemStack stack, @Nullable Entity entity) {
        if (!this.f_19853_.m_5776_()) {
            ItemEntity itemEnt = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
            Vec3 randPos = LandRandomPos.m_148488_((PathfinderMob)this, (int)4, (int)2);
            if (randPos == null) {
                randPos = this.m_20182_();
            }
            Vec3 vec3 = this.m_20182_().m_82496_(this.m_146909_()).m_82524_(this.m_146908_()).m_82546_(randPos.m_82520_(0.0, 1.0, 0.0));
            if (entity != null) {
                vec3 = entity.m_20182_().m_82546_(this.m_20182_());
            }
            vec3 = vec3.m_82541_().m_82490_(0.5);
            itemEnt.m_20256_(vec3);
            itemEnt.m_32060_();
            itemEnt.m_32052_(this.m_142081_());
            this.m_6674_(InteractionHand.MAIN_HAND);
            this.f_19853_.m_7967_((Entity)itemEnt);
        }
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_7243_(ItemStack stack) {
        return false;
    }

    public boolean m_6573_(Player plr) {
        return false;
    }

    public SoundEvent m_7515_() {
        return null;
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob ageable) {
        return null;
    }

    protected void m_7472_(DamageSource source, int i, boolean b) {
        this.getInventory().m_19195_().forEach(arg_0 -> ((AbstractCharacter)this).m_19983_(arg_0));
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.45;
    }

    protected void createPerson(BlockPos bpos) {
        this.setMale(this.f_19796_.nextBoolean());
        this.setTrait(Traits.shuffle(this.f_19796_));
        this.chooseRace(bpos);
    }

    public boolean isHappy() {
        return this.getMood() == Mood.HAPPY;
    }

    public boolean isInLove() {
        return this.getMood() == Mood.IN_LOVE;
    }

    public boolean isInGoodMood() {
        return this.isHappy() || this.isInLove();
    }

    public boolean isSad() {
        return this.getMood() == Mood.SAD || this.getMood() == Mood.DEPRESSED;
    }

    public boolean isAngry() {
        return this.getMood() == Mood.ANGRY || this.getMood() == Mood.FURIOUS;
    }

    public boolean isInBadMood() {
        return this.isSad() || this.isAngry();
    }

    public boolean isDepressed() {
        return RoamersMod.CONFIG.allowDepression && this.getMood() == Mood.DEPRESSED;
    }

    protected void chooseRace(BlockPos bpos) {
        this.setRace(this.getRaceFromBlockPos(bpos));
    }

    public Race getRaceFromBlockPos(BlockPos bpos) {
        Holder biome = this.f_19853_.m_204166_(bpos);
        if (biome.m_203656_(TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("roamers", "desert_spawns")))) {
            return Race.DESERT;
        }
        if (biome.m_203656_(TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("roamers", "badlands_spawns")))) {
            return Race.BADLANDS;
        }
        if (biome.m_203656_(TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("roamers", "savanna_spawns")))) {
            return Race.SAVANNA;
        }
        if (biome.m_203656_(TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("roamers", "jungle_spawns")))) {
            return Race.JUNGLE;
        }
        if (biome.m_203656_(TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("roamers", "taiga_spawns")))) {
            return Race.TAIGA;
        }
        if (biome.m_203656_(TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("roamers", "artic_spawns")))) {
            return Race.ARTIC;
        }
        return Race.PLAINS;
    }

    public SoundEvent m_7975_(DamageSource source) {
        if (source == DamageSource.f_19307_ || source == DamageSource.f_19308_ || source == DamageSource.f_19305_ || source == DamageSource.f_19309_) {
            return SoundEvents.f_12273_;
        }
        if (source == DamageSource.f_19312_) {
            return SoundEvents.f_12324_;
        }
        if (source == DamageSource.f_146701_) {
            return SoundEvents.f_144205_;
        }
        if (source == DamageSource.f_19325_) {
            return SoundEvents.f_12274_;
        }
        return SoundEvents.f_12323_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12322_;
    }

    public static enum Mood {
        HAPPY,
        IN_LOVE,
        ANGRY,
        FURIOUS,
        SAD,
        DEPRESSED,
        NEUTRAL;

    }

    public static enum Race {
        PLAINS,
        SAVANNA,
        DESERT,
        BADLANDS,
        ARTIC,
        JUNGLE,
        TAIGA;

    }

    public static enum Traits {
        HOTHEAD,
        GREEDY,
        PASSIVE,
        STRONG,
        BRAVE,
        CAREFUL,
        FRIENDLY,
        LOYAL,
        GRUMPY,
        HEROIC;


        public static Traits shuffle(Random rand) {
            List<Traits> arr = Arrays.asList(Traits.values());
            return arr.get(rand.nextInt(arr.size()));
        }
    }
}

