/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.caitie.roamers.NameGenerator;
import net.caitie.roamers.RoamersMod;
import net.caitie.roamers.entity.AbstractCharacter;
import net.caitie.roamers.entity.PlayerDescendant;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.caitie.roamers.entity.RoamerEntity;
import net.caitie.roamers.entity.ai.PlayerLikeAI;
import net.caitie.roamers.entity.ai.goals.CookFoodGoal;
import net.caitie.roamers.entity.ai.goals.PickUpItemGoal;
import net.caitie.roamers.entity.ai.goals.PlayerLikeMeleeGoal;
import net.caitie.roamers.entity.ai.goals.StealGoal;
import net.caitie.roamers.init.RoamersModEntities;
import net.caitie.roamers.init.RoamersModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class BanditEntity
extends PlayerLikeCharacter
implements Enemy {
    private final PlayerLikeAI AI;
    private final NameGenerator nameGen = new NameGenerator();

    public BanditEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<BanditEntity>)((EntityType)RoamersModEntities.BANDIT.get()), world);
    }

    public BanditEntity(EntityType<BanditEntity> type, Level world) {
        super((EntityType<? extends PlayerLikeCharacter>)type, world);
        this.AI = new PlayerLikeAI(this){
            final BanditEntity bandit;
            {
                this.bandit = BanditEntity.this;
            }

            @Override
            public void postInit() {
                this.currentBrain = this.BRAIN;
                this.overrideBrainState(this.currentBrain, PlayerLikeAI.State.TARGETING, (List<Goal>)new ObjectArrayList(List.of(new HurtByTargetGoal((PathfinderMob)this.bandit, new Class[0]).m_26044_(new Class[0]), new NearestAttackableTargetGoal((Mob)this.bandit, Player.class, false, false), new NearestAttackableTargetGoal((Mob)this.bandit, PlayerDescendant.class, false, false), new NearestAttackableTargetGoal((Mob)this.bandit, RoamerEntity.class, false, false), new NearestAttackableTargetGoal((Mob)this.bandit, AbstractVillager.class, false, false), this.huntingGoal)));
                this.coreGoals = new ObjectArrayList(List.of(new PickUpItemGoal(this.bandit, 0.9), new PlayerLikeMeleeGoal(this.bandit, 1.0, true), new FloatGoal((Mob)this.bandit), new StealGoal(this.bandit), this.doorGoal, new CookFoodGoal(this.bandit, 0.9, 10)));
                this.overrideBrainState(this.currentBrain, PlayerLikeAI.State.CORE, (List<Goal>)this.coreGoals);
                this.overrideBrainState(this.currentBrain, PlayerLikeAI.State.USING_CHEST, List.of());
                super.postInit();
            }
        };
        this.f_21364_ = 10;
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.despawnIfPossible();
    }

    @Override
    public PlayerLikeAI getAI() {
        return this.AI;
    }

    @Override
    public boolean canBuild() {
        return false;
    }

    @Override
    public boolean canFarm() {
        return false;
    }

    @Override
    public boolean shouldSleep() {
        return false;
    }

    @Override
    public boolean canFish() {
        return false;
    }

    @Override
    public boolean canCraft() {
        return false;
    }

    @Override
    public BlockPos getHomePos() {
        return null;
    }

    protected void despawnIfPossible() {
        if (this.m_146764_() == 0 && !this.m_5912_() && this.f_19853_.m_45976_(Player.class, this.m_142469_().m_82377_(16.0, 16.0, 16.0)).isEmpty()) {
            this.m_146870_();
        }
    }

    @Override
    public void checkDepression() {
    }

    @Override
    public void addRelationPoints(Player player, int value) {
    }

    @Override
    public boolean shouldHunt() {
        return super.shouldHunt() && this.isHungry();
    }

    @Override
    public boolean m_7243_(ItemStack stack) {
        return this.getInventory().m_19183_(stack) && (stack.m_204117_(EDIBLES) || stack.m_204117_(COOKABLES) || stack.m_204117_(TREASURES));
    }

    @Override
    public AgeableMob m_142606_(ServerLevel slevel, AgeableMob ageable) {
        return null;
    }

    public boolean m_6162_() {
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Entity ent = source.m_7639_();
        if (ent instanceof Player && !this.f_19853_.m_5776_()) {
            this.f_19853_.m_7605_((Entity)this, (byte)13);
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor slevel, DifficultyInstance instance, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        String name;
        this.createPerson(this.m_142538_());
        if (RoamersMod.CONFIG.allowNames && (name = this.nameGen.createCharacterName(this)) != null) {
            this.m_6593_((Component)new TextComponent("\u00a7c" + name));
        }
        if (this.getRace() == AbstractCharacter.Race.ARTIC) {
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)RoamersModItems.WOOL_HELMET.get()));
            this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)RoamersModItems.WOOL_CHESTPLATE.get()));
            this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)RoamersModItems.WOOL_LEGGINGS.get()));
            this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)RoamersModItems.WOOL_BOOTS.get()));
        }
        if (this.getInventory().m_7983_()) {
            if (this.getRace() == AbstractCharacter.Race.BADLANDS || this.getRace() == AbstractCharacter.Race.DESERT || this.getRace() == AbstractCharacter.Race.JUNGLE) {
                if (slevel.m_5822_().nextInt(2) == 0) {
                    this.getInventory().m_19173_(Items.f_42433_.m_7968_());
                } else {
                    this.getInventory().m_19173_(Items.f_42430_.m_7968_());
                }
            } else if (slevel.m_5822_().nextInt(2) == 0) {
                this.getInventory().m_19173_(Items.f_42386_.m_7968_());
            } else {
                this.getInventory().m_19173_(Items.f_42383_.m_7968_());
            }
            this.getInventory().m_19173_(new ItemStack((ItemLike)Items.f_42580_, slevel.m_5822_().nextInt(4) + 2));
            if (slevel.m_5822_().nextInt(4) == 0) {
                List<ItemStack> treasures = List.of(Items.f_42436_.m_7968_(), Items.f_42415_.m_7968_(), Items.f_42417_.m_7968_(), Items.f_41912_.m_7968_(), Items.f_42677_.m_7968_(), Items.f_42616_.m_7968_(), EnchantmentHelper.m_44877_((Random)slevel.m_5822_(), (ItemStack)Items.f_42517_.m_7968_(), (int)30, (boolean)true));
                this.getInventory().m_19173_(treasures.get(slevel.m_5822_().nextInt(treasures.size())));
            }
        }
        this.m_146762_(48000);
        return super.m_6518_(slevel, instance, type, data, tag);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 20.0);
        return builder;
    }
}

