/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity.ai;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.caitie.roamers.RoamersMod;
import net.caitie.roamers.entity.AbstractCharacter;
import net.caitie.roamers.entity.BanditEntity;
import net.caitie.roamers.entity.PlayerDescendant;
import net.caitie.roamers.entity.PlayerLike;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.caitie.roamers.entity.ai.goals.AttackEnemyGoal;
import net.caitie.roamers.entity.ai.goals.HuntingGoal;
import net.caitie.roamers.entity.ai.goals.PickUpItemGoal;
import net.caitie.roamers.entity.ai.goals.SleepGoal;
import net.caitie.roamers.entity.ai.goals.UseChestGoal;
import net.caitie.roamers.entity.ai.tasks.BabyPlayTask;
import net.caitie.roamers.entity.ai.tasks.BuildTask;
import net.caitie.roamers.entity.ai.tasks.CraftingTask;
import net.caitie.roamers.entity.ai.tasks.FarmTask;
import net.caitie.roamers.entity.ai.tasks.FishTask;
import net.caitie.roamers.entity.ai.tasks.MineTask;
import net.caitie.roamers.entity.ai.tasks.Task;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;

public class PlayerLikeAI {
    private final PlayerLikeCharacter chr;
    private int goalChecker;
    public State lastState;
    public State currentState = State.IDLE;
    public State coreState = State.CORE;
    public State targetState = State.TARGETING;
    public LookAtPlayerGoal lookAtPlayerGoal;
    public LookAtPlayerGoal lookAtEntityGoal;
    public RandomLookAroundGoal lookAroundGoal;
    public WaterAvoidingRandomStrollGoal randomStrollGoal;
    public CraftingTask craftTask;
    public MineTask mineTask;
    public BuildTask buildTask;
    public FarmTask farmTask;
    public FishTask fishTask;
    public HuntingGoal huntingGoal;
    public OpenDoorGoal doorGoal;
    public BabyPlayTask playGoal;
    public ObjectArrayList<Goal> coreGoals;
    public Map<State, ObjectArrayList<Goal>> BRAIN;
    public Map<State, ObjectArrayList<Goal>> BABY_BRAIN;
    public Map<State, ObjectArrayList<Goal>> currentBrain;
    public Set<Goal.Flag> disabledFlags = new HashSet<Goal.Flag>();
    public boolean checkLand;

    public PlayerLikeAI(PlayerLikeCharacter chr) {
        this.chr = chr;
    }

    public void initAI() {
        this.initGoals();
        this.initBrains();
        this.goalChecker = this.getGoalTime() / 2;
        this.postInit();
    }

    protected void initBrains() {
        this.BRAIN = new HashMap<State, ObjectArrayList>(Map.of(State.CORE, this.coreGoals, State.TARGETING, new ObjectArrayList(List.of(new AttackEnemyGoal(this.chr), this.huntingGoal)), State.ATTACKING, new ObjectArrayList(), State.USING_CHEST, new ObjectArrayList(List.of(new UseChestGoal(this.chr, true, true))), State.CRAFTING, new ObjectArrayList(List.of(this.craftTask)), State.MINING, new ObjectArrayList(List.of(this.mineTask, this.randomStrollGoal)), State.BUILDING, new ObjectArrayList(List.of(this.buildTask)), State.FARMING, new ObjectArrayList(List.of(this.farmTask)), State.FISHING, new ObjectArrayList(List.of(this.fishTask)), State.IDLE, new ObjectArrayList(List.of(this.lookAtPlayerGoal, this.lookAtEntityGoal, this.lookAroundGoal, this.randomStrollGoal))));
        this.BABY_BRAIN = this.BRAIN;
        this.currentBrain = this.chr.m_6162_() ? this.BABY_BRAIN : this.BRAIN;
    }

    public void initGoals() {
        this.craftTask = new CraftingTask(this.chr);
        this.mineTask = new MineTask(this.chr, Blocks.f_49999_.m_5456_(), true);
        this.buildTask = new BuildTask(this.chr);
        this.farmTask = new FarmTask(this.chr, (TagKey<Item>)AbstractCharacter.PLANTABLES, this.chr instanceof PlayerDescendant ? RoamersMod.CONFIG.descendantFarmingRange : RoamersMod.CONFIG.farmingRange);
        this.fishTask = new FishTask(this.chr, !this.chr.canFishTreasures());
        this.huntingGoal = new HuntingGoal((AbstractCharacter)this.chr, AbstractCharacter.HUNTABLES, false);
        this.doorGoal = new OpenDoorGoal((Mob)this.chr, true){

            public boolean m_8036_() {
                return !this.f_25189_.f_20911_ && super.m_8036_();
            }

            protected void m_25195_(boolean open) {
                BlockState blockstate;
                if (this.f_25191_ && !this.f_25189_.f_20911_ && (blockstate = this.f_25189_.f_19853_.m_8055_(this.f_25190_)).m_60734_() instanceof DoorBlock) {
                    ((DoorBlock)blockstate.m_60734_()).m_153165_((Entity)this.f_25189_, this.f_25189_.f_19853_, blockstate, this.f_25190_, open);
                    this.f_25189_.m_6674_(InteractionHand.MAIN_HAND);
                }
            }
        };
        this.lookAtPlayerGoal = new LookAtPlayerGoal((Mob)this.chr, Player.class, 8.0f);
        this.lookAtEntityGoal = new LookAtPlayerGoal((Mob)this.chr, PathfinderMob.class, 6.0f);
        this.lookAroundGoal = new RandomLookAroundGoal((Mob)this.chr);
        this.randomStrollGoal = new WaterAvoidingRandomStrollGoal((PathfinderMob)this.chr, 0.85);
        this.playGoal = new BabyPlayTask(this.chr);
        this.coreGoals = new ObjectArrayList(List.of(new PickUpItemGoal(this.chr, 0.9), new FloatGoal((Mob)this.chr), new SleepGoal(this.chr), this.doorGoal));
    }

    public void postInit() {
        this.addGoalsToSelector(this.currentBrain, this.targetState, null, 0);
        this.addGoalsToSelector(this.currentBrain, this.coreState, null, 0);
        this.addGoalsToSelector(this.currentBrain, State.IDLE, null, 0);
        this.checkLand = false;
    }

    public void tickAI() {
        if (--this.goalChecker <= 0) {
            this.chr.f_19853_.m_46473_().m_6180_("checkTasks");
            this.checkTasks();
            this.chr.f_19853_.m_46473_().m_7238_();
            this.reassessTasks();
            this.chr.f_19853_.m_46473_().m_6180_("reassessGoals");
            this.reassessGoals();
            this.chr.f_19853_.m_46473_().m_7238_();
            this.goalChecker = this.getGoalTime();
        }
    }

    public boolean isGoalDisabled(Goal goal) {
        return this.disabledFlags.stream().anyMatch(flag -> goal.m_7684_().contains(flag));
    }

    public void terminateTasks() {
        this.stopGoal(this.craftTask);
        this.stopGoal(this.mineTask);
        this.stopGoal(this.buildTask);
        this.stopGoal(this.farmTask);
        this.stopGoal(this.fishTask);
        this.stopGoal(this.playGoal);
    }

    public void defaultState() {
        this.switchCurrentState(State.IDLE);
    }

    public void saveTasks() {
        this.checkLand = false;
        if (this.buildTask != null && this.buildTask.isNBTStructure() && this.buildTask.structureStart != null) {
            this.chr.structurePos = this.buildTask.structureStart;
            this.chr.structureRot = this.buildTask.structureRot;
        }
    }

    public void reassessGoals() {
        this.addGoalsToSelector(this.currentBrain, this.targetState, null, 0);
        this.addGoalsToSelector(this.currentBrain, this.coreState, null, 0);
        this.addGoalsToSelector(this.currentBrain, this.currentState, this.lastState, 0);
    }

    public void reassessTasks() {
        if (this.chr.m_5912_()) {
            this.switchCurrentState(State.ATTACKING);
            this.terminateTasks();
        }
        if (this.chr.isDepressed()) {
            this.defaultState();
        }
        if (this.chr.m_5803_()) {
            this.defaultState();
            this.stopAllGoals();
        }
    }

    public void checkTasks() {
        if (this.chr.hasFullInventory() && !(this.chr instanceof BanditEntity)) {
            this.switchCurrentState(State.USING_CHEST);
            return;
        }
        if (this.checkFishing()) {
            this.switchCurrentState(State.FISHING);
            return;
        }
        if (this.checkFarming()) {
            this.switchCurrentState(State.FARMING);
            return;
        }
        State state = State.IDLE;
        if (this.checkBuilding()) {
            boolean flag = this.buildTask.hasBuildingItems();
            if (flag || this.buildTask.checkBuilding()) {
                state = State.BUILDING;
            }
            if (flag) {
                this.switchCurrentState(state);
                return;
            }
        }
        if (this.checkCrafting()) {
            state = State.CRAFTING;
        } else if (this.checkMining()) {
            state = State.MINING;
        }
        this.switchCurrentState(state);
    }

    public boolean checkFishing() {
        return this.chr.canFish() && this.chr.canContinueToFish();
    }

    public boolean checkMining() {
        if (this.chr.canContinueToMine()) {
            if (!this.checkLand) {
                this.reassessMineTask(new MineTask(this.chr, true, true));
                return true;
            }
            Block buildingBlock = this.chr.getWantedBuildingBlock();
            if (buildingBlock != null) {
                Ingredient ingredient = this.chr.getCraftingManager().getNeededIngredient(buildingBlock.m_5456_());
                MineTask newMineTask = this.chr.canCraft() && ingredient != null ? new MineTask(this.chr, ingredient, true) : new MineTask(this.chr, buildingBlock.m_5456_(), true);
                if (!newMineTask.testInventory()) {
                    this.reassessMineTask(newMineTask);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean checkBuilding() {
        if (this.chr.canBuild() && this.buildTask != null) {
            this.buildTask.update();
            PlayerLike.BuilderGoal builderGoal = this.chr.getBuildingGoal();
            if (this.chr.canContinueToBuild() && builderGoal != PlayerLike.BuilderGoal.NONE) {
                if (builderGoal == PlayerLike.BuilderGoal.CAMPFIRE || builderGoal == PlayerLike.BuilderGoal.CRAFTING_TABLE) {
                    return true;
                }
                if (builderGoal == PlayerLike.BuilderGoal.HUT) {
                    return this.checkLand;
                }
            }
        }
        return false;
    }

    public boolean checkFarming() {
        return this.chr.canFarm() && this.chr.canContinueToFarm() && this.farmTask.shouldUse();
    }

    public boolean checkCrafting() {
        if (this.chr.canCraft() && this.chr.getCraftingManager() != null && this.chr.wantsToCraftItem != null) {
            Item item = this.chr.wantsToCraftItem;
            return !this.chr.hasFullInventory() && !this.chr.getCraftingManager().canCraftInInventory(item) && CraftingTask.canContinueCrafting(this.chr);
        }
        return false;
    }

    public int getGoalTime() {
        return 80;
    }

    public void switchCurrentState(State state) {
        this.lastState = this.currentState;
        this.currentState = state;
    }

    public void addGoalToBrain(Map<State, ObjectArrayList<Goal>> brain, Goal goal, State state) {
        if (goal != null && !brain.get((Object)state).contains((Object)goal)) {
            ObjectArrayList keys = new ObjectArrayList((ObjectList)this.BRAIN.get((Object)state));
            keys.add((Object)goal);
            brain.put(state, (ObjectArrayList<Goal>)keys);
        }
    }

    public void reassessMineTask(MineTask mineTask) {
        if (this.mineTask != mineTask) {
            this.stopGoal(this.mineTask);
            ObjectArrayList miningGoals = new ObjectArrayList((ObjectList)this.currentBrain.get((Object)State.MINING));
            miningGoals.remove((Object)this.mineTask);
            this.mineTask = mineTask;
            miningGoals.add(0, (Object)this.mineTask);
            this.currentBrain.put(State.MINING, (ObjectArrayList<Goal>)miningGoals);
        }
    }

    public void overrideBrainState(Map<State, ObjectArrayList<Goal>> brain, State state, List<Goal> goals) {
        if (goals != null) {
            brain.put(state, (ObjectArrayList<Goal>)new ObjectArrayList(goals));
        }
    }

    public void addGoalsToSelector(Map<State, ObjectArrayList<Goal>> brain, State state, @Nullable State lastState, int startIndex) {
        if (!this.chr.f_19853_.f_46443_) {
            List goals;
            if (this.chr.m_5803_()) {
                return;
            }
            if (lastState != null && !brain.get((Object)lastState).isEmpty()) {
                for (Goal goal : brain.get((Object)lastState)) {
                    if (state == lastState && goal instanceof Task && ((Task)goal).isInUse) continue;
                    this.stopGoal(goal);
                }
            }
            if ((goals = (List)brain.get((Object)state)).isEmpty()) {
                return;
            }
            for (int i = 0; i < goals.size(); ++i) {
                this.addGoalToSelector((Goal)goals.get(i), startIndex + i);
            }
        }
    }

    public void addGoalToSelector(Goal goal, int index) {
        if (!this.chr.f_19853_.f_46443_) {
            if (this.chr.m_5803_()) {
                return;
            }
            if (this.isGoalDisabled(goal)) {
                return;
            }
            if (goal instanceof Task) {
                if (this.chr.taskSelector.m_25386_().anyMatch(goal1 -> goal1.m_26015_() == goal)) {
                    return;
                }
                this.chr.taskSelector.m_25363_(goal);
                this.chr.taskSelector.m_25352_(index, goal);
            } else if (goal instanceof TargetGoal) {
                this.chr.f_21346_.m_25363_(goal);
                this.chr.f_21346_.m_25352_(index, goal);
            } else {
                this.chr.f_21345_.m_25363_(goal);
                this.chr.f_21345_.m_25352_(index, goal);
            }
        }
    }

    public void stopGoal(Goal goal) {
        if (!this.chr.f_19853_.f_46443_ && goal != null) {
            if (goal instanceof Task) {
                this.chr.taskSelector.m_25363_(goal);
            } else if (goal instanceof TargetGoal) {
                this.chr.f_21346_.m_25363_(goal);
            } else {
                this.chr.f_21345_.m_25363_(goal);
            }
        }
    }

    public void stopAllGoals() {
        if (this.currentBrain != null) {
            for (List list : this.currentBrain.values()) {
                for (Goal goal : list) {
                    this.stopGoal(goal);
                }
            }
        }
        this.defaultState();
    }

    public void refreshBrain() {
        if (this.currentBrain != null) {
            this.stopAllGoals();
            this.currentBrain.clear();
            this.initAI();
        }
    }

    public void setDisabledFlags(Set<Goal.Flag> flags) {
        this.disabledFlags = flags;
    }

    public void disableFlag(Goal.Flag flag) {
        this.disabledFlags.add(flag);
    }

    public void enableFlag(Goal.Flag flag) {
        this.disabledFlags.remove(flag);
    }

    public static enum State {
        CORE,
        TARGETING,
        ATTACKING,
        USING_CHEST,
        CRAFTING,
        MINING,
        BUILDING,
        FARMING,
        FISHING,
        IDLE;

    }
}

