/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity.ai.goals;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.caitie.roamers.RoamersMod;
import net.caitie.roamers.entity.AbstractCharacter;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.caitie.roamers.entity.RoamerEntity;
import net.caitie.roamers.entity.ai.TaskUtils;
import net.caitie.roamers.entity.ai.goals.ControlledTickGoal;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public class PlayerLikeBreedGoal
extends ControlledTickGoal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
    private final double speed;
    protected final PlayerLikeCharacter chr;
    protected PlayerLikeCharacter partner;
    protected PlayerLikeCharacter mother;
    protected PlayerLikeCharacter father;
    private int loveTime;
    private int seduceTime;
    private ItemStack gift;

    public PlayerLikeBreedGoal(PlayerLikeCharacter chr, double speed) {
        super(chr);
        this.chr = chr;
        this.speed = speed;
        if (this.chr.isMale()) {
            this.father = this.chr;
        } else {
            this.mother = this.chr;
        }
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!RoamersMod.CONFIG.allowBreeding) {
            return false;
        }
        if (this.chr.isInBadMood()) {
            return false;
        }
        if (this.chr.m_146764_() == 0 && this.shouldBreed((ServerLevel)this.chr.f_19853_)) {
            this.partner = this.findPartner();
            if (this.partner != null) {
                if (this.partner.isMale()) {
                    this.father = this.partner;
                } else {
                    this.mother = this.partner;
                }
                return this.father.hasFood();
            }
        }
        return false;
    }

    public boolean m_8045_() {
        return !this.chr.isInBadMood() && !this.partner.isInBadMood() && this.partner.m_6084_() && this.partner.m_146764_() == 0 && this.loveTime < 60;
    }

    public boolean m_6767_() {
        return false;
    }

    @Override
    public void m_8041_() {
        this.partner = null;
        this.loveTime = 0;
        this.seduceTime = 0;
        this.gift = null;
    }

    @Override
    public void doTick() {
        if (this.mother != null) {
            this.mother.m_21573_().m_26573_();
            this.mother.m_21563_().m_148051_((Entity)this.father);
            TaskUtils.lookAndMoveTo((PathfinderMob)this.father, (Entity)this.mother, this.speed);
            if (this.mother.isInLove()) {
                ++this.loveTime;
                if (this.loveTime >= this.m_183277_(60) && this.father.m_20280_((Entity)this.mother) <= 9.0) {
                    this.makeBebe();
                    this.mother.setMood(AbstractCharacter.Mood.HAPPY, 800);
                    this.father.setMood(AbstractCharacter.Mood.HAPPY, 800);
                }
            } else if (this.gift == null) {
                this.giveOffering();
                this.mother.setMood(AbstractCharacter.Mood.IN_LOVE, 800);
                this.mother.getAI().defaultState();
            }
        }
    }

    @Override
    public void doUpdateTick() {
    }

    protected void makeBebe() {
        AgeableMob baby = this.chr.m_142606_((ServerLevel)this.chr.f_19853_, this.partner);
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((Mob)this.chr, (Mob)this.partner, baby);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        baby = event.getChild();
        if (cancelled) {
            this.chr.m_146762_(RoamersMod.CONFIG.breedCooldownTicks >= 0 ? RoamersMod.CONFIG.breedCooldownTicks : 45000);
            this.partner.m_146762_(RoamersMod.CONFIG.breedCooldownTicks >= 0 ? RoamersMod.CONFIG.breedCooldownTicks : 25000);
            return;
        }
        if (baby != null) {
            this.father.m_146762_(RoamersMod.CONFIG.breedCooldownTicks >= 0 ? RoamersMod.CONFIG.breedCooldownTicks : 45000);
            this.mother.m_146762_(RoamersMod.CONFIG.breedCooldownTicks >= 0 ? RoamersMod.CONFIG.breedCooldownTicks : 45000);
            baby.m_146762_(RoamersMod.CONFIG.babyAgeTicks < 0 ? RoamersMod.CONFIG.babyAgeTicks : -72000);
            baby.m_7678_(this.mother.m_20185_(), this.mother.m_20186_(), this.mother.m_20189_(), 0.0f, 0.0f);
            if (baby instanceof RoamerEntity) {
                ((RoamerEntity)baby).isAdopted = true;
            }
            ((ServerLevel)this.mother.f_19853_).m_47205_((Entity)baby);
            this.mother.f_19853_.m_7605_((Entity)this.mother, (byte)18);
            this.father.f_19853_.m_7605_((Entity)this.mother, (byte)18);
            if (((AbstractCharacter)baby).isMale()) {
                this.father.childrenUUIDs.add(baby.m_142081_());
            } else {
                this.mother.childrenUUIDs.add(baby.m_142081_());
            }
        }
    }

    protected PlayerLikeCharacter findPartner() {
        List list = this.chr.f_19853_.m_45971_(PlayerLikeCharacter.class, PARTNER_TARGETING, (LivingEntity)this.chr, this.chr.m_142469_().m_82400_(10.0));
        double d0 = Double.MAX_VALUE;
        AbstractCharacter lover = null;
        for (PlayerLikeCharacter lover1 : list) {
            if (lover1.m_146764_() != 0 || !this.chr.canBreedWith(lover1) || !lover1.canBreedWith(this.chr) || !(this.chr.m_20280_((Entity)lover1) < d0)) continue;
            lover = lover1;
            d0 = this.chr.m_20280_((Entity)lover1);
        }
        if (lover != null && lover.isMale()) {
            lover.setMood(AbstractCharacter.Mood.IN_LOVE, 800);
            ((PlayerLikeCharacter)lover).getAI().defaultState();
        } else if (lover != null) {
            this.chr.setMood(AbstractCharacter.Mood.IN_LOVE, 800);
            this.chr.getAI().defaultState();
        }
        return lover;
    }

    public void giveOffering() {
        this.father.m_21563_().m_148051_((Entity)this.mother);
        this.father.m_21573_().m_5624_((Entity)this.mother, this.speed);
        ItemStack offering = this.father.getTaggedItemsInInventory((TagKey<Item>)PlayerLikeCharacter.EDIBLES);
        if (offering != null && this.father.m_20280_((Entity)this.mother) < 9.0) {
            if (offering.m_41613_() <= 12) {
                this.gift = offering;
            } else {
                this.gift = new ItemStack((ItemLike)offering.m_41720_(), 12);
                if (this.mother.getInventory().m_19183_(this.gift)) {
                    offering.m_41774_(12);
                }
            }
            if (this.mother.getInventory().m_19183_(this.gift)) {
                this.father.tossItem(this.gift, (Entity)this.mother);
                this.father.getInventory().m_19170_(this.gift.m_41720_(), this.gift.m_41613_());
            }
        }
    }

    protected boolean shouldBreed(ServerLevel slevel) {
        if (this.chr.isInLove() && this.chr.m_146764_() == 0) {
            return true;
        }
        return Mth.m_14072_((Random)slevel.f_46441_, (int)0, (int)100000) < 20;
    }
}

