/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity.ai.goals;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.caitie.roamers.RoamersMod;
import net.caitie.roamers.entity.AbstractCharacter;
import net.caitie.roamers.entity.PlayerDescendant;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class UseChestGoal
extends MoveToBlockGoal {
    protected final PlayerLikeCharacter plike;
    protected final boolean take;
    protected final boolean store;
    protected ChestBlockEntity chestEntity;
    protected int slot;
    protected ItemStack storeItem;
    protected int useTicks;
    protected boolean isUsing;
    protected Interact interact;
    public boolean isInUse;

    public UseChestGoal(PlayerLikeCharacter plike, boolean takeItems, boolean storeItems) {
        super((PathfinderMob)plike, 0.9, 16, 4);
        this.plike = plike;
        this.take = takeItems;
        this.store = storeItems;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return RoamersMod.CONFIG.allowChestUse && this.shouldUse() && super.m_8036_();
    }

    public boolean m_8045_() {
        switch (this.interact) {
            case TAKE: {
                return super.m_8045_() && this.slot > -1 && this.useTicks < 80;
            }
            case STORE: {
                if (this.storeItem != null) {
                    return super.m_8045_() && !this.storeItem.m_41619_() && this.useTicks < 80;
                }
                return super.m_8045_() && this.useTicks < 80;
            }
        }
        return super.m_8045_() && this.useTicks < 80;
    }

    public void m_8056_() {
        super.m_8056_();
        this.isInUse = true;
        this.useTicks = 0;
        this.isUsing = false;
        this.storeItem = null;
    }

    public void m_8037_() {
        super.m_8037_();
        switch (this.interact) {
            case TAKE: {
                if (this.isUsing && this.plike.f_19853_.m_7702_(this.f_25602_) instanceof ChestBlockEntity) {
                    ItemStack stack;
                    this.chestEntity = (ChestBlockEntity)this.plike.f_19853_.m_7702_(this.f_25602_);
                    this.plike.m_21563_().m_24946_((double)this.f_25602_.m_123341_(), (double)this.f_25602_.m_123342_(), (double)this.f_25602_.m_123343_());
                    this.slot = this.findItems();
                    ++this.useTicks;
                    if (this.useTicks >= 15 && this.slot > -1 && !(stack = this.chestEntity.m_8020_(this.slot)).m_41619_()) {
                        this.plike.getInventory().m_19173_(this.takeFromChest(this.chestEntity, this.slot));
                        this.useTicks = 0;
                    }
                    return;
                }
                BlockState bstate = this.plike.f_19853_.m_8055_(this.f_25602_);
                if (this.m_25625_() && bstate.m_60734_() instanceof ChestBlock) {
                    this.plike.f_19853_.m_7696_(this.f_25602_, bstate.m_60734_(), 1, 1);
                    this.f_25598_.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.chest.open")), 1.0f, 1.0f);
                    this.isUsing = true;
                }
                return;
            }
            case STORE: {
                if (this.isUsing && this.plike.f_19853_.m_7702_(this.f_25602_) instanceof ChestBlockEntity) {
                    this.chestEntity = (ChestBlockEntity)this.plike.f_19853_.m_7702_(this.f_25602_);
                    this.plike.m_21563_().m_24946_((double)this.f_25602_.m_123341_(), (double)this.f_25602_.m_123342_(), (double)this.f_25602_.m_123343_());
                    ++this.useTicks;
                    if (this.useTicks >= 15) {
                        this.storeItem = this.findItemsToStore().m_41777_();
                        if (!this.storeItem.m_41619_()) {
                            ItemStack retval = this.storeInChest(this.chestEntity, this.storeItem);
                            this.plike.getInventory().m_19170_(this.storeItem.m_41720_(), this.storeItem.m_41613_());
                            this.storeItem = null;
                            this.useTicks = 0;
                        }
                    }
                    return;
                }
                BlockState bstate1 = this.plike.f_19853_.m_8055_(this.f_25602_);
                if (this.m_25625_() && bstate1.m_60734_() instanceof ChestBlock) {
                    this.plike.f_19853_.m_7696_(this.f_25602_, bstate1.m_60734_(), 1, 1);
                    this.f_25598_.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.chest.open")), 1.0f, 1.0f);
                    this.isUsing = true;
                }
                return;
            }
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.isInUse = false;
        if (this.f_25598_.f_19853_.m_8055_(this.f_25602_).m_60734_() instanceof ChestBlock && this.isUsing) {
            this.plike.f_19853_.m_7696_(this.f_25602_, this.plike.f_19853_.m_8055_(this.f_25602_).m_60734_(), 1, 0);
            this.f_25598_.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.chest.close")), 1.0f, 1.0f);
        }
        this.useTicks = 0;
        this.isUsing = false;
        this.storeItem = null;
        this.chestEntity = null;
    }

    public boolean m_6465_(LevelReader lreader, BlockPos bpos) {
        return lreader.m_8055_(bpos).m_60734_() instanceof ChestBlock;
    }

    public double m_8052_() {
        return 2.0;
    }

    public ItemStack findItemsToStore() {
        for (int i = 0; i < this.plike.getInventory().m_6643_(); ++i) {
            ItemStack itemstack = this.plike.getInventory().m_8020_(i);
            if (itemstack.m_41619_() || this.plike.isTool(itemstack) || itemstack.m_41720_() instanceof ArmorItem || this.plike instanceof PlayerDescendant && itemstack.m_204117_(AbstractCharacter.FOODS)) continue;
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    protected ItemStack takeFromChest(ChestBlockEntity chest, int i) {
        return chest.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).map(handler -> {
            ItemStack stack = handler.getStackInSlot(i);
            if (!stack.m_41619_()) {
                return handler.extractItem(i, stack.m_41613_(), false);
            }
            return ItemStack.f_41583_;
        }).orElse(ItemStack.f_41583_);
    }

    protected ItemStack storeInChest(ChestBlockEntity chest, ItemStack item) {
        return chest.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).map(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (!stack.m_41619_() && (!stack.m_150930_(item.m_41720_()) || !stack.m_41753_() || !item.m_41753_() || item.m_41613_() + stack.m_41613_() > stack.m_41741_())) continue;
                return handler.insertItem(i, item, false);
            }
            return ItemStack.f_41583_;
        }).orElse(ItemStack.f_41583_);
    }

    protected int searchForItemsToTake(ChestBlockEntity chest, @Nullable TagKey items, @Nullable Item item) {
        if (!chest.m_7983_()) {
            for (int i = 0; i < chest.m_6643_(); ++i) {
                ItemStack stack = chest.m_8020_(i);
                if (item != null && stack.m_150930_(item)) {
                    return i;
                }
                if (items != null && stack.m_204117_(items)) {
                    return i;
                }
                if (item != null || items != null || !this.plike.m_7243_(stack)) continue;
                return i;
            }
        }
        return -1;
    }

    protected boolean m_25626_() {
        if (this.plike.getHomePos() != null) {
            int i = 16;
            int j = 4;
            BlockPos blockpos = this.plike.getHomePos();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            int k = this.f_25603_;
            while (k <= j) {
                for (int l = 0; l < i; ++l) {
                    int i1 = 0;
                    while (i1 <= l) {
                        int j1;
                        int n = j1 = i1 < l && i1 > -l ? l : 0;
                        while (j1 <= l) {
                            blockpos$mutableblockpos.m_122154_((Vec3i)blockpos, i1, k - 1, j1);
                            if (this.m_6465_((LevelReader)this.plike.f_19853_, (BlockPos)blockpos$mutableblockpos)) {
                                this.f_25602_ = blockpos$mutableblockpos;
                                return true;
                            }
                            j1 = j1 > 0 ? -j1 : 1 - j1;
                        }
                        i1 = i1 > 0 ? -i1 : 1 - i1;
                    }
                }
                k = k > 0 ? -k : 1 - k;
            }
        }
        return super.m_25626_();
    }

    public int findItems() {
        if (this.plike.isHungry()) {
            return this.searchForItemsToTake(this.chestEntity, AbstractCharacter.FOODS, null);
        }
        if (this.plike.wantsToCraftItem != null) {
            return this.searchForItemsToTake(this.chestEntity, null, this.plike.wantsToCraftItem);
        }
        if (this.plike.getWantedBuildingBlock() != null) {
            return this.searchForItemsToTake(this.chestEntity, null, this.plike.getWantedBuildingBlock().m_5456_());
        }
        return this.searchForItemsToTake(this.chestEntity, null, null);
    }

    protected boolean shouldUse() {
        boolean flag = this.plike.hasFullInventory();
        if (this.take && this.store) {
            if (!flag) {
                if (this.plike.wantsToCraftItem != null && !this.plike.hasItemsInInventory(this.plike.wantsToCraftItem)) {
                    this.interact = Interact.TAKE;
                    return true;
                }
                if (this.plike.getWantedBuildingBlock() != null && !this.plike.hasItemsInInventory(this.plike.getWantedBuildingBlock().m_5456_())) {
                    this.interact = Interact.TAKE;
                    return true;
                }
                if (this.plike.isHungry() && !this.plike.hasTaggedItemsInInventory((TagKey<Item>)AbstractCharacter.FOODS)) {
                    this.interact = Interact.TAKE;
                    return true;
                }
            }
            this.interact = Interact.STORE;
            return flag;
        }
        if (this.take) {
            this.interact = Interact.TAKE;
            return !flag;
        }
        if (this.store) {
            this.interact = Interact.STORE;
            return flag;
        }
        return false;
    }

    public static enum Interact {
        STORE,
        TAKE;

    }
}

