/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity.ai.tasks;

import java.util.EnumSet;
import java.util.List;
import net.caitie.roamers.entity.AbstractCharacter;
import net.caitie.roamers.entity.PlayerDescendant;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.caitie.roamers.entity.ai.TaskUtils;
import net.caitie.roamers.entity.ai.tasks.Task;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BabyPlayTask
extends Task {
    protected final PlayerLikeCharacter baby;
    protected BlockPos bed;
    public List<PathfinderMob> friends;
    public PathfinderMob currentPlayMate;
    public boolean isChasing;
    protected int playTimer;
    public int playCooldown;
    private int verticalSearchStart = 0;
    private PlayType playType;

    public BabyPlayTask(PlayerLikeCharacter baby) {
        super(baby);
        this.baby = baby;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    @Override
    public boolean shouldStart() {
        block9: {
            boolean bl;
            block11: {
                block10: {
                    if (!this.baby.m_6162_()) break block9;
                    if (--this.playCooldown > 0) {
                        return false;
                    }
                    if (this.baby instanceof PlayerDescendant && ((PlayerDescendant)this.baby).isWorking()) {
                        return false;
                    }
                    this.playType = PlayType.values()[this.baby.m_21187_().nextInt(3)];
                    if (this.baby.getTrait() == AbstractCharacter.Traits.GRUMPY || !this.baby.f_19853_.m_46461_() || this.baby.isHungry() || this.baby.isInBadMood()) break block10;
                    switch (this.playType) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case JUMP_ON_BED: {
                            if (this.findBed()) {
                                break;
                            }
                            break block10;
                        }
                        case TAG: {
                            if (this.findFriendToPlayWith()) {
                                break;
                            }
                            break block10;
                        }
                        case SNOWBALL_FIGHT: {
                            if (this.baby.getRace() != AbstractCharacter.Race.ARTIC || !this.findFriendToPlayWith()) break block10;
                        }
                    }
                    bl = true;
                    break block11;
                }
                bl = false;
            }
            return bl;
        }
        return false;
    }

    @Override
    public boolean canContinue() {
        boolean bl;
        block8: {
            block7: {
                if (this.playCooldown > 0) {
                    return false;
                }
                if (this.baby instanceof PlayerDescendant && ((PlayerDescendant)this.baby).isWorking()) {
                    return false;
                }
                if (this.baby.isInBadMood() || !this.baby.m_6162_() || !this.baby.f_19853_.m_46461_() || this.baby.isHungry()) break block7;
                switch (this.playType) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case JUMP_ON_BED: {
                        if (this.bed != null && this.baby.f_19853_.m_8055_(this.bed).m_60734_() instanceof BedBlock) {
                            break;
                        }
                        break block7;
                    }
                    case TAG: 
                    case SNOWBALL_FIGHT: {
                        if (this.friends == null || this.friends.isEmpty()) break block7;
                    }
                }
                bl = true;
                break block8;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public void m_8056_() {
        this.playTimer = 0;
        this.currentPlayMate = null;
        this.baby.setCurrentActivity(PlayerLikeCharacter.Activity.IDLE);
        this.playTimer = this.m_183277_(30 + this.baby.m_21187_().nextInt(10));
        super.m_8056_();
    }

    @Override
    public void doUpdateTick() {
        if (this.playCooldown <= 0) {
            switch (this.playType) {
                case JUMP_ON_BED: {
                    if (this.bed == null || this.playTimer > 0) break;
                    if (this.baby.f_19853_.m_8055_(this.baby.m_142538_()).m_60734_() instanceof BedBlock) {
                        this.baby.jump();
                        this.playTimer = 15;
                        break;
                    }
                    this.baby.m_21573_().m_26519_((double)this.bed.m_123341_(), (double)this.bed.m_123342_(), (double)this.bed.m_123343_(), 0.9);
                    break;
                }
                case TAG: {
                    this.findFriendToPlayWith();
                    if (this.friends == null || this.friends.isEmpty()) break;
                    if (this.currentPlayMate == null || !this.currentPlayMate.m_6162_() || !this.currentPlayMate.m_6084_() || this.currentPlayMate.m_5803_() || this.currentPlayMate instanceof PlayerLikeCharacter && ((PlayerLikeCharacter)this.currentPlayMate).getAI().playGoal.playCooldown > 0) {
                        if (this.currentPlayMate != null && !this.currentPlayMate.m_6084_()) {
                            this.baby.setMood(AbstractCharacter.Mood.SAD, 3000);
                        }
                        this.friends.remove(this.currentPlayMate);
                        if (this.friends.isEmpty()) break;
                        this.currentPlayMate = this.friends.get(this.baby.m_21187_().nextInt(this.friends.size()));
                        break;
                    }
                    if (this.currentPlayMate instanceof PlayerLikeCharacter && ((PlayerLikeCharacter)this.currentPlayMate).getAI() != null && ((PlayerLikeCharacter)this.currentPlayMate).getAI().playGoal != null && ((PlayerLikeCharacter)this.currentPlayMate).getAI().playGoal.playCooldown > 0) {
                        this.currentPlayMate = null;
                        return;
                    }
                    if (this.playTimer > 0) break;
                    this.baby.m_21573_().m_26573_();
                    this.isChasing = this.isChasing();
                    if (this.isChasing) {
                        TaskUtils.moveTo((PathfinderMob)this.baby, (Entity)this.currentPlayMate, 0.9);
                        if (this.currentPlayMate instanceof Villager) {
                            Vec3 pos = DefaultRandomPos.m_148407_((PathfinderMob)this.baby, (int)8, (int)5, (Vec3)this.baby.m_20182_());
                            TaskUtils.moveTo(this.currentPlayMate, pos != null ? pos : this.baby.m_20182_().m_82548_().m_82541_().m_82490_(-0.5), 0.55);
                        }
                    } else {
                        Vec3 pos = DefaultRandomPos.m_148407_((PathfinderMob)this.baby, (int)8, (int)5, (Vec3)this.currentPlayMate.m_20182_());
                        TaskUtils.moveTo((PathfinderMob)this.baby, pos != null ? pos : this.currentPlayMate.m_20182_().m_82548_().m_82541_().m_82490_(-0.5), 0.9);
                        if (this.currentPlayMate instanceof Villager) {
                            TaskUtils.moveTo(this.currentPlayMate, (Entity)this.baby, 0.55);
                        }
                    }
                    this.playTimer = this.m_183277_(30 + this.baby.m_21187_().nextInt(10));
                    break;
                }
                case SNOWBALL_FIGHT: {
                    this.findFriendToPlayWith();
                    if (this.friends == null || this.friends.isEmpty()) break;
                    if (this.currentPlayMate == null || !this.currentPlayMate.m_6162_() || !this.currentPlayMate.m_6084_() || this.currentPlayMate.m_5803_() || this.currentPlayMate instanceof PlayerLikeCharacter && ((PlayerLikeCharacter)this.currentPlayMate).getAI().playGoal.playCooldown > 0) {
                        if (this.currentPlayMate != null && !this.currentPlayMate.m_6084_()) {
                            this.baby.setMood(AbstractCharacter.Mood.SAD, 3000);
                        }
                        this.friends.remove(this.currentPlayMate);
                        if (this.friends.isEmpty()) break;
                        this.currentPlayMate = this.friends.get(this.baby.m_21187_().nextInt(this.friends.size()));
                        if (!(this.currentPlayMate instanceof Villager)) break;
                        this.currentPlayMate = null;
                        break;
                    }
                    if (this.playTimer > 0) break;
                    if (this.currentPlayMate.m_20238_(this.baby.m_20182_()) <= 5.5) {
                        TaskUtils.moveTo((PathfinderMob)this.baby, this.currentPlayMate.m_20182_().m_82548_().m_82541_().m_82490_(-0.6), 0.9);
                    } else {
                        TaskUtils.moveTo((PathfinderMob)this.baby, (Entity)this.currentPlayMate, 0.9);
                        this.baby.m_21573_().m_26573_();
                    }
                    if (this.baby.hasItemsInInventory(Items.f_42452_)) {
                        if (this.baby.m_21573_().m_26571_()) {
                            this.throwSnowball((LivingEntity)this.currentPlayMate);
                        }
                    } else {
                        this.getSnowball();
                        this.playCooldown = this.m_183277_(60 + this.baby.m_21187_().nextInt(10));
                        return;
                    }
                    this.playTimer = this.m_183277_(30 + this.baby.m_21187_().nextInt(10));
                }
            }
        }
    }

    @Override
    public void doTick() {
        if (this.baby.m_21187_().nextInt(1000) == 0) {
            this.playCooldown = 300;
        }
        if (this.playTimer > 0) {
            --this.playTimer;
        }
        if (this.currentPlayMate != null) {
            TaskUtils.lookAt((PathfinderMob)this.baby, (Entity)this.currentPlayMate);
            TaskUtils.lookAt(this.currentPlayMate, (Entity)this.baby);
        }
    }

    public boolean isChasing() {
        return this.baby.m_20238_(this.currentPlayMate.m_20182_()) > 1.0;
    }

    @Override
    public void m_8041_() {
        this.bed = null;
        this.verticalSearchStart = 0;
        this.friends = null;
        this.currentPlayMate = null;
        this.playTimer = 0;
        super.m_8041_();
    }

    protected boolean findBed() {
        int i = 12;
        int j = 3;
        BlockPos bpos = this.baby.m_142538_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int k = this.verticalSearchStart;
        while (k <= j) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        mutable.m_122154_((Vec3i)bpos, i1, k - 1, j1);
                        if (this.baby.f_19853_.m_8055_((BlockPos)mutable).m_60734_() instanceof BedBlock && this.baby.f_19853_.m_46859_(mutable.m_7494_())) {
                            this.bed = mutable;
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return false;
    }

    protected boolean findFriendToPlayWith() {
        List friends = this.baby.f_19853_.m_6443_(PathfinderMob.class, this.baby.m_142469_().m_82400_(10.0), mob -> !mob.m_7306_((Entity)this.baby) && mob.m_6162_() && (mob instanceof PlayerLikeCharacter && ((PlayerLikeCharacter)mob).getTrait() != AbstractCharacter.Traits.GRUMPY && !((PlayerLikeCharacter)mob).isInBadMood() && ((PlayerLikeCharacter)mob).getCurrentActivity() == PlayerLikeCharacter.Activity.IDLE || mob instanceof Villager));
        if (!friends.isEmpty()) {
            this.friends = friends;
            return true;
        }
        return false;
    }

    protected void getSnowball() {
        BlockState bstate = this.baby.f_19853_.m_8055_(this.baby.m_142538_());
        if (bstate.m_60713_(Blocks.f_50125_)) {
            TaskUtils.mineBlock(this.baby, this.baby.m_142538_(), bstate, true);
        }
    }

    protected void throwSnowball(LivingEntity entity) {
        ItemStack snowball = this.baby.getItemsInInventory(Items.f_42452_);
        if (snowball != null && !snowball.m_41619_()) {
            this.baby.m_21008_(InteractionHand.MAIN_HAND, snowball);
            Snowball thrown = new Snowball(this.baby.f_19853_, (LivingEntity)this.baby);
            double d0 = entity.m_20188_() - 1.0;
            double d1 = entity.m_20185_() - this.baby.m_20185_();
            double d2 = d0 - thrown.m_20186_();
            double d3 = entity.m_20189_() - this.baby.m_20189_();
            double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
            thrown.m_6686_(d1, d2 + d4, d3, 1.0f, 8.0f);
            this.baby.m_5496_(SoundEvents.f_12473_, 1.0f, 0.4f / this.baby.m_21187_().nextFloat() * 0.4f + 0.8f);
            this.baby.m_6674_(InteractionHand.MAIN_HAND);
            this.baby.f_19853_.m_7967_((Entity)thrown);
            snowball.m_41774_(1);
        }
    }

    public static enum PlayType {
        JUMP_ON_BED,
        TAG,
        SNOWBALL_FIGHT;

    }
}

