/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity.ai.tasks;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.caitie.roamers.RoamersMod;
import net.caitie.roamers.entity.PlayerLike;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.caitie.roamers.entity.ai.TaskUtils;
import net.caitie.roamers.entity.ai.tasks.Task;
import net.caitie.roamers.util.BuilderData;
import net.caitie.roamers.util.BuilderManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class BuildTask
extends Task {
    private final PlayerLikeCharacter builder;
    private BuilderManager buildManager;
    private BuilderData buildData;
    public BlockPos startingBlockPos;
    private BlockState buildingBlock;
    public Map<BlockPos, BlockState> builderMap;
    private BuildType buildType;
    public TreeMap<BlockPos, BlockState> buildingSpace = new TreeMap();
    public ObjectArrayList<BlockPos> builtPositions = new ObjectArrayList();
    private final ObjectArrayList<BlockPos> blacklistedPlacement = new ObjectArrayList();
    private final ObjectArrayList<BlockPos> whitelistedPlacement = new ObjectArrayList();
    private final ObjectArrayList<BlockPos> placedBlocks = new ObjectArrayList();
    private int verticalSearchStart;
    private int pointer = 0;
    public Rotation structureRot;
    public BlockPos structureStart;
    private ListIterator iterator;

    public BuildTask(PlayerLikeCharacter builder) {
        super(builder);
        this.builder = builder;
        this.update();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean hasBuildingItems() {
        if (this.buildingBlock != null) {
            if (this.buildingBlock.m_60713_(Blocks.f_50016_) || this.buildingBlock.m_60713_(Blocks.f_50375_)) {
                return true;
            }
            return this.builder.hasItemsInInventory(this.buildingBlock.m_60734_().m_5456_());
        }
        return false;
    }

    @Override
    public boolean shouldStart() {
        if (!this.builder.canBuild() || !this.builder.canContinueToBuild()) {
            return false;
        }
        if (this.builder.hasFullInventory()) {
            return false;
        }
        this.update();
        if (this.buildType != null) {
            switch (this.buildType) {
                case SINGLE_BLOCK: {
                    if (this.buildingBlock != null && this.hasBuildingItems()) {
                        if (this.startingBlockPos == null) {
                            this.getValidBlockPlacement();
                        }
                        return this.startingBlockPos != null;
                    }
                    return false;
                }
                case NBT_STRUCTURE: {
                    if (this.builderMap != null && !this.builderMap.isEmpty() && this.builder.getHomePos() != null) {
                        this.buildingSpace = this.getValidBuildingPos(this.builder.getHomePos().m_7495_(), this.buildData.getSize(), this.builderMap);
                        if (this.buildingSpace != null && !this.buildingSpace.isEmpty() && this.builtPositions.isEmpty()) {
                            this.builtPositions.addAll(this.buildingSpace.keySet());
                            this.iterator = this.builtPositions.listIterator();
                            this.buildingBlock = this.buildingSpace.get(this.builtPositions.get(0));
                            this.syncBuildingBlock(this.buildingBlock.m_60734_());
                        }
                        return this.buildingSpace != null && this.hasBuildingItems();
                    }
                    return false;
                }
            }
            return this.builder.canBuild();
        }
        return false;
    }

    public boolean m_6767_() {
        return !this.isNBTStructure() || this.builder.shouldSleep();
    }

    public boolean m_183429_() {
        return true;
    }

    @Override
    public boolean canContinue() {
        if (this.builder.canBuild() && this.builder.canContinueToBuild() && !this.builder.m_5912_() && !this.builder.hasFullInventory() && this.hasBuildingItems()) {
            switch (this.buildType) {
                case SINGLE_BLOCK: {
                    return this.buildingBlock != null && !this.blacklistedPlacement.contains((Object)this.startingBlockPos) && this.startingBlockPos != null;
                }
                case NBT_STRUCTURE: {
                    return this.buildingSpace != null;
                }
            }
        }
        return false;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.updateTime = 0;
        this.builder.setCurrentActivity(PlayerLikeCharacter.Activity.BUILDING);
    }

    @Override
    public void doTick() {
        BlockPos bpos;
        if (this.isSingleBlockBuild()) {
            if (this.startingBlockPos != null) {
                TaskUtils.lookAt((PathfinderMob)this.builder, this.startingBlockPos.m_7494_());
            }
        } else if (this.isNBTStructure() && this.builtPositions != null && !this.builtPositions.isEmpty() && (bpos = (BlockPos)this.builtPositions.get(this.pointer)) != null) {
            TaskUtils.lookAt((PathfinderMob)this.builder, bpos.m_7494_());
        }
    }

    public void updateBuilding() {
        this.update();
        if (this.isNBTStructure() && this.builder.getHomePos() != null) {
            this.buildingSpace = this.getValidBuildingPos(this.builder.getHomePos().m_7495_(), this.buildData.getSize(), this.builderMap);
        }
    }

    public boolean checkBuilding() {
        if (this.buildingSpace == null || this.buildingSpace.isEmpty()) {
            this.updateBuilding();
        }
        return this.buildingSpace != null && !this.buildingSpace.isEmpty();
    }

    @Override
    public int getUpdateTime() {
        return 20;
    }

    @Override
    public void doUpdateTick() {
        if (this.builder.miningCooldown <= 0 && this.buildType != null) {
            switch (this.buildType) {
                case SINGLE_BLOCK: {
                    if (this.startingBlockPos == null) {
                        this.getValidBlockPlacement();
                    }
                    if (this.buildingBlock == null || !this.builder.hasItemsInInventory(this.buildingBlock.m_60734_().m_5456_())) break;
                    if (TaskUtils.isInRange(this.builder, this.startingBlockPos)) {
                        this.builder.m_8061_(EquipmentSlot.MAINHAND, this.builder.getItemsInInventory(this.buildingBlock.m_60734_().m_5456_()));
                        if (this.placeBlock()) {
                            if (this.buildingBlock.m_60713_(Blocks.f_50683_) && this.builder.getBuildingGoal() == PlayerLike.BuilderGoal.CAMPFIRE) {
                                this.builder.setHomePos(this.startingBlockPos.m_7494_());
                                this.builder.setBuildingGoal(PlayerLike.BuilderGoal.NONE);
                            } else if (this.buildingBlock.m_60713_(Blocks.f_50091_) && this.builder.getBuildingGoal() == PlayerLike.BuilderGoal.CRAFTING_TABLE) {
                                this.builder.craftingTablePos = this.startingBlockPos.m_7494_();
                                this.builder.setBuildingGoal(PlayerLike.BuilderGoal.NONE);
                            }
                            this.builder.buildingCooldown = 20;
                            this.buildingBlock = null;
                            this.startingBlockPos = null;
                            this.syncBuildingBlock(null);
                            this.builder.setWantedCraftingItem(null);
                            this.updateTime = this.getUpdateTime() * 2;
                            break;
                        }
                        if (this.canPlaceBlock(this.startingBlockPos)) break;
                        TaskUtils.moveTo((PathfinderMob)this.builder, this.startingBlockPos.m_141950_((Vec3i)this.builder.m_142538_()), 0.85);
                        break;
                    }
                    TaskUtils.lookAndMoveTo((PathfinderMob)this.builder, this.startingBlockPos, 0.9);
                    break;
                }
                case NBT_STRUCTURE: {
                    if (this.buildingSpace != null && this.buildingSpace.isEmpty()) {
                        this.buildingBlock = this.findHomeDecor();
                        if (this.buildingBlock != null) {
                            this.syncBuildingBlock(this.buildingBlock.m_60734_());
                            this.startingBlockPos = this.getValidDecorPlacement();
                            if (this.startingBlockPos == null || !this.builder.hasItemsInInventory(this.buildingBlock.m_60734_().m_5456_())) break;
                            if (TaskUtils.isInRange(this.builder, this.startingBlockPos)) {
                                this.builder.m_8061_(EquipmentSlot.MAINHAND, this.builder.getItemsInInventory(this.buildingBlock.m_60734_().m_5456_()));
                                this.builder.m_21573_().m_26573_();
                                if (this.placeBlock()) {
                                    this.builder.buildingCooldown = 20;
                                    this.startingBlockPos = null;
                                    this.syncBuildingBlock(null);
                                    this.builder.setWantedCraftingItem(null);
                                    break;
                                }
                                if (this.canPlaceBlock(this.startingBlockPos)) break;
                                TaskUtils.moveTo((PathfinderMob)this.builder, this.startingBlockPos.m_141950_((Vec3i)this.builder.m_142538_()), 0.85);
                                break;
                            }
                            TaskUtils.moveTo((PathfinderMob)this.builder, this.startingBlockPos, 0.9);
                            break;
                        }
                        this.buildingSpace = null;
                        break;
                    }
                    if (this.iterator == null || !this.iterator.hasNext() || this.buildingSpace == null) break;
                    this.pointer = this.iterator.nextIndex();
                    BlockPos buildPos = (BlockPos)this.builtPositions.get(this.pointer);
                    this.buildingBlock = this.buildingSpace.get(buildPos);
                    if (this.buildingBlock == null) {
                        return;
                    }
                    this.syncBuildingBlock(this.buildingBlock.m_60734_());
                    if (!this.buildingBlock.m_60713_(Blocks.f_50016_) && !this.buildingBlock.m_60713_(Blocks.f_50375_)) {
                        if (!this.blacklistedPlacement.contains((Object)buildPos)) {
                            if (TaskUtils.isInRange(this.builder, buildPos)) {
                                this.builder.m_21573_().m_26573_();
                                if (this.buildingBlock != null && this.builder.hasItemsInInventory(this.buildingBlock.m_60734_().m_5456_())) {
                                    this.builder.m_8061_(EquipmentSlot.MAINHAND, this.builder.getItemsInInventory(this.buildingBlock.m_60734_().m_5456_()));
                                }
                                if (this.placeBuildingBlock(buildPos, this.buildingSpace.get(buildPos))) {
                                    this.builder.buildingCooldown = 20;
                                    this.syncBuildingBlock(null);
                                    this.builder.setWantedCraftingItem(null);
                                    this.buildingSpace.remove(buildPos);
                                    break;
                                }
                                if (this.canPlaceBlock(buildPos)) break;
                                TaskUtils.moveTo((PathfinderMob)this.builder, buildPos.m_141950_((Vec3i)this.builder.m_142538_()), 0.85);
                                break;
                            }
                            TaskUtils.moveTo((PathfinderMob)this.builder, buildPos, 0.9);
                            break;
                        }
                        this.buildingSpace.remove(buildPos);
                        break;
                    }
                    if (this.buildingBlock.m_60713_(Blocks.f_50016_) && !this.whitelistedPlacement.contains((Object)buildPos)) {
                        this.whitelistedPlacement.add((Object)buildPos);
                    } else if (this.buildingBlock.m_60713_(Blocks.f_50375_) && !this.blacklistedPlacement.contains((Object)buildPos)) {
                        this.blacklistedPlacement.add((Object)buildPos);
                    }
                    this.buildingSpace.remove(buildPos);
                }
            }
        }
    }

    public Block getBuildingBlock() {
        return this.buildingBlock != null ? this.buildingBlock.m_60734_() : null;
    }

    public BlockState findHomeDecor() {
        if (!this.whitelistedPlacement.isEmpty()) {
            boolean bed = false;
            boolean chest = false;
            for (BlockPos bpos : this.whitelistedPlacement) {
                BlockState bstate = this.builder.f_19853_.m_8055_(bpos);
                if (bstate.m_60734_() instanceof BedBlock) {
                    bed = true;
                    continue;
                }
                if (!bstate.m_60713_(Blocks.f_50087_)) continue;
                chest = true;
            }
            if (bed && chest) {
                return null;
            }
            if (!chest) {
                return Blocks.f_50087_.m_49966_();
            }
            return Blocks.f_50066_.m_49966_();
        }
        return null;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.builder.setCurrentActivity(PlayerLikeCharacter.Activity.IDLE);
        this.iterator = null;
        if (this.buildingSpace != null) {
            this.buildingSpace.clear();
            if (this.builtPositions != null) {
                this.builtPositions.clear();
            }
        }
        this.placedBlocks.clear();
    }

    public boolean placeBlock() {
        if (!this.canPlaceBlock(this.startingBlockPos)) {
            return false;
        }
        if (this.startingBlockPos != null && this.isValidBlock(this.buildingBlock, this.startingBlockPos)) {
            if (this.buildingBlock.m_60734_() instanceof BedBlock) {
                if (TaskUtils.isReplaceableOrPlant(this.builder.f_19853_.m_8055_(this.startingBlockPos.m_7494_())) && TaskUtils.isReplaceableOrPlant(this.builder.f_19853_.m_8055_(this.startingBlockPos.m_7494_().m_142127_()))) {
                    BlockState bstate = (BlockState)this.buildingBlock.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH);
                    if (TaskUtils.placeBlock(this.builder, this.startingBlockPos.m_7494_(), bstate)) {
                        this.builder.bedPos = this.startingBlockPos.m_7494_().m_142127_();
                        return true;
                    }
                } else if (TaskUtils.isReplaceableOrPlant(this.builder.f_19853_.m_8055_(this.startingBlockPos.m_7494_())) && TaskUtils.isReplaceableOrPlant(this.builder.f_19853_.m_8055_(this.startingBlockPos.m_7494_().m_142128_()))) {
                    BlockState bstate = (BlockState)this.buildingBlock.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH);
                    if (TaskUtils.placeBlock(this.builder, this.startingBlockPos.m_7494_(), bstate)) {
                        this.builder.bedPos = this.startingBlockPos.m_7494_().m_142128_();
                        return true;
                    }
                } else if (TaskUtils.isReplaceableOrPlant(this.builder.f_19853_.m_8055_(this.startingBlockPos.m_7494_())) && TaskUtils.isReplaceableOrPlant(this.builder.f_19853_.m_8055_(this.startingBlockPos.m_7494_().m_142126_()))) {
                    BlockState bstate = (BlockState)this.buildingBlock.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST);
                    if (TaskUtils.placeBlock(this.builder, this.startingBlockPos.m_7494_(), bstate)) {
                        this.builder.bedPos = this.startingBlockPos.m_7494_().m_142126_();
                        return true;
                    }
                } else if (TaskUtils.isReplaceableOrPlant(this.builder.f_19853_.m_8055_(this.startingBlockPos.m_7494_())) && TaskUtils.isReplaceableOrPlant(this.builder.f_19853_.m_8055_(this.startingBlockPos.m_7494_().m_142125_()))) {
                    BlockState bstate = (BlockState)this.buildingBlock.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST);
                    if (TaskUtils.placeBlock(this.builder, this.startingBlockPos.m_7494_(), bstate)) {
                        this.builder.bedPos = this.startingBlockPos.m_7494_().m_142125_();
                        return true;
                    }
                }
                return false;
            }
            return TaskUtils.placeBlock(this.builder, this.startingBlockPos.m_7494_(), this.buildingBlock);
        }
        return false;
    }

    public boolean placeBuildingBlock(BlockPos bpos, BlockState bstate) {
        if (!this.canPlaceBlock(bpos)) {
            return false;
        }
        if (!this.blacklistedPlacement.contains((Object)bpos) && this.builder.hasItemsInInventory(bstate.m_60734_().m_5456_()) && !this.builder.f_19853_.m_8055_(bpos.m_7494_()).m_60713_(bstate.m_60734_())) {
            if (bstate.m_60734_() instanceof DoorBlock && bstate.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
                return TaskUtils.placeBlock(this.builder, bpos, (BlockState)bstate.m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.LOWER));
            }
            return TaskUtils.placeBlock(this.builder, bpos.m_7494_(), bstate);
        }
        return false;
    }

    public boolean canPlaceBlock(BlockPos blockPos) {
        return !blockPos.m_203195_((Position)this.builder.m_20182_(), 1.0);
    }

    private void getValidBlockPlacement() {
        PlayerLike.BuilderGoal builderGoal = this.builder.getBuildingGoal();
        if (builderGoal == PlayerLike.BuilderGoal.CAMPFIRE && this.builder.getHomePos() != null && this.builder.getHomePos() != BlockPos.f_121853_ && TaskUtils.isReplaceableOrPlant(this.builder.f_19853_.m_8055_(this.builder.getHomePos()))) {
            this.startingBlockPos = this.builder.getHomePos().m_7495_();
            return;
        }
        BlockPos bpos = builderGoal == PlayerLike.BuilderGoal.CRAFTING_TABLE && this.builder.getHomePos() != null && this.builder.getHomePos() != BlockPos.f_121853_ ? this.builder.getHomePos() : this.builder.m_142538_();
        int i = 8;
        int j = 1;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int k = this.verticalSearchStart;
        while (k <= j) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        mutable.m_122154_((Vec3i)bpos, i1, k - 1, j1);
                        BlockState state = this.builder.f_19853_.m_8055_((BlockPos)mutable);
                        if (TaskUtils.isReplaceableOrPlant(state) && !state.m_60713_(this.buildingBlock.m_60734_()) && this.isValidBlock(this.buildingBlock, mutable.m_7495_()) && TaskUtils.isInRange(this.builder, (BlockPos)mutable)) {
                            this.startingBlockPos = mutable.m_7495_();
                            return;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        this.startingBlockPos = null;
    }

    private BlockPos getValidDecorPlacement() {
        if (!this.whitelistedPlacement.isEmpty()) {
            for (BlockPos bpos : this.whitelistedPlacement) {
                BlockState state;
                if (this.builder.f_19853_.m_8055_(bpos.m_7494_()).m_60713_(this.buildingBlock.m_60734_()) || !this.builder.m_21444_(bpos) || !TaskUtils.isReplaceableOrPlant(state = this.builder.level().m_8055_(bpos.m_7494_())) || !this.isValidBlock(this.buildingBlock, bpos)) continue;
                return bpos;
            }
        }
        return null;
    }

    protected boolean isValidBlock(BlockState place, BlockPos wanted) {
        Level lreader = this.builder.level();
        if (place.m_60710_((LevelReader)lreader, wanted) && !this.blacklistedPlacement.contains((Object)wanted.m_7494_())) {
            if (place.m_60734_() instanceof BedBlock) {
                return TaskUtils.isReplaceableOrPlant(this.builder.f_19853_.m_8055_(wanted.m_7494_().m_142127_())) && this.builder.f_19853_.m_8055_(wanted.m_142127_()).m_60767_().m_76333_() && !(lreader.m_8055_(wanted.m_142127_()).m_60734_() instanceof BedBlock) && !(lreader.m_8055_(wanted.m_142127_()).m_60734_() instanceof ChestBlock) && !this.blacklistedPlacement.contains((Object)wanted.m_7494_().m_142127_()) || TaskUtils.isReplaceableOrPlant(this.builder.f_19853_.m_8055_(wanted.m_7494_().m_142128_())) && this.builder.f_19853_.m_8055_(wanted.m_142128_()).m_60767_().m_76333_() && !(lreader.m_8055_(wanted.m_142128_()).m_60734_() instanceof BedBlock) && !(lreader.m_8055_(wanted.m_142128_()).m_60734_() instanceof ChestBlock) && !this.blacklistedPlacement.contains((Object)wanted.m_7494_().m_142128_()) || TaskUtils.isReplaceableOrPlant(this.builder.f_19853_.m_8055_(wanted.m_7494_().m_142126_())) && this.builder.f_19853_.m_8055_(wanted.m_142126_()).m_60767_().m_76333_() && !(lreader.m_8055_(wanted.m_142126_()).m_60734_() instanceof BedBlock) && !(lreader.m_8055_(wanted.m_142126_()).m_60734_() instanceof ChestBlock) && !this.blacklistedPlacement.contains((Object)wanted.m_7494_().m_142126_()) || TaskUtils.isReplaceableOrPlant(this.builder.f_19853_.m_8055_(wanted.m_7494_().m_142125_())) && this.builder.f_19853_.m_8055_(wanted.m_142125_()).m_60767_().m_76333_() && !(lreader.m_8055_(wanted.m_142125_()).m_60734_() instanceof BedBlock) && !(lreader.m_8055_(wanted.m_142125_()).m_60734_() instanceof ChestBlock) && !this.blacklistedPlacement.contains((Object)wanted.m_7494_().m_142125_()) && lreader.m_8055_(wanted).m_60767_().m_76333_() && TaskUtils.isReplaceableOrPlant(this.builder.f_19853_.m_8055_(wanted.m_7494_())) && !(lreader.m_8055_(wanted).m_60734_() instanceof BedBlock) && !(lreader.m_8055_(wanted).m_60734_() instanceof ChestBlock) && !this.blacklistedPlacement.contains((Object)wanted.m_7494_());
            }
            return lreader.m_8055_(wanted).m_60767_().m_76333_() && !(lreader.m_8055_(wanted).m_60734_() instanceof BedBlock) && !(lreader.m_8055_(wanted).m_60734_() instanceof ChestBlock) && TaskUtils.isReplaceableOrPlant(lreader.m_8055_(wanted.m_7494_())) && !this.blacklistedPlacement.contains((Object)wanted.m_7494_());
        }
        return false;
    }

    public TreeMap<BlockPos, BlockState> getValidBuildingPos(BlockPos homePos, Vec3i size, Map<BlockPos, BlockState> materials) {
        if (this.builder.getHomePos() == null) {
            this.structureStart = null;
            this.structureRot = null;
            return null;
        }
        if (size.m_123341_() > 0 && size.m_123342_() > 0 && size.m_123343_() > 0) {
            if (this.builder.structurePos != null) {
                this.structureStart = this.builder.structurePos;
                this.structureRot = this.builder.structureRot;
            }
            if (this.structureStart == null) {
                int i = RoamersMod.CONFIG.doLegacyHouses ? 2 : 3;
                int j = RoamersMod.CONFIG.doLegacyHouses ? 9 : 12;
                this.structureRot = Rotation.m_55956_((Random)this.builder.f_19853_.m_5822_());
                switch (this.structureRot) {
                    case CLOCKWISE_90: {
                        BlockPos bpos1 = new BlockPos(homePos.m_123341_(), homePos.m_123342_(), homePos.m_123343_() - size.m_123343_() / 2);
                        this.structureStart = bpos1.m_142385_(this.builder.f_19853_.m_5822_().nextInt(i) + j);
                        break;
                    }
                    case CLOCKWISE_180: {
                        BlockPos bpos2 = new BlockPos(homePos.m_123341_() - size.m_123341_() / 2, homePos.m_123342_(), homePos.m_123343_());
                        this.structureStart = bpos2.m_142383_(this.builder.f_19853_.m_5822_().nextInt(i) + j).m_142385_(size.m_123341_() + size.m_123341_() / 2);
                        break;
                    }
                    case COUNTERCLOCKWISE_90: {
                        BlockPos bpos3 = new BlockPos(homePos.m_123341_(), homePos.m_123342_(), homePos.m_123343_() + size.m_123343_() / 2);
                        this.structureStart = bpos3.m_142386_(this.builder.f_19853_.m_5822_().nextInt(i) + j);
                        break;
                    }
                    default: {
                        ObjectListIterator bpos4 = new BlockPos(homePos.m_123341_() + size.m_123341_() / 2, homePos.m_123342_(), homePos.m_123343_());
                        this.structureStart = bpos4.m_142390_(this.builder.f_19853_.m_5822_().nextInt(i) + j).m_142386_(size.m_123341_() - size.m_123341_() / 2);
                    }
                }
            }
            ObjectArrayList blockPositions = new ObjectArrayList(materials.keySet());
            HashMap<BlockPos, BlockState> retval = new HashMap<BlockPos, BlockState>();
            if (!blockPositions.isEmpty()) {
                for (BlockPos bpos : blockPositions) {
                    BlockState bstate = materials.get(bpos).m_60717_(this.structureRot);
                    BlockPos newPos = bpos.m_7954_(this.structureRot).m_141952_((Vec3i)this.structureStart);
                    if (bstate.m_60713_(Blocks.f_50375_) || bstate.m_60713_(Blocks.f_50016_)) {
                        if (bstate.m_60713_(Blocks.f_50375_) && !this.blacklistedPlacement.contains((Object)newPos)) {
                            this.blacklistedPlacement.add((Object)newPos);
                        }
                        if (!bstate.m_60713_(Blocks.f_50016_) || this.whitelistedPlacement.contains((Object)newPos)) continue;
                        this.whitelistedPlacement.add((Object)newPos);
                        continue;
                    }
                    if (this.builder.f_19853_.m_8055_(newPos.m_7494_()).m_60713_(bstate.m_60734_()) && !this.placedBlocks.contains((Object)newPos)) {
                        this.placedBlocks.add((Object)newPos);
                        continue;
                    }
                    if (!this.builder.f_19853_.m_46859_(newPos.m_7494_()) && (!TaskUtils.isReplaceableOrPlant(this.builder.f_19853_.m_8055_(newPos.m_7494_())) || this.blacklistedPlacement.contains((Object)newPos))) continue;
                    retval.put(newPos, bstate);
                }
            }
            if (!retval.isEmpty()) {
                TreeMap<BlockPos, BlockState> treeMap = new TreeMap<BlockPos, BlockState>(retval);
                this.placedBlocks.clear();
                return treeMap;
            }
        }
        this.placedBlocks.clear();
        return null;
    }

    public void update() {
        if (this.builder != null) {
            this.buildManager = this.builder.getBuilderManager();
            if (this.buildManager != null) {
                if (this.isSingleBlockBuild() && this.buildManager.getBuildingBlock() != null) {
                    this.buildType = BuildType.SINGLE_BLOCK;
                    this.buildingBlock = this.buildManager.getBuildingBlock().m_49966_();
                } else if (this.isNBTStructure()) {
                    this.buildData = this.buildManager.getBuilderData();
                    this.builderMap = this.buildData.getBuildingMaterials();
                    this.buildType = BuildType.NBT_STRUCTURE;
                }
            }
        }
    }

    public void syncBuildingBlock(Block block) {
        if (block != null && block != Blocks.f_50375_ && block != Blocks.f_50016_) {
            this.buildManager.setBuildingBlock(block);
            return;
        }
        this.buildManager.setBuildingBlock(null);
    }

    public boolean isSingleBlockBuild() {
        return this.builder.getBuildingGoal() == PlayerLike.BuilderGoal.CAMPFIRE || this.builder.getBuildingGoal() == PlayerLike.BuilderGoal.CRAFTING_TABLE;
    }

    public boolean isNBTStructure() {
        return this.builder.getBuildingGoal() == PlayerLike.BuilderGoal.HUT;
    }

    public static enum BuildType {
        SINGLE_BLOCK,
        NBT_STRUCTURE;

    }
}

