/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity.ai.tasks;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.caitie.roamers.RoamersMod;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.caitie.roamers.entity.ai.TaskUtils;
import net.caitie.roamers.entity.ai.tasks.Task;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public class FarmTask
extends Task {
    protected final PlayerLikeCharacter farmer;
    private final TagKey<Item> plantables;
    protected final int range;
    protected boolean shouldTill;
    private final int verticalSearchRange = 1;
    private final int searchRange = 10;
    protected int verticalSearchStart;
    protected BlockPos waterPos;
    protected BlockPos currentBlockPos;
    protected Chore currentChore;
    protected int pointer;
    protected int tryTicks;
    protected ListIterator iterator;
    protected boolean shouldUse;
    @Nullable
    protected List<BlockPos> farmPositions = new ArrayList<BlockPos>();

    public FarmTask(PlayerLikeCharacter farmer, TagKey<Item> plantables, int range) {
        super(farmer);
        this.farmer = farmer;
        this.plantables = plantables;
        this.shouldTill = RoamersMod.CONFIG.allowLandTilling;
        this.range = range;
        this.getFarmingRange();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public boolean shouldStart() {
        if (this.farmer.getCurrentActivity() == PlayerLikeCharacter.Activity.COMBAT) {
            return false;
        }
        if (!this.farmer.hasTaggedItemsInInventory((TagKey<Item>)PlayerLikeCharacter.PLANTABLES)) {
            return false;
        }
        if (!this.farmer.f_19853_.m_46469_().m_46207_(GameRules.f_46132_)) {
            return false;
        }
        if (!this.isInUse && this.shouldUse() && this.farmer.canContinueToFarm()) {
            this.getFarmingRange();
            if (this.farmPositions != null && !this.farmPositions.isEmpty()) {
                this.shouldUse = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canContinue() {
        if (this.shouldUse) {
            return this.farmer.getCurrentActivity() != PlayerLikeCharacter.Activity.COMBAT && this.farmer.canContinueToFarm() && this.farmer.f_19853_.m_46469_().m_46207_(GameRules.f_46132_) && this.tryTicks >= -600 && this.tryTicks <= 600 && this.pointer <= this.farmPositions.size();
        }
        return false;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.farmer.setCurrentActivity(PlayerLikeCharacter.Activity.FARMING);
        this.iterator = this.farmPositions.listIterator();
    }

    @Override
    public void doTick() {
        if (this.iterator != null && this.iterator.hasNext()) {
            this.pointer = this.iterator.nextIndex();
            this.currentBlockPos = this.farmPositions.get(this.pointer);
            if (this.currentBlockPos.m_203195_((Position)this.farmer.m_20182_(), 4.0)) {
                this.currentChore = this.findChore(this.currentBlockPos);
                if (this.currentChore != null) {
                    switch (this.currentChore) {
                        case PLANT: {
                            if (this.farmer.farmingCooldown > 0) break;
                            this.plantCrops(this.currentBlockPos);
                            this.farmPositions.remove(this.currentBlockPos);
                            this.farmer.farmingCooldown = 20;
                            break;
                        }
                        case TILL: {
                            if (this.farmer.farmingCooldown > 0) break;
                            this.tillLand(this.currentBlockPos);
                            this.farmPositions.remove(this.currentBlockPos);
                            this.farmer.farmingCooldown = 20;
                            break;
                        }
                        case HARVEST: {
                            if (this.farmer.farmingCooldown > 0) break;
                            this.harvestCrops(this.currentBlockPos);
                            this.plantCrops(this.currentBlockPos);
                            this.farmPositions.remove(this.currentBlockPos);
                            this.farmer.farmingCooldown = 20;
                            break;
                        }
                        case BONEMEAL: {
                            if (this.farmer.farmingCooldown > 0) break;
                            this.bonemealCrops(this.currentBlockPos);
                            this.farmPositions.remove(this.currentBlockPos);
                            this.farmer.farmingCooldown = 20;
                        }
                    }
                } else {
                    this.farmPositions.remove(this.currentBlockPos);
                }
                --this.tryTicks;
            } else {
                TaskUtils.lookAndMoveTo((PathfinderMob)this.farmer, this.currentBlockPos, this.farmer.isDepressed() ? 0.5 : 0.9);
                ++this.tryTicks;
            }
        }
    }

    @Override
    public void doUpdateTick() {
        this.shouldUse = this.shouldUse();
    }

    public boolean shouldUse() {
        if (this.farmPositions == null || this.farmPositions.isEmpty()) {
            this.getFarmingRange();
        }
        if (this.farmPositions != null && !this.farmPositions.isEmpty()) {
            for (BlockPos bpos : this.farmPositions) {
                BlockState bstate = this.farmer.f_19853_.m_8055_(bpos);
                BlockState above = this.farmer.f_19853_.m_8055_(bpos.m_7494_());
                if (above.m_60734_() instanceof CropBlock) {
                    CropBlock crop = (CropBlock)above.m_60734_();
                    if (crop.m_52307_(above)) {
                        return true;
                    }
                    if (!this.farmer.hasItemsInInventory(Items.f_42499_)) continue;
                    return true;
                }
                if (!(bstate.m_60713_(Blocks.f_50093_) && this.farmer.f_19853_.m_46859_(bpos.m_7494_()) ? this.farmer.hasTaggedItemsInInventory(this.plantables) : this.shouldTill && this.isTillable(bstate) && this.isReplaceableOrPlant(bpos.m_7494_()) && this.farmer.getItemTypeInInventory(HoeItem.class) != null && this.farmer.hasTaggedItemsInInventory(this.plantables))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isReplaceableOrPlant(BlockPos blockPos) {
        BlockState blockState = this.farmer.f_19853_.m_8055_(blockPos);
        if (blockState.m_60767_().m_76336_()) {
            return true;
        }
        if (blockState.m_60767_() == Material.f_76300_) {
            return !blockState.m_60815_();
        }
        return false;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.farmer.setCurrentActivity(PlayerLikeCharacter.Activity.IDLE);
        if (this.tryTicks >= 600 || this.tryTicks <= -600) {
            this.farmPositions.remove(this.currentBlockPos);
        }
        this.tryTicks = 0;
    }

    public void harvestCrops(BlockPos bpos) {
        BlockState bstate = this.farmer.f_19853_.m_8055_(bpos.m_7494_());
        if (bstate.m_60734_() instanceof CropBlock && ((CropBlock)bstate.m_60734_()).m_52307_(bstate)) {
            TaskUtils.mineBlock(this.farmer, bpos.m_7494_(), bstate, true);
        }
    }

    public void plantCrops(BlockPos bpos) {
        ItemStack seeds = this.farmer.getTaggedItemsInInventory(this.plantables);
        if (seeds != null) {
            this.farmer.m_21008_(InteractionHand.MAIN_HAND, seeds);
            TaskUtils.placeBlock(this.farmer, bpos.m_7494_(), ((BlockItem)seeds.m_41720_()).m_40614_().m_49966_());
        }
    }

    public void tillLand(BlockPos bpos) {
        ItemStack hoe = this.farmer.getItemTypeInInventory(HoeItem.class);
        if (hoe != null) {
            this.farmer.m_21008_(InteractionHand.MAIN_HAND, hoe);
            this.farmer.m_6674_(InteractionHand.MAIN_HAND);
            this.farmer.f_19853_.m_46597_(bpos, Blocks.f_50093_.m_49966_());
            if (this.isReplaceableOrPlant(bpos.m_7494_())) {
                this.farmer.f_19853_.m_46953_(bpos.m_7494_(), true, null);
            }
            this.farmer.f_19853_.m_5594_(null, bpos, SoundEvents.f_11955_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public void bonemealCrops(BlockPos bpos) {
        ItemStack bonemeal = this.farmer.getItemsInInventory(Items.f_42499_);
        if (bonemeal != null && TaskUtils.useBonemeal(this.farmer, bonemeal, bpos.m_7494_())) {
            this.farmer.f_19853_.m_46796_(2005, bpos.m_7494_(), 0);
            this.farmer.f_19853_.m_5594_(null, bpos, SoundEvents.f_144074_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public Chore findChore(BlockPos bpos) {
        BlockState bstate = this.farmer.f_19853_.m_8055_(bpos);
        if (this.isTillable(bstate) && this.shouldTill && this.farmer.getItemTypeInInventory(HoeItem.class) != null) {
            return Chore.TILL;
        }
        if (bstate.m_60713_(Blocks.f_50093_) && this.farmer.f_19853_.m_46859_(bpos.m_7494_()) && this.farmer.hasTaggedItemsInInventory(this.plantables)) {
            return Chore.PLANT;
        }
        if (this.farmer.f_19853_.m_8055_(bpos.m_7494_()).m_60734_() instanceof CropBlock) {
            CropBlock crop = (CropBlock)this.farmer.f_19853_.m_8055_(bpos.m_7494_()).m_60734_();
            if (!crop.m_52307_(this.farmer.f_19853_.m_8055_(bpos.m_7494_()))) {
                if (this.farmer.hasItemsInInventory(Items.f_42499_)) {
                    return Chore.BONEMEAL;
                }
            } else {
                return Chore.HARVEST;
            }
        }
        return null;
    }

    protected void getFarmingRange() {
        this.waterPos = this.findWaterPos();
        if (this.waterPos != null) {
            for (int x = -this.range + this.waterPos.m_123341_(); x < this.range + this.waterPos.m_123341_(); ++x) {
                for (int z = -this.range + this.waterPos.m_123343_(); z < this.range + this.waterPos.m_123343_(); ++z) {
                    BlockPos bpos = new BlockPos(x, this.waterPos.m_123342_(), z);
                    BlockState bstate = this.farmer.f_19853_.m_8055_(bpos);
                    if (!this.isTillable(bstate) && !bstate.m_60713_(Blocks.f_50093_) || this.farmPositions == null || this.farmPositions.contains(bpos) || !this.farmer.f_19853_.m_46859_(bpos.m_7494_()) && !(this.farmer.f_19853_.m_8055_(bpos.m_7494_()).m_60734_() instanceof CropBlock) && !this.farmer.f_19853_.m_8055_(bpos.m_7494_()).m_60767_().m_76336_()) continue;
                    this.farmPositions.add(bpos);
                }
            }
            if (!(this.farmPositions == null || this.farmPositions.isEmpty() || this.farmer.farmPos != null && this.farmer.f_19853_.m_46801_(this.farmer.farmPos))) {
                this.farmer.farmPos = this.waterPos;
            }
        }
    }

    public void placeWater(BlockPos bpos) {
        ItemStack water = this.farmer.getItemsInInventory(Items.f_42447_);
        if (water != null) {
            BlockState bstate = this.farmer.f_19853_.m_8055_(bpos);
            ItemStack tool = TaskUtils.findTool(this.farmer, bstate);
            TaskUtils.mineBlockWithTool(this.farmer, tool, bpos, bstate, tool.m_41735_(bstate));
            if (this.farmer.f_19853_.m_46859_(bpos)) {
                TaskUtils.emptyBucket(this.farmer, water, bpos);
            }
        }
    }

    public boolean isTillable(BlockState bstate) {
        return bstate.m_60713_(Blocks.f_50493_) || bstate.m_60713_(Blocks.f_50440_) || bstate.m_60713_(Blocks.f_50546_);
    }

    private BlockPos findWaterPos() {
        this.farmer.checkIfValidFarm();
        if (this.farmer.farmPos != null) {
            if (this.farmer.f_19853_.m_46801_(this.farmer.farmPos)) {
                return this.farmer.farmPos;
            }
            this.farmer.farmPos = null;
        } else {
            int i = this.searchRange;
            int j = this.verticalSearchRange;
            BlockPos bpos = this.farmer.m_142538_();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            int k = this.verticalSearchStart;
            while (k <= j) {
                for (int l = 0; l < i; ++l) {
                    int i1 = 0;
                    while (i1 <= l) {
                        int j1;
                        int n = j1 = i1 < l && i1 > -l ? l : 0;
                        while (j1 <= l) {
                            mutable.m_122154_((Vec3i)bpos, i1, k - 1, j1);
                            if (this.farmer.m_21444_((BlockPos)mutable) && this.farmer.f_19853_.m_46801_((BlockPos)mutable)) {
                                return mutable;
                            }
                            j1 = j1 > 0 ? -j1 : 1 - j1;
                        }
                        i1 = i1 > 0 ? -i1 : 1 - i1;
                    }
                }
                k = k > 0 ? -k : 1 - k;
            }
        }
        return null;
    }

    public static enum Chore {
        TILL,
        PLANT,
        BONEMEAL,
        HARVEST,
        COMPOST;

    }
}

