/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity.ai.tasks;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import net.caitie.roamers.RoamersMod;
import net.caitie.roamers.entity.AbstractCharacter;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.caitie.roamers.entity.ai.TaskUtils;
import net.caitie.roamers.entity.ai.tasks.Task;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class MineTask
extends Task {
    protected final PlayerLikeCharacter miner;
    protected int tryTicks;
    protected final int range;
    protected final boolean breakBlocksInWay;
    protected List<BlockPos> blocksInWay;
    private boolean clearLand;
    public Item wantedItem;
    public TagKey<Item> wantedItems;
    public Ingredient wantedIngredient;
    public ItemStack tool;
    protected BlockState blockToMine;
    public List<BlockPos> blocksToMine;
    protected BlockPos miningPos;
    protected BlockPos currentMinePos;
    protected int pointer;
    protected ListIterator iterator;
    protected ListIterator blocksInWayIterator;
    protected int blockInWayIndex;
    private BlockPos blockInWayPos;
    protected Path path;
    protected Path blockedPath;

    public MineTask(PlayerLikeCharacter miner, Item item, boolean breakBlocksInWay) {
        super(miner);
        this.range = RoamersMod.CONFIG.blockSearchRange;
        this.clearLand = false;
        this.miner = miner;
        this.wantedItem = item;
        this.breakBlocksInWay = RoamersMod.CONFIG.mineBlocksInWayOfPath && breakBlocksInWay;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public MineTask(PlayerLikeCharacter miner, TagKey<Item> tagkey, boolean breakBlocksInWay) {
        super(miner);
        this.range = RoamersMod.CONFIG.blockSearchRange;
        this.clearLand = false;
        this.miner = miner;
        this.wantedItems = tagkey;
        this.breakBlocksInWay = RoamersMod.CONFIG.mineBlocksInWayOfPath && breakBlocksInWay;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public MineTask(PlayerLikeCharacter miner, Ingredient wantedItems, boolean breakBlocksInWay) {
        super(miner);
        this.range = RoamersMod.CONFIG.blockSearchRange;
        this.clearLand = false;
        this.miner = miner;
        this.wantedIngredient = wantedItems;
        this.breakBlocksInWay = RoamersMod.CONFIG.mineBlocksInWayOfPath && breakBlocksInWay;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public MineTask(PlayerLikeCharacter miner, boolean clearLand, boolean breakBlocksInWay) {
        super(miner);
        this.range = RoamersMod.CONFIG.blockSearchRange;
        this.clearLand = false;
        this.miner = miner;
        this.clearLand = clearLand;
        this.breakBlocksInWay = RoamersMod.CONFIG.mineBlocksInWayOfPath && breakBlocksInWay;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public boolean shouldStart() {
        if (this.miner.isInBadMood()) {
            return false;
        }
        if ((this.wantedItem != null || this.wantedItems != null || this.wantedIngredient != null || this.clearLand) && this.miner.canMine() && TaskUtils.shouldBreakBlocks(this.miner)) {
            if (this.clearLand) {
                this.blocksToMine = this.getBlocksToMine(this.miner.getHomePos(), RoamersMod.CONFIG.landClearingRange, 6);
                if (this.blocksToMine != null) {
                    return this.miner.canContinueToMine() && !this.blocksToMine.isEmpty() && this.pointer < this.blocksToMine.size();
                }
            }
            if (this.blocksToMine == null && this.miner.getAI() != null) {
                this.miner.getAI().checkLand = true;
            }
            if (this.blockToMine == null || this.miningPos == null) {
                this.blockToMine = this.findNearestBlock();
            }
            return !this.testInventory() && this.miner.canContinueToMine() && this.blockToMine != null && this.blockToMine.m_60800_((BlockGetter)this.miner.f_19853_, this.miningPos) < 100.0f && this.blockToMine.m_60800_((BlockGetter)this.miner.f_19853_, this.miningPos) >= 0.0f;
        }
        return false;
    }

    @Override
    public boolean canContinue() {
        return !this.miner.isInBadMood() && this.miner.canContinueToMine() && TaskUtils.shouldBreakBlocks(this.miner) && this.tryTicks >= -200 && this.tryTicks <= 200 && (this.blockToMine != null || this.blocksToMine != null && !this.blocksToMine.isEmpty()) && this.tool != null && !this.testInventory();
    }

    public boolean testInventory() {
        for (int i = 0; i < this.miner.getInventory().m_6643_(); ++i) {
            ItemStack stack = this.miner.getInventory().m_8020_(i);
            if (this.wantedItem != null && stack.m_150930_(this.wantedItem)) {
                return stack.m_41613_() >= 16;
            }
            if (this.wantedItems != null && stack.m_204117_(this.wantedItems)) {
                return stack.m_41613_() >= 16;
            }
            if (this.wantedIngredient != null && this.wantedIngredient.test(stack)) {
                return stack.m_41613_() >= 16;
            }
            if (stack.m_150930_(Items.f_42452_) && this.miner.getRace() == AbstractCharacter.Race.ARTIC) {
                return stack.m_41613_() >= 16;
            }
            if (!stack.m_204117_(ItemTags.f_13137_) || this.miner.getRace() != AbstractCharacter.Race.DESERT && this.miner.getRace() != AbstractCharacter.Race.BADLANDS) continue;
            return stack.m_41613_() >= 16;
        }
        return false;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.blockedPath = null;
        if (this.blockToMine != null) {
            this.setTool(this.blockToMine);
        } else if (this.blocksToMine != null) {
            this.iterator = this.blocksToMine.listIterator();
            BlockState bstate = this.miner.f_19853_.m_8055_(this.blocksToMine.get(0));
            this.setTool(bstate);
        }
        this.tryTicks = 0;
    }

    public void setTool(BlockState blockState) {
        this.tool = this.findTool(blockState);
        if (this.tool != null) {
            this.miner.m_8061_(EquipmentSlot.MAINHAND, this.tool);
        }
    }

    @Override
    public int getUpdateTime() {
        return 20;
    }

    public boolean m_183429_() {
        return true;
    }

    @Override
    public void doUpdateTick() {
        if (TaskUtils.shouldBreakBlocks(this.miner)) {
            if (this.miningPos != null) {
                this.currentMinePos = null;
                this.path = this.miner.m_21573_().m_7864_(this.miningPos, 0);
                if (this.breakBlocksInWay && this.path != null && !this.path.m_77403_()) {
                    if (this.blockedPath == null || this.blockedPath.m_77392_() || !this.blockedPath.m_77403_()) {
                        this.blockedPath = TaskUtils.createPathThroughBlocks(this.miner, this.miningPos);
                        this.blocksInWay = TaskUtils.getBlocksInWayOfPath(this.miner, this.blockedPath, 1, 2, 1, this.blockToMine.m_204336_(BlockTags.f_13106_));
                    }
                    if (this.blocksInWay != null && !this.blocksInWay.isEmpty()) {
                        this.blocksInWayIterator = this.blocksInWay.listIterator();
                        this.blockInWayIndex = this.blocksInWayIterator.nextIndex();
                        this.blockInWayPos = this.blocksInWay.get(this.blockInWayIndex);
                        BlockState blockState = this.miner.f_19853_.m_8055_(this.blockInWayPos);
                        this.setTool(blockState);
                        if (!this.isValidBlock(this.blockInWayPos)) {
                            this.blocksInWay.remove(this.blockInWayPos);
                            if (!this.blocksInWay.isEmpty()) {
                                this.blockInWayIndex = this.blocksInWayIterator.nextIndex();
                                this.blockInWayPos = this.blocksInWay.get(this.blockInWayIndex);
                            }
                            return;
                        }
                        if (!this.isNextToBlock(this.blockInWayPos)) {
                            TaskUtils.moveTo((PathfinderMob)this.miner, this.blockInWayPos, 0.9);
                        } else {
                            this.miner.m_21573_().m_26573_();
                        }
                        if (TaskUtils.isInRange(this.miner, this.blockInWayPos)) {
                            if (this.mine(this.blockInWayPos, this.miner.f_19853_.m_8055_(this.blockInWayPos))) {
                                this.blocksInWay.remove(this.blockInWayPos);
                                if (!this.blocksInWay.isEmpty()) {
                                    this.blockInWayIndex = this.blocksInWayIterator.nextIndex();
                                    this.blockInWayPos = this.blocksInWay.get(this.blockInWayIndex);
                                }
                                return;
                            }
                            --this.tryTicks;
                        } else {
                            ++this.tryTicks;
                            return;
                        }
                    }
                    this.blockInWayPos = null;
                }
                if (this.blockToMine != null && this.path != null) {
                    this.setTool(this.blockToMine);
                    if (!this.isNextToBlock(this.miningPos)) {
                        TaskUtils.moveTo((PathfinderMob)this.miner, this.path, 0.9);
                    } else {
                        this.miner.m_21573_().m_26573_();
                    }
                    if (TaskUtils.isInRange(this.miner, this.miningPos)) {
                        if (this.mine(this.miningPos, this.blockToMine)) {
                            this.blockToMine = null;
                            return;
                        }
                        --this.tryTicks;
                    } else {
                        ++this.tryTicks;
                    }
                }
            }
            if (this.blocksToMine != null && this.iterator != null && this.iterator.hasNext()) {
                this.pointer = this.iterator.nextIndex();
                this.currentMinePos = this.blocksToMine.get(this.pointer);
                this.path = this.miner.m_21573_().m_7864_(this.currentMinePos, 0);
                BlockState bstate = this.miner.f_19853_.m_8055_(this.currentMinePos);
                this.setTool(bstate);
                if (!this.isNextToBlock(this.currentMinePos)) {
                    TaskUtils.moveTo((PathfinderMob)this.miner, this.path, 0.9);
                } else {
                    this.miner.m_21573_().m_26573_();
                }
                if (TaskUtils.isInRange(this.miner, this.currentMinePos)) {
                    if (this.mine(this.currentMinePos, bstate)) {
                        this.blocksToMine.remove(this.currentMinePos);
                        return;
                    }
                    --this.tryTicks;
                } else {
                    ++this.tryTicks;
                }
            }
        }
    }

    @Override
    public void doTick() {
        if (this.blocksInWay != null && this.blockInWayPos != null) {
            TaskUtils.lookAt((PathfinderMob)this.miner, this.blockInWayPos);
        } else if (this.blocksToMine != null && this.iterator != null && this.currentMinePos != null) {
            TaskUtils.lookAt((PathfinderMob)this.miner, this.currentMinePos.m_142300_(this.miner.m_6350_()));
        } else if (this.blockToMine != null && this.miningPos != null) {
            TaskUtils.lookAt((PathfinderMob)this.miner, this.miningPos.m_142300_(this.miner.m_6350_()));
        }
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.path = null;
        this.miningPos = null;
        this.blockToMine = null;
        this.blockedPath = null;
        this.miner.setCurrentActivity(PlayerLikeCharacter.Activity.IDLE);
        if (this.blocksToMine != null && (this.tryTicks >= 600 || this.tryTicks <= -600)) {
            this.blocksToMine.remove(this.currentMinePos);
        }
    }

    protected BlockState findNearestBlock() {
        if (TaskUtils.shouldBreakBlocks(this.miner) && !this.miner.f_19853_.f_46443_) {
            BlockState blockState;
            List drops;
            if (this.miningPos != null && !this.isValidBlock(this.miningPos) && !(drops = Block.m_49869_((BlockState)(blockState = this.miner.f_19853_.m_8055_(this.miningPos.m_7494_())), (ServerLevel)((ServerLevel)this.miner.f_19853_), (BlockPos)this.miningPos.m_7494_(), (BlockEntity)this.miner.f_19853_.m_7702_(this.miningPos.m_7494_()))).isEmpty()) {
                for (ItemStack items : drops) {
                    if (this.wantedIngredient != null && this.wantedIngredient.test(items)) {
                        if (!blockState.m_204336_(BlockTags.f_13106_) || !TaskUtils.isInRange(this.miner, this.miningPos.m_7494_())) continue;
                        this.miningPos = this.miningPos.m_7494_();
                        return blockState;
                    }
                    if ((this.wantedItem == null || !items.m_150930_(this.wantedItem)) && (this.wantedItems == null || !items.m_204117_(this.wantedItems)) || !blockState.m_204336_(BlockTags.f_13106_) || !TaskUtils.isInRange(this.miner, this.miningPos.m_7494_())) continue;
                    this.miningPos = this.miningPos.m_7494_();
                    return blockState;
                }
            }
            HashMap<Integer, BlockPos> map = new HashMap<Integer, BlockPos>();
            if (this.miningPos == null || !this.isValidBlock(this.miningPos) || !this.miner.m_21444_(this.miningPos)) {
                for (int x = -this.range + this.miner.m_142538_().m_123341_(); x < this.range + this.miner.m_142538_().m_123341_(); ++x) {
                    for (int y = -1 + this.miner.m_142538_().m_123342_(); y < 5 + this.miner.m_142538_().m_123342_(); ++y) {
                        for (int z = -this.range + this.miner.m_142538_().m_123343_(); z < this.range + this.miner.m_142538_().m_123343_(); ++z) {
                            BlockPos bpos = new BlockPos(x, y, z);
                            BlockState blockstate = this.miner.f_19853_.m_8055_(bpos);
                            if (blockstate.m_60713_(Blocks.f_50125_)) {
                                ItemStack items = Items.f_42452_.m_7968_();
                                if (!(this.wantedItem != null && items.m_150930_(this.wantedItem) || this.wantedItems != null && items.m_204117_(this.wantedItems)) && (this.wantedIngredient == null || !this.wantedIngredient.test(items)) || map.containsKey((int)bpos.m_203193_((Position)this.miner.m_20182_()))) continue;
                                map.put((int)bpos.m_203193_((Position)this.miner.m_20182_()), bpos);
                                continue;
                            }
                            List drops2 = Block.m_49869_((BlockState)blockstate, (ServerLevel)((ServerLevel)this.miner.f_19853_), (BlockPos)bpos, (BlockEntity)this.miner.f_19853_.m_7702_(bpos));
                            for (ItemStack items : drops2) {
                                if (!(this.wantedItem != null && items.m_150930_(this.wantedItem) || this.wantedItems != null && items.m_204117_(this.wantedItems)) && (this.wantedIngredient == null || !this.wantedIngredient.test(items)) || !this.isValidBlock(bpos) || map.containsKey((int)bpos.m_203193_((Position)this.miner.m_20182_()))) continue;
                                Vec3 vec3 = new Vec3((double)bpos.m_123341_(), (double)bpos.m_123342_(), (double)bpos.m_123343_());
                                if (blockstate.m_204336_(BlockTags.f_13106_)) {
                                    map.put((int)bpos.m_203193_((Position)this.miner.m_20182_()), bpos);
                                    continue;
                                }
                                if (this.miner.getHomePos() != null && this.miner.getHomePos().m_203195_((Position)vec3, 20.0)) continue;
                                map.put((int)bpos.m_203193_((Position)this.miner.m_20182_()), bpos);
                            }
                        }
                    }
                }
            }
            if (!map.isEmpty()) {
                for (int i = 0; i < this.range * 4; ++i) {
                    if (!map.containsKey(i)) continue;
                    this.miningPos = (BlockPos)map.get(i);
                    return this.miner.f_19853_.m_8055_(this.miningPos);
                }
            }
        }
        return null;
    }

    public List<BlockPos> getBlocksToMine(BlockPos start, int maxRange, int yRange) {
        if (TaskUtils.shouldBreakBlocks(this.miner) && start != null) {
            ArrayList<BlockPos> retval = new ArrayList<BlockPos>();
            for (int x = -maxRange + start.m_123341_(); x < maxRange + start.m_123341_(); ++x) {
                for (int y = start.m_123342_(); y < yRange + start.m_123342_(); ++y) {
                    for (int z = -maxRange + start.m_123343_(); z < maxRange + start.m_123343_(); ++z) {
                        BlockPos bpos = new BlockPos(x, y, z);
                        BlockState bstate = this.miner.f_19853_.m_8055_(bpos);
                        if (bstate.m_60713_(Blocks.f_50016_) || bstate.m_60767_().m_76336_() || bstate.m_60767_() == Material.f_76300_ || !this.isValidBlock(bpos) || !(bstate.m_60800_((BlockGetter)this.miner.f_19853_, bpos) < 100.0f) || !(bstate.m_60800_((BlockGetter)this.miner.f_19853_, bpos) >= 0.0f)) continue;
                        retval.add(bpos);
                    }
                }
            }
            if (!retval.isEmpty()) {
                return retval;
            }
        }
        return null;
    }

    public boolean isNextToBlock(BlockPos blockPos) {
        return blockPos.m_203195_((Position)this.miner.m_20182_(), 3.5);
    }

    protected boolean isValidBlock(BlockPos bpos) {
        BlockState bstate = this.miner.f_19853_.m_8055_(bpos);
        if (bstate.m_60734_() instanceof DoorBlock || bstate.m_60734_() instanceof BedBlock) {
            return false;
        }
        if (bstate.m_60713_(Blocks.f_50125_)) {
            return true;
        }
        if (this.blockToMine != null && this.blockToMine.m_204336_(BlockTags.f_13106_)) {
            return (bstate.m_204336_(BlockTags.f_13035_) || bstate.m_204336_(BlockTags.f_13106_)) && TaskUtils.isValidBlockToMine(this.miner, bpos, bstate);
        }
        return TaskUtils.isValidBlockToMine(this.miner, bpos, bstate);
    }

    protected ItemStack findTool(BlockState bstate) {
        ItemStack tool;
        if (bstate.m_204336_(BlockTags.f_144282_)) {
            this.miner.setCurrentActivity(PlayerLikeCharacter.Activity.MINING);
        } else if (bstate.m_204336_(BlockTags.f_144280_)) {
            this.miner.setCurrentActivity(PlayerLikeCharacter.Activity.CHOPPING);
        } else if (bstate.m_204336_(BlockTags.f_144283_)) {
            this.miner.setCurrentActivity(PlayerLikeCharacter.Activity.DIGGING);
        }
        if (bstate.m_204336_(BlockTags.f_13035_)) {
            this.miner.setCurrentActivity(PlayerLikeCharacter.Activity.CHOPPING);
        }
        if ((tool = this.miner.getNeededTool(this.miner.getCurrentActivity())) != null) {
            return tool;
        }
        return ItemStack.f_41583_;
    }

    public boolean mine(BlockPos bpos, BlockState bstate) {
        if (this.miner.miningCooldown <= 0 && this.isValidBlock(bpos)) {
            TaskUtils.mineBlock(this.miner, bpos, bstate, this.tool != null && this.tool.m_41735_(bstate) || !bstate.m_60834_());
            this.miner.miningCooldown = 10;
            return true;
        }
        return false;
    }
}

