/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.entity.inventory;

import net.caitie.roamers.entity.PlayerDescendant;
import net.caitie.roamers.entity.PlayerLikeCharacter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CharacterInventory
extends SimpleContainer
implements Nameable {
    public final PlayerLikeCharacter owner;

    public CharacterInventory(PlayerLikeCharacter owner) {
        super(33);
        this.owner = owner;
    }

    public ItemStack m_19173_(ItemStack stack) {
        ItemStack itemstack = stack.m_41777_();
        this.moveItemToSlotsWithSameType(itemstack);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.moveToEmptySlots(itemstack);
        return itemstack.m_41619_() ? ItemStack.f_41583_ : itemstack;
    }

    private void moveToEmptySlots(ItemStack itemStack) {
        for (int i = 6; i < this.m_6643_(); ++i) {
            ItemStack itemstack = this.m_8020_(i);
            if (!itemstack.m_41619_()) continue;
            this.m_6836_(i, itemStack.m_41777_());
            itemStack.m_41764_(0);
            return;
        }
    }

    public void swapSlots(int slot1, int slot2) {
        ItemStack item1 = this.m_8020_(slot1);
        ItemStack item2 = this.m_8020_(slot2);
        if (!item1.m_41619_() && ItemStack.m_150942_((ItemStack)item1, (ItemStack)item2)) {
            this.moveBetweenStacks(item1, item2);
            return;
        }
        this.m_6836_(slot1, item2);
        this.m_6836_(slot2, item1);
    }

    public int getItemsSlotWithItem(Item item) {
        for (int i = 6; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (!itemStack.m_150930_(item)) continue;
            return i;
        }
        return -1;
    }

    public int getItemsSlotWithTaggedItem(TagKey<Item> item) {
        for (int i = 6; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (!itemStack.m_204117_(item)) continue;
            return i;
        }
        return -1;
    }

    public int getItemsSlotWithArmorItem(EquipmentSlot slot) {
        for (int i = 6; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (!this.isArmorItem(itemStack, slot)) continue;
            return i;
        }
        return -1;
    }

    public void m_6596_() {
        super.m_6596_();
        for (int i = 0; i < 6; ++i) {
            this.checkSlots(i);
        }
        ((PlayerDescendant)this.owner).assignChore();
    }

    public void checkSlots(int i) {
        ItemStack slotItem = this.m_8020_(i);
        if (i < 4) {
            if (i == 0) {
                if (slotItem.m_41619_()) {
                    this.owner.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                } else if (this.isArmorItem(slotItem, EquipmentSlot.HEAD)) {
                    this.owner.m_8061_(EquipmentSlot.HEAD, slotItem.m_41777_());
                }
                return;
            }
            if (i == 1) {
                if (slotItem.m_41619_()) {
                    this.owner.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
                } else if (this.isArmorItem(slotItem, EquipmentSlot.CHEST)) {
                    this.owner.m_8061_(EquipmentSlot.CHEST, slotItem.m_41777_());
                }
                return;
            }
            if (i == 2) {
                if (slotItem.m_41619_()) {
                    this.owner.m_8061_(EquipmentSlot.LEGS, ItemStack.f_41583_);
                } else if (this.isArmorItem(slotItem, EquipmentSlot.LEGS)) {
                    this.owner.m_8061_(EquipmentSlot.LEGS, slotItem.m_41777_());
                }
                return;
            }
            if (i == 3) {
                if (slotItem.m_41619_()) {
                    this.owner.m_8061_(EquipmentSlot.FEET, ItemStack.f_41583_);
                } else if (this.isArmorItem(slotItem, EquipmentSlot.FEET)) {
                    this.owner.m_8061_(EquipmentSlot.FEET, slotItem.m_41777_());
                }
            }
        } else if (i == 4) {
            if (slotItem.m_41619_()) {
                this.owner.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            } else {
                this.owner.m_8061_(EquipmentSlot.MAINHAND, slotItem.m_41777_());
            }
        }
    }

    private void moveItemToSlotsWithSameType(ItemStack p_19192_) {
        for (int i = 6; i < this.m_6643_(); ++i) {
            ItemStack itemstack = this.m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)p_19192_)) continue;
            this.moveBetweenStacks(p_19192_, itemstack);
            if (!p_19192_.m_41619_()) continue;
            return;
        }
    }

    public boolean isArmorItem(ItemStack slotItem, EquipmentSlot slot) {
        return slotItem.m_41720_() instanceof ArmorItem && ((ArmorItem)slotItem.m_41720_()).m_40402_().equals((Object)slot);
    }

    private void moveBetweenStacks(ItemStack p_19186_, ItemStack p_19187_) {
        int i = Math.min(this.m_6893_(), p_19187_.m_41741_());
        int j = Math.min(p_19186_.m_41613_(), i - p_19187_.m_41613_());
        if (j > 0) {
            p_19187_.m_41769_(j);
            p_19186_.m_41774_(j);
            this.m_6596_();
        }
    }

    public boolean m_19183_(ItemStack stack) {
        boolean flag = false;
        for (int i = 0; i < 4; ++i) {
            ItemStack item = this.m_8020_(i);
            if (!(stack.m_41720_() instanceof ArmorItem) || !item.m_41619_()) continue;
            if (this.isArmorItem(stack, EquipmentSlot.HEAD) && i == 0) {
                return true;
            }
            if (this.isArmorItem(stack, EquipmentSlot.CHEST) && i == 1) {
                return true;
            }
            if (this.isArmorItem(stack, EquipmentSlot.LEGS) && i == 2) {
                return true;
            }
            if (!this.isArmorItem(stack, EquipmentSlot.FEET) || i != 3) continue;
            return true;
        }
        for (int j = 6; j < this.m_6643_(); ++j) {
            ItemStack slotItem = this.m_8020_(j);
            if (!slotItem.m_41619_() && (!ItemStack.m_150942_((ItemStack)slotItem, (ItemStack)stack) || slotItem.m_41613_() >= slotItem.m_41741_())) continue;
            flag = true;
        }
        return flag;
    }

    public Component m_7755_() {
        return this.owner.m_7755_();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_7797_(ListTag listTag) {
        for (int i = 0; i < listTag.size(); ++i) {
            int slot = listTag.m_128728_(i).m_128451_("slot");
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)listTag.m_128728_(i).m_128469_("stack"));
            if (itemstack.m_41619_()) continue;
            this.m_6836_(slot, itemstack);
        }
    }

    public ListTag m_7927_() {
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemstack = this.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag tag = new CompoundTag();
            CompoundTag tag1 = new CompoundTag();
            tag.m_128405_("slot", i);
            itemstack.m_41739_(tag1);
            tag.m_128365_("stack", (Tag)tag1);
            listtag.add((Object)tag);
        }
        return listtag;
    }
}

