/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.gui;

import com.mojang.datafixers.util.Pair;
import net.caitie.roamers.entity.AbstractCharacter;
import net.caitie.roamers.entity.PlayerDescendant;
import net.caitie.roamers.entity.inventory.CharacterInventory;
import net.caitie.roamers.init.RoamersModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class CharacterInventoryMenu
extends AbstractContainerMenu {
    public static final ResourceLocation BLOCK_ATLAS = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_HELMET = new ResourceLocation("item/empty_armor_slot_helmet");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_CHESTPLATE = new ResourceLocation("item/empty_armor_slot_chestplate");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_LEGGINGS = new ResourceLocation("item/empty_armor_slot_leggings");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_BOOTS = new ResourceLocation("item/empty_armor_slot_boots");
    static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{EMPTY_ARMOR_SLOT_BOOTS, EMPTY_ARMOR_SLOT_LEGGINGS, EMPTY_ARMOR_SLOT_CHESTPLATE, EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public BlockPos blockPosition;
    public final Player player;
    public AbstractCharacter owner;
    public CharacterInventory inventory;
    public final Level level;

    public CharacterInventoryMenu(int id, Inventory inv, FriendlyByteBuf byteBuf) {
        super((MenuType)RoamersModMenus.CHARACTER_INVENTORY.get(), id);
        this.player = inv.f_35978_;
        this.level = this.player.f_19853_;
        if (byteBuf != null) {
            this.blockPosition = byteBuf.m_130135_();
        }
        if (this.blockPosition != null && byteBuf.readableBytes() > 1) {
            byteBuf.readByte();
            Entity entity = this.level.m_6815_(byteBuf.m_130242_());
            if (entity instanceof PlayerDescendant) {
                int l;
                PlayerDescendant plrDes = (PlayerDescendant)entity;
                this.owner = plrDes;
                this.inventory = (CharacterInventory)plrDes.getInventory();
                this.inventory.m_5856_(this.player);
                for (int k = 0; k < 4; ++k) {
                    final EquipmentSlot equipmentslot = SLOT_IDS[k];
                    this.m_38897_(new Slot((Container)this.inventory, k, 8, 8 + k * 18){

                        public int m_6641_() {
                            return 1;
                        }

                        public boolean m_5857_(ItemStack itemStack) {
                            return itemStack.canEquip(equipmentslot, (Entity)CharacterInventoryMenu.this.owner);
                        }

                        public boolean m_8010_(Player player) {
                            ItemStack itemstack = this.m_7993_();
                            return (itemstack.m_41619_() || player.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)itemstack)) && super.m_8010_(player);
                        }

                        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                            return Pair.of((Object)BLOCK_ATLAS, (Object)TEXTURE_EMPTY_SLOTS[equipmentslot.m_20749_()]);
                        }
                    });
                }
                this.m_38897_(new Slot((Container)this.inventory, 4, 77, 62));
                this.m_38897_(new Slot((Container)this.inventory, 5, 77, 42));
                for (l = 0; l < 3; ++l) {
                    for (int j1 = 0; j1 < 9; ++j1) {
                        this.m_38897_(new Slot((Container)this.inventory, 6 + (j1 + l * 9), 8 + j1 * 18, 84 + l * 18));
                    }
                }
                for (l = 0; l < 3; ++l) {
                    for (int j1 = 0; j1 < 9; ++j1) {
                        this.m_38897_(new Slot((Container)inv, j1 + l * 9 + 9, 8 + j1 * 18, 141 + l * 18));
                    }
                }
                for (int i1 = 0; i1 < 9; ++i1) {
                    this.m_38897_(new Slot((Container)inv, i1, 8 + i1 * 18, 199));
                }
            }
        }
    }

    public ItemStack m_7648_(Player plr, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            int i;
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)itemstack);
            if (index == 0) {
                if (!this.m_38903_(itemstack1, 9, 45, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index >= 1 && index < 5 ? !this.m_38903_(itemstack1, 9, 45, false) : (index >= 5 && index < 9 ? !this.m_38903_(itemstack1, 9, 45, false) : (equipmentslot.m_20743_() == EquipmentSlot.Type.ARMOR && !((Slot)this.f_38839_.get(8 - equipmentslot.m_20749_())).m_6657_() ? !this.m_38903_(itemstack1, i = 8 - equipmentslot.m_20749_(), i + 1, false) : (equipmentslot == EquipmentSlot.OFFHAND && !((Slot)this.f_38839_.get(45)).m_6657_() ? !this.m_38903_(itemstack1, 45, 46, false) : (index >= 9 && index < 36 ? !this.m_38903_(itemstack1, 36, 45, false) : (index >= 36 && index < 45 ? !this.m_38903_(itemstack1, 9, 36, false) : !this.m_38903_(itemstack1, 9, 45, false))))))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(plr, itemstack1);
            if (index == 0) {
                plr.m_36176_(itemstack1, false);
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return this.owner.m_6084_() && this.inventory.m_6542_(player) && this.owner.m_20280_((Entity)this.player) <= 12.0;
    }

    public void m_6877_(Player plr) {
        super.m_6877_(plr);
        this.inventory.m_5785_(plr);
    }
}

