/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RoamersRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> ingredients;
    private final NonNullList<Integer> amounts;

    public RoamersRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> ingredients, NonNullList<Integer> amounts) {
        this.id = id;
        this.output = output;
        this.ingredients = ingredients;
        this.amounts = amounts;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public NonNullList<Integer> getAmounts() {
        return this.amounts;
    }

    public boolean matches(SimpleContainer container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        int flag = 0;
        block0: for (int i = 0; i < this.m_7527_().size(); ++i) {
            for (int j = 0; j < container.m_6643_(); ++j) {
                ItemStack item = container.m_8020_(i);
                if (!((Ingredient)this.m_7527_().get(i)).test(item) || item.m_41613_() < (Integer)this.getAmounts().get(i)) continue;
                ++flag;
                continue block0;
            }
        }
        return flag >= this.m_7527_().size();
    }

    public ItemStack assemble(SimpleContainer container) {
        return this.output;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<RoamersRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("roamers", "roamers_crafting");

        public RoamersRecipe fromJson(ResourceLocation location, JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)ingredients.size(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            JsonArray amounts = GsonHelper.m_13933_((JsonObject)json, (String)"amounts");
            NonNullList amountList = NonNullList.m_122780_((int)amounts.size(), (Object)1);
            for (int i = 0; i < amounts.size(); ++i) {
                amountList.set(i, (Object)amounts.get(i).getAsInt());
            }
            return new RoamersRecipe(location, output, (NonNullList<Ingredient>)inputs, (NonNullList<Integer>)amountList);
        }

        @Nullable
        public RoamersRecipe fromNetwork(ResourceLocation location, FriendlyByteBuf byteBuf) {
            int i;
            NonNullList inputs = NonNullList.m_122780_((int)byteBuf.readInt(), (Object)Ingredient.f_43901_);
            NonNullList amounts = NonNullList.m_122780_((int)byteBuf.readInt(), (Object)1);
            for (i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)byteBuf));
            }
            for (i = 0; i < amounts.size(); ++i) {
                amounts.set(i, (Object)byteBuf.readInt());
            }
            ItemStack output = byteBuf.m_130267_();
            return new RoamersRecipe(location, output, (NonNullList<Ingredient>)inputs, (NonNullList<Integer>)amounts);
        }

        public void toNetwork(FriendlyByteBuf byteBuf, RoamersRecipe recipe) {
            byteBuf.writeInt(recipe.m_7527_().size());
            byteBuf.writeInt(recipe.getAmounts().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(byteBuf);
            }
            for (Integer in : recipe.getAmounts()) {
                byteBuf.writeInt(in.intValue());
            }
            byteBuf.writeItemStack(recipe.m_8043_(), false);
        }

        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(RecipeSerializer.class);
        }

        private static <G> Class<G> castClass(Class<?> cls) {
            return cls;
        }
    }

    public static class Type
    implements RecipeType<RoamersRecipe> {
        public static final Type INSTANCE = new Type();
        public static final ResourceLocation ID = new ResourceLocation("roamers", "roamers_crafting");

        private Type() {
        }
    }
}

