/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class SpawnStructure
extends StructureFeature<JigsawConfiguration> {
    public static final Codec<JigsawConfiguration> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(JigsawConfiguration::m_204802_), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(JigsawConfiguration::m_67765_)).apply((Applicative)codec, JigsawConfiguration::new));

    public SpawnStructure() {
        super(CODEC, SpawnStructure::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    private static boolean checkSpawning(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        ChunkPos chunkpos = context.f_197355_();
        int height = context.f_197352_().m_156179_(chunkpos.m_45604_(), chunkpos.m_45605_(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, context.f_197357_());
        return height >= 64 && height <= 70;
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        if (!SpawnStructure.checkSpawning(context)) {
            return Optional.empty();
        }
        BlockPos blockpos = context.f_197355_().m_151394_(0);
        Optional structurePiecesGenerator = JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)blockpos, (boolean)false, (boolean)true);
        return structurePiecesGenerator;
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }
}

