/*
 * Decompiled with CFR 0.152.
 */
package net.caitie.roamers.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.caitie.roamers.entity.PlayerLike;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class BuilderData {
    public static final BlockState DEFAULT_BLOCK_STATE = Blocks.f_50016_.m_49966_();
    public static final String TAG_NAME = "BuilderData";
    private final IdMapper<BlockState> ids = new IdMapper(16);
    public String structureLoc = "";
    private Rotation rotation = Rotation.NONE;
    private Vec3i structureSize = Vec3i.f_123288_;
    private final Map<BlockPos, BlockState> materials = new HashMap<BlockPos, BlockState>();

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("BuildingResource", this.structureLoc);
        tag.m_128359_("Rotation", this.rotation.toString());
        return tag;
    }

    public void read(CompoundTag tag) {
        if (tag.m_128441_("BuildingResource")) {
            this.structureLoc = tag.m_128461_("BuildingResource");
            if (!this.structureLoc.isBlank() && !this.structureLoc.isEmpty()) {
                this.rotation = Rotation.valueOf((String)tag.m_128461_("Rotation"));
                this.readStructure();
            }
        }
    }

    public void update() {
        if (!this.structureLoc.isBlank() && !this.structureLoc.isEmpty() && this.structureSize == Vec3i.f_123288_) {
            this.readStructure();
        }
    }

    public BuilderData loadOrCreate(PlayerLike plike, CompoundTag tag) {
        if (tag.m_128441_(TAG_NAME)) {
            BuilderData builder = new BuilderData();
            builder.read(tag);
            return builder;
        }
        if (this.structureLoc.isBlank() || this.structureLoc.isEmpty()) {
            this.setStructureLocation(plike.race().toString().toLowerCase() + "_" + plike.getBuildingGoal().toString().toLowerCase() + "0");
        }
        CompoundTag newTag = this.save();
        tag.m_128365_(TAG_NAME, (Tag)newTag);
        this.read(newTag);
        return this;
    }

    private void readStructure() {
        try {
            ClassLoader cloader = this.getClass().getClassLoader();
            InputStream is = cloader.getResourceAsStream(this.structureLoc + ".nbt");
            if (is != null) {
                CompoundTag tag = NbtIo.m_128939_((InputStream)is);
                this.parseStructure(tag);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public Vec3i getSize() {
        return this.structureSize;
    }

    public Map<BlockPos, BlockState> getBuildingMaterials() {
        return this.materials;
    }

    public void setStructureLocation(String filename) {
        this.structureLoc = "./data/roamers/structures/" + filename;
    }

    protected void parseStructure(CompoundTag tag) {
        ListTag sizetag = tag.m_128437_("size", 3);
        this.structureSize = new Vec3i(sizetag.m_128763_(0), sizetag.m_128763_(1), sizetag.m_128763_(2));
        ListTag blockstag = tag.m_128437_("blocks", 10);
        this.loadPalette(tag.m_128437_("palette", 10), blockstag);
    }

    private void loadPalette(ListTag tag, ListTag tag2) {
        for (int j = 0; j < tag.size(); ++j) {
            this.ids.m_122664_((Object)NbtUtils.m_129241_((CompoundTag)tag.m_128728_(j)), j);
        }
        for (int i = 0; i < tag2.size(); ++i) {
            CompoundTag comptag = tag2.m_128728_(i);
            ListTag list = comptag.m_128437_("pos", 3);
            BlockPos bpos = new BlockPos(list.m_128763_(0), list.m_128763_(1), list.m_128763_(2));
            BlockState bstate = this.stateFor(comptag.m_128451_("state"));
            this.materials.put(bpos, bstate);
        }
    }

    @Nullable
    protected BlockState stateFor(int i) {
        BlockState blockstate = (BlockState)this.ids.m_7942_(i);
        return blockstate == null ? DEFAULT_BLOCK_STATE : blockstate;
    }
}

